/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.client.api.XmlParser;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.XmlContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.InheritanceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AppIndexingApiDetector
extends Detector
implements Detector.XmlScanner,
Detector.UastScanner {
    private static final Implementation URL_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, Scope.MANIFEST_SCOPE);
    private static final Implementation APP_INDEXING_API_IMPLEMENTATION = new Implementation(AppIndexingApiDetector.class, EnumSet.of(Scope.JAVA_FILE, Scope.MANIFEST), Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE);
    public static final Issue ISSUE_URL_ERROR = Issue.create("GoogleAppIndexingUrlError", "URL not supported by app for Google App Indexing", "Ensure the URL is supported by your app, to get installs and traffic to your app from Google Search.", Category.USABILITY, 5, Severity.ERROR, URL_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    public static final Issue ISSUE_APP_INDEXING = Issue.create("GoogleAppIndexingWarning", "Missing support for Google App Indexing", "Adds URLs to get your app into the Google index, to get installs and traffic to your app from Google Search.", Category.USABILITY, 5, Severity.WARNING, URL_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
    public static final Issue ISSUE_APP_INDEXING_API = Issue.create("GoogleAppIndexingApiWarning", "Missing support for Google App Indexing Api", "Adds URLs to get your app into the Google index, to get installs and traffic to your app from Google Search.", Category.USABILITY, 5, Severity.WARNING, APP_INDEXING_API_IMPLEMENTATION).addMoreInfo("https://g.co/AppIndexing/AndroidStudio").setEnabledByDefault(false);
    private static final String[] PATH_ATTR_LIST = new String[]{"pathPrefix", "path"};
    private static final String SCHEME_MISSING = "android:scheme is missing";
    private static final String HOST_MISSING = "android:host is missing";
    private static final String DATA_MISSING = "Missing data element";
    private static final String URL_MISSING = "Missing URL for the intent filter";
    private static final String NOT_BROWSABLE = "Activity supporting ACTION_VIEW is not set as BROWSABLE";
    private static final String ILLEGAL_NUMBER = "android:port is not a legal number";
    private static final String APP_INDEX_START = "start";
    private static final String APP_INDEX_END = "end";
    private static final String APP_INDEX_VIEW = "view";
    private static final String APP_INDEX_VIEW_END = "viewEnd";
    private static final String CLIENT_CONNECT = "connect";
    private static final String CLIENT_DISCONNECT = "disconnect";
    private static final String ADD_API = "addApi";
    private static final String APP_INDEXING_API_CLASS = "com.google.android.gms.appindexing.AppIndexApi";
    private static final String GOOGLE_API_CLIENT_CLASS = "com.google.android.gms.common.api.GoogleApiClient";
    private static final String GOOGLE_API_CLIENT_BUILDER_CLASS = "com.google.android.gms.common.api.GoogleApiClient.Builder";
    private static final String API_CLASS = "com.google.android.gms.appindexing.AppIndex";

    @Override
    @Nullable
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("application");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element application) {
        List<Element> activities = AppIndexingApiDetector.extractChildrenByName(application, "activity");
        boolean applicationHasActionView = false;
        for (Element activity : activities) {
            Attr exported;
            List<Element> intents = AppIndexingApiDetector.extractChildrenByName(activity, "intent-filter");
            boolean activityHasActionView = false;
            for (Element intent : intents) {
                boolean actionView = AppIndexingApiDetector.hasActionView(intent);
                if (actionView) {
                    activityHasActionView = true;
                }
                AppIndexingApiDetector.visitIntent(context, intent);
            }
            if (!activityHasActionView) continue;
            applicationHasActionView = true;
            if (!activity.hasAttributeNS("http://schemas.android.com/apk/res/android", "exported") || (exported = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported")).getValue().equals("true")) continue;
            context.report(ISSUE_URL_ERROR, activity, context.getLocation(activity), "Activity supporting ACTION_VIEW is not exported");
        }
        if (!applicationHasActionView && !context.getProject().isLibrary()) {
            context.report(ISSUE_APP_INDEXING, application, context.getLocation(application), "App is not indexable by Google Search; consider adding at least one Activity with an ACTION-VIEW intent filter. See issue explanation for more details.");
        }
    }

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.app.Activity");
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull UClass declaration2) {
        if (declaration2.getName() == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)declaration2, (boolean)true, (String)"android.app.Activity")) {
            return;
        }
        declaration2.accept(new MethodVisitor(context, declaration2));
    }

    private static Set<String> getActivitiesToCheck(Context context) {
        HashSet activitiesToCheck = Sets.newHashSet();
        List<File> manifestFiles = context.getProject().getManifestFiles();
        XmlParser xmlParser = context.getDriver().getClient().getXmlParser();
        if (xmlParser != null) {
            for (File manifest : manifestFiles) {
                XmlContext xmlContext = new XmlContext(context.getDriver(), context.getProject(), null, manifest, null, xmlParser);
                Document doc = xmlParser.parseXml(xmlContext);
                if (doc == null) continue;
                List<Element> children = LintUtils.getChildren(doc);
                for (Element child : children) {
                    if (!child.getNodeName().equals("manifest")) continue;
                    List<Element> apps = AppIndexingApiDetector.extractChildrenByName(child, "application");
                    for (Element app : apps) {
                        List<Element> acts = AppIndexingApiDetector.extractChildrenByName(app, "activity");
                        for (Element act : acts) {
                            List<Element> intents = AppIndexingApiDetector.extractChildrenByName(act, "intent-filter");
                            for (Element intent : intents) {
                                String pkg;
                                List<Element> data = AppIndexingApiDetector.extractChildrenByName(intent, "data");
                                if (data.isEmpty() || !act.hasAttributeNS("http://schemas.android.com/apk/res/android", "name")) continue;
                                Attr attr = act.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                                String activityName = attr.getValue();
                                int dotIndex = activityName.indexOf(46);
                                if (dotIndex <= 0 && (pkg = context.getMainProject().getPackage()) != null) {
                                    activityName = dotIndex == 0 ? pkg + activityName : pkg + '.' + activityName;
                                }
                                activitiesToCheck.add(activityName);
                            }
                        }
                    }
                }
            }
        }
        return activitiesToCheck;
    }

    private static void visitIntent(@NonNull XmlContext context, @NonNull Element intent) {
        boolean actionView = AppIndexingApiDetector.hasActionView(intent);
        boolean browsable = AppIndexingApiDetector.isBrowsable(intent);
        boolean isHttp = false;
        boolean hasScheme = false;
        boolean hasHost = false;
        boolean hasPort = false;
        boolean hasPath = false;
        boolean hasMimeType = false;
        Element firstData = null;
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "data");
        for (Element data : children) {
            if (firstData == null) {
                firstData = data;
            }
            if (AppIndexingApiDetector.isHttpSchema(data)) {
                isHttp = true;
            }
            AppIndexingApiDetector.checkSingleData(context, data);
            for (String name : PATH_ATTR_LIST) {
                if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name)) continue;
                hasPath = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme")) {
                hasScheme = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) {
                hasHost = true;
            }
            if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
                hasPort = true;
            }
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", "mimeType")) continue;
            hasMimeType = true;
        }
        if ((hasPath || hasHost || hasPort) && !hasScheme) {
            context.report(ISSUE_URL_ERROR, firstData, context.getLocation(firstData), SCHEME_MISSING);
        }
        if ((hasPath || hasPort) && !hasHost) {
            context.report(ISSUE_URL_ERROR, firstData, context.getLocation(firstData), HOST_MISSING);
        }
        if (actionView && browsable) {
            if (firstData == null) {
                context.report(ISSUE_URL_ERROR, intent, context.getLocation(intent), DATA_MISSING);
            } else if (!hasScheme && !hasMimeType) {
                context.report(ISSUE_URL_ERROR, firstData, context.getLocation(firstData), URL_MISSING);
            }
        }
        if (actionView && isHttp && !browsable) {
            context.report(ISSUE_APP_INDEXING, intent, context.getLocation(intent), NOT_BROWSABLE);
        }
        if (actionView && !hasScheme) {
            context.report(ISSUE_APP_INDEXING, intent, context.getLocation(intent), "Missing URL");
        }
    }

    private static boolean hasActionView(@NonNull Element intent) {
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "action");
        for (Element action : children) {
            Attr attr;
            if (!action.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue().equals("android.intent.action.VIEW")) continue;
            return true;
        }
        return false;
    }

    private static boolean isBrowsable(@NonNull Element intent) {
        List<Element> children = AppIndexingApiDetector.extractChildrenByName(intent, "category");
        for (Element e : children) {
            Attr attr;
            if (!e.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue().equals("android.intent.category.BROWSABLE")) continue;
            return true;
        }
        return false;
    }

    private static boolean isHttpSchema(@NonNull Element data) {
        String value2;
        return data.hasAttributeNS("http://schemas.android.com/apk/res/android", "scheme") && ((value2 = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "scheme").getValue()).equalsIgnoreCase("http") || value2.equalsIgnoreCase("https"));
    }

    private static void checkSingleData(@NonNull XmlContext context, @NonNull Element data) {
        for (String name : PATH_ATTR_LIST) {
            Attr attr;
            String path;
            if (!data.hasAttributeNS("http://schemas.android.com/apk/res/android", name) || (path = AppIndexingApiDetector.replaceUrlWithValue(context, (attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", name)).getValue())).startsWith("/") || path.startsWith("@")) continue;
            context.report(ISSUE_URL_ERROR, attr, context.getLocation(attr), "android:" + name + " attribute should start with '/', but it is : " + path);
        }
        if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "port")) {
            Attr attr = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "port");
            try {
                String port = AppIndexingApiDetector.replaceUrlWithValue(context, attr.getValue());
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                context.report(ISSUE_URL_ERROR, attr, context.getLocation(attr), ILLEGAL_NUMBER);
            }
        }
        NamedNodeMap attrs = data.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr;
            Node item = attrs.item(i);
            if (item.getNodeType() != 2 || !(attr = (Attr)attrs.item(i)).getValue().isEmpty()) continue;
            context.report(ISSUE_URL_ERROR, attr, context.getLocation(attr), attr.getName() + " cannot be empty");
        }
    }

    private static String replaceUrlWithValue(@NonNull XmlContext context, @NonNull String str) {
        Project project = context.getProject();
        LintClient client = context.getClient();
        if (!client.supportsProjectResources()) {
            return str;
        }
        ResourceUrl style = ResourceUrl.parse((String)str);
        if (style == null || style.type != ResourceType.STRING || style.framework) {
            return str;
        }
        AbstractResourceRepository resources = client.getProjectResources(project, true);
        if (resources == null) {
            return str;
        }
        List items = resources.getResourceItem(ResourceType.STRING, style.name);
        if (items == null || items.isEmpty()) {
            return str;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
        if (resourceValue == null) {
            return str;
        }
        return resourceValue.getValue() == null ? str : resourceValue.getValue();
    }

    private static boolean hasFirstArgument(UExpression argument, List<UCallExpression> list) {
        for (UCallExpression call : list) {
            List<UExpression> expressions2 = call.getValueArguments();
            if (expressions2.isEmpty()) continue;
            UExpression argument2 = expressions2.get(0);
            if (!argument.asSourceString().equals(argument2.asSourceString())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOperand(UExpression operand2, List<UCallExpression> list) {
        for (UCallExpression method : list) {
            UExpression operand22 = method.getReceiver();
            if (operand22 == null || !operand2.asSourceString().equals(operand22.asSourceString())) continue;
            return true;
        }
        return false;
    }

    private static List<Element> extractChildrenByName(@NonNull Element node, @NonNull String name) {
        ArrayList result = Lists.newArrayList();
        List<Element> children = LintUtils.getChildren(node);
        for (Element child : children) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result;
    }

    static class MethodVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;
        private final UClass mCls;
        private final List<UCallExpression> mStartMethods;
        private final List<UCallExpression> mEndMethods;
        private final List<UCallExpression> mConnectMethods;
        private final List<UCallExpression> mDisconnectMethods;
        private boolean mHasAddAppIndexApi;

        private MethodVisitor(JavaContext context, UClass cls) {
            this.mCls = cls;
            this.mContext = context;
            this.mStartMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mEndMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mConnectMethods = Lists.newArrayListWithExpectedSize((int)2);
            this.mDisconnectMethods = Lists.newArrayListWithExpectedSize((int)2);
        }

        @Override
        public boolean visitClass(UClass aClass) {
            if (aClass.getPsi().equals(this.mCls.getPsi())) {
                return super.visitClass(aClass);
            }
            return true;
        }

        @Override
        public void afterVisitClass(UClass node) {
            this.report();
        }

        @Override
        public boolean visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isMethodCall(node)) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitMethodCallExpression(UCallExpression node) {
            PsiElement resolved;
            List<UExpression> args;
            String methodName2 = node.getMethodName();
            if (methodName2 == null) {
                return;
            }
            if (methodName2.equals(AppIndexingApiDetector.APP_INDEX_START)) {
                if (JavaEvaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mStartMethods.add(node);
                }
            } else if (methodName2.equals(AppIndexingApiDetector.APP_INDEX_END)) {
                if (JavaEvaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mEndMethods.add(node);
                }
            } else if (methodName2.equals(AppIndexingApiDetector.APP_INDEX_VIEW)) {
                if (JavaEvaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mStartMethods.add(node);
                }
            } else if (methodName2.equals(AppIndexingApiDetector.APP_INDEX_VIEW_END)) {
                if (JavaEvaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.APP_INDEXING_API_CLASS)) {
                    this.mEndMethods.add(node);
                }
            } else if (methodName2.equals(AppIndexingApiDetector.CLIENT_CONNECT)) {
                if (JavaEvaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) {
                    this.mConnectMethods.add(node);
                }
            } else if (methodName2.equals(AppIndexingApiDetector.CLIENT_DISCONNECT)) {
                if (JavaEvaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.GOOGLE_API_CLIENT_CLASS)) {
                    this.mDisconnectMethods.add(node);
                }
            } else if (methodName2.equals(AppIndexingApiDetector.ADD_API) && JavaEvaluator.isMemberInClass((PsiMember)node.resolve(), AppIndexingApiDetector.GOOGLE_API_CLIENT_BUILDER_CLASS) && !(args = node.getValueArguments()).isEmpty() && (resolved = UastUtils.tryResolve(args.get(0))) instanceof PsiField && JavaEvaluator.isMemberInClass((PsiMember)((PsiField)resolved), AppIndexingApiDetector.API_CLASS)) {
                this.mHasAddAppIndexApi = true;
            }
        }

        private void report() {
            String message2;
            List<UExpression> expressions2;
            Set activitiesToCheck = AppIndexingApiDetector.getActivitiesToCheck(this.mContext);
            boolean hasIntent = activitiesToCheck.contains(this.mCls.getQualifiedName());
            if (!hasIntent) {
                for (UCallExpression call : this.mStartMethods) {
                    this.mContext.report(ISSUE_APP_INDEXING_API, call, this.mContext.getUastNameLocation(call), "Missing support for Google App Indexing in the manifest");
                }
                for (UCallExpression call : this.mEndMethods) {
                    this.mContext.report(ISSUE_APP_INDEXING_API, call, this.mContext.getUastNameLocation(call), "Missing support for Google App Indexing in the manifest");
                }
                return;
            }
            if (this.mStartMethods.isEmpty() && this.mEndMethods.isEmpty()) {
                this.mContext.reportUast(ISSUE_APP_INDEXING_API, this.mCls, this.mContext.getUastNameLocation(this.mCls), "Missing support for Google App Indexing API");
                return;
            }
            for (UCallExpression startNode : this.mStartMethods) {
                expressions2 = startNode.getValueArguments();
                if (expressions2.isEmpty()) continue;
                UExpression startClient = expressions2.get(0);
                if (!this.mHasAddAppIndexApi) {
                    message2 = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", startClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, startClient, this.mContext.getUastLocation(startClient), message2);
                }
                if (!AppIndexingApiDetector.hasOperand(startClient, this.mConnectMethods)) {
                    message2 = String.format("GoogleApiClient `%1$s` is not connected", startClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, startClient, this.mContext.getUastLocation(startClient), message2);
                }
                if (AppIndexingApiDetector.hasFirstArgument(startClient, this.mEndMethods)) continue;
                this.mContext.report(ISSUE_APP_INDEXING_API, startNode, this.mContext.getUastNameLocation(startNode), "Missing corresponding `AppIndex.AppIndexApi.end` method");
            }
            for (UCallExpression endNode : this.mEndMethods) {
                expressions2 = endNode.getValueArguments();
                if (expressions2.isEmpty()) continue;
                UExpression endClient = expressions2.get(0);
                if (!this.mHasAddAppIndexApi) {
                    message2 = String.format("GoogleApiClient `%1$s` has not added support for App Indexing API", endClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, endClient, this.mContext.getUastLocation(endClient), message2);
                }
                if (!AppIndexingApiDetector.hasOperand(endClient, this.mDisconnectMethods)) {
                    message2 = String.format("GoogleApiClient `%1$s` is not disconnected", endClient.asSourceString());
                    this.mContext.report(ISSUE_APP_INDEXING_API, endClient, this.mContext.getUastLocation(endClient), message2);
                }
                if (AppIndexingApiDetector.hasFirstArgument(endClient, this.mStartMethods)) continue;
                this.mContext.report(ISSUE_APP_INDEXING_API, endNode, this.mContext.getUastNameLocation(endNode), "Missing corresponding `AppIndex.AppIndexApi.start` method");
            }
        }
    }

    public static enum IssueType {
        SCHEME_MISSING("android:scheme is missing"),
        HOST_MISSING("android:host is missing"),
        DATA_MISSING("Missing data element"),
        URL_MISSING("Missing URL for the intent filter"),
        NOT_BROWSABLE("Activity supporting ACTION_VIEW is not set as BROWSABLE"),
        ILLEGAL_NUMBER("android:port is not a legal number"),
        EMPTY_FIELD("cannot be empty"),
        MISSING_SLASH("attribute should start with '/'"),
        UNKNOWN("unknown error type");

        private final String message;

        private IssueType(String str) {
            this.message = str;
        }

        public static IssueType parse(String str) {
            for (IssueType type2 : IssueType.values()) {
                if (!str.contains(type2.message)) continue;
                return type2;
            }
            return UNKNOWN;
        }
    }
}

