/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class AddJavascriptInterfaceDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("AddJavascriptInterface", "addJavascriptInterface Called", "For applications built for API levels below 17, `WebView#addJavascriptInterface` presents a security hazard as JavaScript on the target web page has the ability to use reflection to access the injected object's public fields and thus manipulate the host application in unintended ways.", Category.SECURITY, 9, Severity.WARNING, new Implementation(AddJavascriptInterfaceDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://labs.mwrinfosecurity.com/blog/2013/09/24/webview-addjavascriptinterface-remote-code-execution/");
    private static final String WEB_VIEW = "android.webkit.WebView";
    private static final String ADD_JAVASCRIPT_INTERFACE = "addJavascriptInterface";

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(ADD_JAVASCRIPT_INTERFACE);
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod method) {
        if (context.getMainProject().getMinSdk() >= 17) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (!evaluator.methodMatches(method, WEB_VIEW, true, "java.lang.Object", "java.lang.String")) {
            return;
        }
        String message2 = "`WebView.addJavascriptInterface` should not be called with minSdkVersion < 17 for security reasons: JavaScript can use reflection to manipulate application";
        UElement reportElement = call.getMethodIdentifier();
        if (reportElement == null) {
            reportElement = call;
        }
        context.reportUast(ISSUE, reportElement, context.getUastNameLocation(reportElement), message2);
    }
}

