/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class MavenProjectImporter {
    private static final Logger LOG = Logger.getInstance(MavenProjectImporter.class);
    private final Project myProject;
    private final MavenProjectsTree myProjectsTree;
    private final Map<VirtualFile, Module> myFileToModuleMapping;
    private volatile Map<MavenProject, MavenProjectChanges> myProjectsToImportWithChanges;
    private volatile Set<MavenProject> myAllProjects;
    private final boolean myImportModuleGroupsRequired;
    private final IdeModifiableModelsProvider myModelsProvider;
    private final MavenImportingSettings myImportingSettings;
    private final ModifiableModuleModel myModuleModel;
    private final List<Module> myCreatedModules = new ArrayList<Module>();
    private final Map<MavenProject, Module> myMavenProjectToModule = new THashMap();
    private final Map<MavenProject, String> myMavenProjectToModuleName = new THashMap();
    private final Map<MavenProject, String> myMavenProjectToModulePath = new THashMap();

    public MavenProjectImporter(Project p, MavenProjectsTree projectsTree, Map<VirtualFile, Module> fileToModuleMapping, Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, boolean importModuleGroupsRequired, IdeModifiableModelsProvider modelsProvider, MavenImportingSettings importingSettings) {
        this.myProject = p;
        this.myProjectsTree = projectsTree;
        this.myFileToModuleMapping = fileToModuleMapping;
        this.myProjectsToImportWithChanges = projectsToImportWithChanges;
        this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        this.myModelsProvider = modelsProvider;
        this.myImportingSettings = importingSettings;
        this.myModuleModel = modelsProvider.getModifiableModuleModel();
    }

    @Nullable
    public List<MavenProjectsProcessorTask> importProject() {
        ArrayList<MavenProjectsProcessorTask> postTasks = new ArrayList<MavenProjectsProcessorTask>();
        this.myAllProjects = new LinkedHashSet<MavenProject>(this.myProjectsTree.getProjects());
        this.myAllProjects.addAll(this.myProjectsToImportWithChanges.keySet());
        boolean hasChanges = this.deleteIncompatibleModules();
        this.myProjectsToImportWithChanges = this.collectProjectsToImport(this.myProjectsToImportWithChanges);
        this.mapMavenProjectsToModulesAndNames();
        if (this.myProject.isDisposed()) {
            return null;
        }
        boolean projectsHaveChanges = this.projectsToImportHaveChanges();
        if (projectsHaveChanges) {
            hasChanges = true;
            this.importModules(postTasks);
            this.scheduleRefreshResolvedArtifacts(postTasks);
        }
        if (projectsHaveChanges || this.myImportModuleGroupsRequired) {
            hasChanges = true;
            this.configModuleGroups();
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        try {
            boolean modulesDeleted = this.deleteObsoleteModules();
            if (hasChanges |= modulesDeleted) {
                this.removeUnusedProjectLibraries();
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            this.disposeModifiableModels();
            LOG.error((Throwable)e);
            return null;
        }
        if (hasChanges) {
            MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> {
                this.myModelsProvider.commit();
                if (projectsHaveChanges) {
                    this.removeOutdatedCompilerConfigSettings();
                    for (MavenProject mavenProject : this.myAllProjects) {
                        Module module = this.myMavenProjectToModule.get(mavenProject);
                        if (module != null && module.isDisposed()) {
                            module = null;
                        }
                        for (MavenModuleConfigurer configurer : MavenModuleConfigurer.getConfigurers()) {
                            configurer.configure(mavenProject, this.myProject, module);
                        }
                    }
                }
            });
        } else {
            this.disposeModifiableModels();
        }
        return postTasks;
    }

    private void disposeModifiableModels() {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.myModelsProvider.dispose());
    }

    private boolean projectsToImportHaveChanges() {
        for (MavenProjectChanges each : this.myProjectsToImportWithChanges.values()) {
            if (!each.hasChanges()) continue;
            return true;
        }
        return false;
    }

    private Map<MavenProject, MavenProjectChanges> collectProjectsToImport(Map<MavenProject, MavenProjectChanges> projectsToImport) {
        THashMap result = new THashMap(projectsToImport);
        result.putAll(this.collectNewlyCreatedProjects());
        Set<MavenProject> allProjectsToImport = result.keySet();
        Set<MavenProject> selectedProjectsToImport = this.selectProjectsToImport(allProjectsToImport);
        Iterator<MavenProject> it = allProjectsToImport.iterator();
        while (it.hasNext()) {
            if (selectedProjectsToImport.contains(it.next())) continue;
            it.remove();
        }
        return result;
    }

    private Map<MavenProject, MavenProjectChanges> collectNewlyCreatedProjects() {
        THashMap result = new THashMap();
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module != null) continue;
            result.put(each, MavenProjectChanges.ALL);
        }
        return result;
    }

    private Set<MavenProject> selectProjectsToImport(Collection<MavenProject> originalProjects) {
        THashSet result = new THashSet();
        for (MavenProject each : originalProjects) {
            if (!this.shouldCreateModuleFor(each)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean shouldCreateModuleFor(MavenProject project) {
        if (this.myProjectsTree.isIgnored(project)) {
            return false;
        }
        return !project.isAggregator() || this.myImportingSettings.isCreateModulesForAggregators();
    }

    private boolean deleteIncompatibleModules() {
        Pair<List<Pair<MavenProject, Module>>, List<Pair<MavenProject, Module>>> incompatible = this.collectIncompatibleModulesWithProjects();
        List incompatibleMavenized = (List)incompatible.first;
        List incompatibleNotMavenized = (List)incompatible.second;
        if (incompatibleMavenized.isEmpty() && incompatibleNotMavenized.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Pair each : incompatibleMavenized) {
            this.myFileToModuleMapping.remove(((MavenProject)each.first).getFile());
            this.myModuleModel.disposeModule((Module)each.second);
            changed |= true;
        }
        if (incompatibleNotMavenized.isEmpty()) {
            return changed;
        }
        int[] result = new int[1];
        MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), () -> {
            String message = ProjectBundle.message("maven.import.incompatible.modules", incompatibleNotMavenized.size(), MavenProjectImporter.formatProjectsWithModules(incompatibleNotMavenized));
            String[] options = new String[]{ProjectBundle.message("maven.import.incompatible.modules.recreate", new Object[0]), ProjectBundle.message("maven.import.incompatible.modules.ignore", new Object[0])};
            result[0] = Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)ProjectBundle.message("maven.project.import.title", new Object[0]), (String)options[0], (String)options[1], (Icon)Messages.getQuestionIcon());
        });
        if (result[0] == 0) {
            for (Pair each : incompatibleNotMavenized) {
                this.myFileToModuleMapping.remove(((MavenProject)each.first).getFile());
                this.myModuleModel.disposeModule((Module)each.second);
            }
            changed |= true;
        } else {
            this.myProjectsTree.setIgnoredState(MavenUtil.collectFirsts(incompatibleNotMavenized), true, true);
            changed |= false;
        }
        return changed;
    }

    private Pair<List<Pair<MavenProject, Module>>, List<Pair<MavenProject, Module>>> collectIncompatibleModulesWithProjects() {
        ArrayList<Pair> incompatibleMavenized = new ArrayList<Pair>();
        ArrayList incompatibleNotMavenized = new ArrayList();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module == null || !this.shouldCreateModuleFor(each) || ModuleType.get((Module)module).equals((Object)each.getModuleType())) continue;
            (manager.isMavenizedModule(module) ? incompatibleMavenized : incompatibleNotMavenized).add(Pair.create((Object)each, (Object)module));
        }
        return Pair.create(incompatibleMavenized, incompatibleNotMavenized);
    }

    private static String formatProjectsWithModules(List<Pair<MavenProject, Module>> projectsWithModules) {
        return StringUtil.join(projectsWithModules, each -> {
            MavenProject project = (MavenProject)each.first;
            Module module = (Module)each.second;
            return ModuleType.get((Module)module).getName() + " '" + module.getName() + "' for Maven project " + project.getMavenId().getDisplayString();
        }, (String)"<br>");
    }

    private boolean deleteObsoleteModules() {
        List<Module> obsoleteModules = this.collectObsoleteModules();
        if (obsoleteModules.isEmpty()) {
            return false;
        }
        this.setMavenizedModules(obsoleteModules, false);
        int[] result = new int[1];
        MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), () -> {
            result[0] = Messages.showYesNoDialog((Project)this.myProject, (String)ProjectBundle.message("maven.import.message.delete.obsolete", MavenProjectImporter.formatModules(obsoleteModules)), (String)ProjectBundle.message("maven.project.import.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        });
        if (result[0] == 1) {
            return false;
        }
        for (Module each : obsoleteModules) {
            if (each.isDisposed()) continue;
            this.myModuleModel.disposeModule(each);
        }
        return true;
    }

    private List<Module> collectObsoleteModules() {
        ArrayList remainingModules = new ArrayList();
        Collections.addAll(remainingModules, this.myModuleModel.getModules());
        for (MavenProject each : this.selectProjectsToImport(this.myAllProjects)) {
            remainingModules.remove(this.myMavenProjectToModule.get(each));
        }
        ArrayList<Module> obsolete = new ArrayList<Module>();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        for (Module each : remainingModules) {
            if (!manager.isMavenizedModule(each)) continue;
            obsolete.add(each);
        }
        return obsolete;
    }

    private static String formatModules(Collection<Module> modules) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        for (Module module : modules) {
            res.append('\'').append(module.getName()).append("'\n");
            if (++i <= 20) continue;
            break;
        }
        if (i > 20) {
            res.append("\n ... and other ").append(modules.size() - 20).append(" modules");
        }
        return res.toString();
    }

    private static void doRefreshFiles(Set<File> files) {
        LocalFileSystem.getInstance().refreshIoFiles(files);
    }

    private void scheduleRefreshResolvedArtifacts(List<MavenProjectsProcessorTask> postTasks) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            artifacts.addAll(each.getDependencies());
        }
        THashSet files = new THashSet();
        for (MavenArtifact each : artifacts) {
            if (!each.isResolved()) continue;
            files.add(each.getFile());
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MavenProjectImporter.doRefreshFiles((Set<File>)files);
        } else {
            postTasks.add(new MavenProjectsProcessorTask((Set)files){
                final /* synthetic */ Set val$files;
                {
                    this.val$files = set;
                }

                @Override
                public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    indicator.setText("Refreshing files...");
                    MavenProjectImporter.doRefreshFiles(this.val$files);
                }
            });
        }
    }

    private void mapMavenProjectsToModulesAndNames() {
        for (MavenProject each : this.myAllProjects) {
            Module module = this.myFileToModuleMapping.get(each.getFile());
            if (module == null) continue;
            this.myMavenProjectToModule.put(each, module);
        }
        MavenModuleNameMapper.map(this.myAllProjects, this.myMavenProjectToModule, this.myMavenProjectToModuleName, this.myMavenProjectToModulePath, this.myImportingSettings.getDedicatedModuleDir());
    }

    private void removeOutdatedCompilerConfigSettings() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class);
        String options = javacOptions.ADDITIONAL_OPTIONS_STRING;
        javacOptions.ADDITIONAL_OPTIONS_STRING = options = options.replaceFirst("(-target (\\S+))", "");
    }

    private void importModules(List<MavenProjectsProcessorTask> tasks) {
        Map<MavenProject, MavenProjectChanges> projectsWithChanges = this.myProjectsToImportWithChanges;
        THashSet projectsWithNewlyCreatedModules = new THashSet();
        for (MavenProject each : projectsWithChanges.keySet()) {
            if (!this.ensureModuleCreated(each)) continue;
            projectsWithNewlyCreatedModules.add(each);
        }
        ArrayList<Module> modulesToMavenize = new ArrayList<Module>();
        ArrayList<MavenModuleImporter> importers = new ArrayList<MavenModuleImporter>();
        for (Map.Entry<MavenProject, MavenProjectChanges> each : projectsWithChanges.entrySet()) {
            MavenProject project = each.getKey();
            Module module = this.myMavenProjectToModule.get(project);
            boolean isNewModule = projectsWithNewlyCreatedModules.contains(project);
            MavenModuleImporter moduleImporter = this.createModuleImporter(module, project, each.getValue());
            modulesToMavenize.add(module);
            importers.add(moduleImporter);
            moduleImporter.config(isNewModule);
        }
        for (MavenProject project : this.myAllProjects) {
            Module module;
            if (projectsWithChanges.containsKey(project) || (module = this.myMavenProjectToModule.get(project)) == null) continue;
            importers.add(this.createModuleImporter(module, project, null));
        }
        for (MavenModuleImporter importer : importers) {
            importer.preConfigFacets();
        }
        for (MavenModuleImporter importer : importers) {
            importer.configFacets(tasks);
        }
        for (MavenModuleImporter importer : importers) {
            importer.postConfigFacets();
        }
        this.setMavenizedModules(modulesToMavenize, true);
    }

    private void setMavenizedModules(Collection<Module> modules, boolean mavenized) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> MavenProjectsManager.getInstance(this.myProject).setMavenizedModules(modules, mavenized));
    }

    private boolean ensureModuleCreated(MavenProject project) {
        if (this.myMavenProjectToModule.get(project) != null) {
            return false;
        }
        String path = this.myMavenProjectToModulePath.get(project);
        this.deleteExistingImlFile(path);
        Module module = this.myModuleModel.newModule(path, project.getModuleType().getId());
        this.myMavenProjectToModule.put(project, module);
        this.myCreatedModules.add(module);
        return true;
    }

    private void deleteExistingImlFile(final String path) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file != null) {
                        file.delete((Object)this);
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot delete existing iml file: " + path, (Throwable)e);
                }
            }
        });
    }

    private MavenModuleImporter createModuleImporter(Module module, MavenProject mavenProject, @Nullable MavenProjectChanges changes) {
        return new MavenModuleImporter(module, this.myProjectsTree, mavenProject, changes, this.myMavenProjectToModuleName, this.myImportingSettings, this.myModelsProvider);
    }

    private void configModuleGroups() {
        if (!this.myImportingSettings.isCreateModuleGroups()) {
            return;
        }
        final Stack groups = new Stack();
        final boolean createTopLevelGroup = this.myProjectsTree.getRootProjects().size() > 1;
        this.myProjectsTree.visit(new MavenProjectsTree.SimpleVisitor(){
            int depth = 0;

            @Override
            public boolean shouldVisit(MavenProject project) {
                return MavenProjectImporter.this.myMavenProjectToModuleName.containsKey(project);
            }

            @Override
            public void visit(MavenProject each) {
                ++this.depth;
                String name = (String)MavenProjectImporter.this.myMavenProjectToModuleName.get(each);
                if (this.shouldCreateGroup(each)) {
                    groups.push((Object)ProjectBundle.message("module.group.name", name));
                }
                if (!MavenProjectImporter.this.shouldCreateModuleFor(each)) {
                    return;
                }
                Module module = MavenProjectImporter.this.myModuleModel.findModuleByName(name);
                if (module == null) {
                    return;
                }
                MavenProjectImporter.this.myModuleModel.setModuleGroupPath(module, groups.isEmpty() ? null : ArrayUtil.toStringArray((Collection)groups));
            }

            @Override
            public void leave(MavenProject each) {
                if (this.shouldCreateGroup(each)) {
                    groups.pop();
                }
                --this.depth;
            }

            private boolean shouldCreateGroup(MavenProject project) {
                return !MavenProjectImporter.this.myProjectsTree.getModules(project).isEmpty() && (createTopLevelGroup || this.depth > 1);
            }
        });
    }

    private boolean removeUnusedProjectLibraries() {
        HashSet unusedLibraries = new HashSet();
        Collections.addAll(unusedLibraries, this.myModelsProvider.getAllLibraries());
        for (ModuleRootModel eachModel : this.collectModuleModels()) {
            for (OrderEntry eachEntry : eachModel.getOrderEntries()) {
                if (!(eachEntry instanceof LibraryOrderEntry)) continue;
                unusedLibraries.remove(((LibraryOrderEntry)eachEntry).getLibrary());
            }
        }
        boolean removed = false;
        for (Library each : unusedLibraries) {
            if (MavenProjectImporter.isDisposed(each) || !MavenRootModelAdapter.isMavenLibrary(each) || MavenRootModelAdapter.isChangedByUser(each)) continue;
            this.myModelsProvider.removeLibrary(each);
            removed = true;
        }
        return removed;
    }

    private static boolean isDisposed(Library library) {
        return library instanceof LibraryImpl && ((LibraryImpl)library).isDisposed();
    }

    private Collection<ModuleRootModel> collectModuleModels() {
        THashMap rootModels = new THashMap();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            Module module = this.myMavenProjectToModule.get(each);
            ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(module);
            rootModels.put(module, rootModel);
        }
        for (Module each : this.myModuleModel.getModules()) {
            if (rootModels.containsKey(each)) continue;
            rootModels.put(each, this.myModelsProvider.getModifiableRootModel(each));
        }
        return rootModels.values();
    }

    public List<Module> getCreatedModules() {
        return this.myCreatedModules;
    }
}

