/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Convertor;
import icons.MavenIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenProjectNamer;

public class MavenSelectProjectPopup {
    public static void attachToWorkingDirectoryField(@NotNull MavenProjectsManager projectsManager, JTextField workingDirectoryField, final JButton showModulesButton, @Nullable JComponent focusAfterSelection) {
        if (projectsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectsManager", "org/jetbrains/idea/maven/execution/MavenSelectProjectPopup", "attachToWorkingDirectoryField"));
        }
        MavenSelectProjectPopup.attachToButton(projectsManager, showModulesButton, (Consumer<MavenProject>)((Consumer)project -> {
            workingDirectoryField.setText(project.getDirectory());
            if (focusAfterSelection != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (workingDirectoryField.hasFocus()) {
                        focusAfterSelection.requestFocus();
                    }
                });
            }
        }));
        workingDirectoryField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40 && !e.isConsumed()) {
                    e.consume();
                    showModulesButton.doClick();
                }
            }
        });
    }

    public static void attachToButton(final @NotNull MavenProjectsManager projectsManager, final @NotNull JButton button, final @NotNull Consumer<MavenProject> callback) {
        if (projectsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectsManager", "org/jetbrains/idea/maven/execution/MavenSelectProjectPopup", "attachToButton"));
        }
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "org/jetbrains/idea/maven/execution/MavenSelectProjectPopup", "attachToButton"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/maven/execution/MavenSelectProjectPopup", "attachToButton"));
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<MavenProject> projectList = projectsManager.getProjects();
                if (projectList.isEmpty()) {
                    JBPopupFactory.getInstance().createMessage("Maven projects not found").showUnderneathOf((Component)button);
                    return;
                }
                DefaultMutableTreeNode root = this.buildTree(projectList);
                final Map<MavenProject, String> projectsNameMap = MavenProjectNamer.generateNameMap(projectList);
                Tree projectTree = new Tree((TreeNode)root);
                projectTree.setRootVisible(false);
                projectTree.setCellRenderer((TreeCellRenderer)new NodeRenderer(){

                    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                        if (value instanceof DefaultMutableTreeNode) {
                            MavenProject mavenProject = (MavenProject)((DefaultMutableTreeNode)value).getUserObject();
                            value = projectsNameMap.get(mavenProject);
                            this.setIcon(MavenIcons.MavenProject);
                        }
                        super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                    }
                });
                new TreeSpeedSearch(projectTree, (Convertor)new Convertor<TreePath, String>(){

                    public String convert(TreePath o) {
                        Object lastPathComponent = o.getLastPathComponent();
                        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                            return null;
                        }
                        Object userObject = ((DefaultMutableTreeNode)lastPathComponent).getUserObject();
                        return (String)projectsNameMap.get(userObject);
                    }
                });
                Ref popupRef = new Ref();
                final Runnable clickCallBack = () -> {
                    if (callback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/maven/execution/MavenSelectProjectPopup$2", "lambda$actionPerformed$0"));
                    }
                    TreePath path = projectTree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object lastPathComponent = path.getLastPathComponent();
                    if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                        return;
                    }
                    Object object = ((DefaultMutableTreeNode)lastPathComponent).getUserObject();
                    if (object == null) {
                        return;
                    }
                    callback.consume((Object)((MavenProject)object));
                    ((JBPopup)popupRef.get()).closeOk(null);
                };
                projectTree.addKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            clickCallBack.run();
                            e.consume();
                        }
                    }
                });
                JBPopup popup = new PopupChooserBuilder((JTree)projectTree).setTitle("Select maven project").setResizable(true).setItemChoosenCallback(clickCallBack).setAutoselectOnMouseMove(true).setCloseOnEnter(false).createPopup();
                popupRef.set((Object)popup);
                popup.showUnderneathOf((Component)button);
            }

            private DefaultMutableTreeNode buildTree(List<MavenProject> projectList) {
                MavenProject[] projects = projectList.toArray(new MavenProject[projectList.size()]);
                Arrays.sort(projects, new MavenProjectNamer.MavenProjectComparator());
                HashMap<MavenProject, DefaultMutableTreeNode> projectsToNode = new HashMap<MavenProject, DefaultMutableTreeNode>();
                for (MavenProject mavenProject : projects) {
                    projectsToNode.put(mavenProject, new DefaultMutableTreeNode(mavenProject));
                }
                DefaultMutableTreeNode root = new DefaultMutableTreeNode();
                for (MavenProject mavenProject : projects) {
                    MavenProject aggregator = projectsManager.findAggregator(mavenProject);
                    DefaultMutableTreeNode parent = aggregator != null ? (DefaultMutableTreeNode)projectsToNode.get(aggregator) : root;
                    parent.add((MutableTreeNode)projectsToNode.get(mavenProject));
                }
                return root;
            }
        });
    }
}

