/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final MavenOrderEnumeratorHandler INSTANCE = new MavenOrderEnumeratorHandler();

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return true;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return false;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return false;
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/execution/MavenOrderEnumeratorHandler$FactoryImpl", "isApplicable"));
            }
            MavenProjectsManager manager = MavenProjectsManager.getInstance(module.getProject());
            return manager.isMavenizedModule(module);
        }

        public OrderEnumerationHandler createHandler(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/execution/MavenOrderEnumeratorHandler$FactoryImpl", "createHandler"));
            }
            return INSTANCE;
        }
    }
}

