/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenArgumentsCompletionProvider;
import org.jetbrains.idea.maven.execution.MavenSelectProjectPopup;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEditGoalDialog
extends DialogWrapper {
    private final Project myProject;
    @Nullable
    private final Collection<String> myHistory;
    private JPanel contentPane;
    private FixedSizeButton showProjectTreeButton;
    private TextFieldWithBrowseButton workDirectoryField;
    private JPanel goalsPanel;
    private JLabel goalsLabel;
    private ComboBox goalsComboBox;
    private EditorTextField goalsEditor;

    public MavenEditGoalDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/execution/MavenEditGoalDialog", "<init>"));
        }
        this(project, null);
    }

    public MavenEditGoalDialog(@NotNull Project project, @Nullable Collection<String> history) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/execution/MavenEditGoalDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myHistory = history;
        this.$$$setupUI$$$();
        this.setTitle("Edit Maven Goal");
        this.setUpDialog();
        this.setModal(true);
        this.init();
    }

    private void setUpDialog() {
        ComboBox goalComponent;
        if (this.myHistory == null) {
            this.goalsEditor = new EditorTextField("", this.myProject, (FileType)PlainTextFileType.INSTANCE);
            goalComponent = this.goalsEditor;
            this.goalsLabel.setLabelFor((Component)this.goalsEditor);
        } else {
            goalComponent = this.goalsComboBox = new ComboBox((Object[])ArrayUtilRt.toStringArray(this.myHistory));
            this.goalsLabel.setLabelFor((Component)this.goalsComboBox);
            this.goalsComboBox.setLightWeightPopupEnabled(false);
            StringComboboxEditor editor = new StringComboboxEditor(this.myProject, (FileType)PlainTextFileType.INSTANCE, this.goalsComboBox);
            this.goalsComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)editor));
            this.goalsComboBox.setEditable(true);
            this.goalsComboBox.setEditor((ComboBoxEditor)editor);
            this.goalsComboBox.setFocusable(true);
            this.goalsEditor = editor.getEditorComponent();
        }
        this.goalsPanel.add((Component)goalComponent);
        new MavenArgumentsCompletionProvider(this.myProject).apply(this.goalsEditor);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.showProjectTreeButton.setIcon(AllIcons.Actions.Module);
        MavenSelectProjectPopup.attachToWorkingDirectoryField(projectsManager, this.workDirectoryField.getTextField(), (JButton)this.showProjectTreeButton, (JComponent)(this.goalsComboBox != null ? this.goalsComboBox : this.goalsEditor));
        this.workDirectoryField.addBrowseFolderListener(RunnerBundle.message("maven.select.maven.project.file", new Object[0]), "", this.myProject, new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                for (VirtualFile child : file.getChildren()) {
                    if (!MavenUtil.isPomFileName(child.getName())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.workDirectoryField.getText().trim().isEmpty()) {
            return new ValidationInfo("Working directory is empty", (JComponent)this.workDirectoryField);
        }
        return null;
    }

    @NotNull
    public String getGoals() {
        if (this.goalsComboBox != null) {
            String string = (String)this.goalsComboBox.getEditor().getItem();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenEditGoalDialog", "getGoals"));
            }
            return string;
        }
        String string = this.goalsEditor.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenEditGoalDialog", "getGoals"));
        }
        return string;
    }

    public void setGoals(@NotNull String goals) {
        if (goals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "goals", "org/jetbrains/idea/maven/execution/MavenEditGoalDialog", "setGoals"));
        }
        if (this.goalsComboBox != null) {
            this.goalsComboBox.setSelectedItem((Object)goals);
        }
        this.goalsEditor.setText(goals);
    }

    @NotNull
    public String getWorkDirectory() {
        String string = this.workDirectoryField.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenEditGoalDialog", "getWorkDirectory"));
        }
        return string;
    }

    public void setWorkDirectory(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/maven/execution/MavenEditGoalDialog", "setWorkDirectory"));
        }
        this.workDirectoryField.setText(path);
    }

    public void setSelectedMavenProject(@Nullable MavenProject mavenProject) {
        this.workDirectoryField.setText(mavenProject == null ? "" : mavenProject.getDirectory());
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.goalsComboBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        FixedSizeButton fixedSizeButton;
        JLabel jLabel;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "North");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Working directory");
        jLabel2.setDisplayedMnemonic('D');
        jLabel2.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.goalsLabel = jLabel = new JLabel();
        jLabel.setText("Command line");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.showProjectTreeButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setToolTipText("Select maven project");
        jPanel4.add((Component)fixedSizeButton, "East");
        this.workDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, "Center");
        this.goalsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(600, -1), null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

