/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariableImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class GradleConfigurationsNonCodeMembersContributor
extends NonCodeMembersContributor {
    private static final String METHOD_GET_BY_NAME = "getByName";

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processDynamicElements"));
        }
        if (aClass == null) {
            return;
        }
        if (!"org.gradle.api.artifacts.ConfigurationContainer".equals(aClass.getQualifiedName())) {
            return;
        }
        this.processConfigurationAddition(aClass, processor, state, place);
    }

    private void processConfigurationAddition(@NotNull PsiClass dependencyHandlerClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (dependencyHandlerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyHandlerClass", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processConfigurationAddition"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processConfigurationAddition"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processConfigurationAddition"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleConfigurationsNonCodeMembersContributor", "processConfigurationAddition"));
        }
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (call == null) {
            if (place instanceof GrReferenceExpressionImpl) {
                GrReferenceExpressionImpl expression = (GrReferenceExpressionImpl)place;
                String expr = expression.getCanonicalText();
                GrImplicitVariableImpl myPsi = new GrImplicitVariableImpl(place.getManager(), expr, "org.gradle.api.artifacts.Configuration", place);
                processor.execute((PsiElement)myPsi, state);
                this.setNavigation((LightElement)myPsi, dependencyHandlerClass, METHOD_GET_BY_NAME, 1);
            }
            return;
        }
        GrArgumentList args = call.getArgumentList();
        int argsCount = GradleResolverUtil.getGrMethodArumentsCount(args);
        if (++argsCount == 1) {
            GrLightMethodBuilder builder = new GrLightMethodBuilder(place.getManager(), METHOD_GET_BY_NAME);
            PsiClassType type = PsiType.getJavaLangObject((PsiManager)place.getManager(), (GlobalSearchScope)place.getResolveScope());
            builder.addParameter((GrParameter)new GrLightParameter("s", (PsiType)type, (PsiElement)builder));
            processor.execute((PsiElement)builder, state);
            this.setNavigation((LightElement)builder, dependencyHandlerClass, METHOD_GET_BY_NAME, ++argsCount);
        }
    }

    private void setNavigation(LightElement element, PsiClass dependencyHandlerClass, String methodName, int parametersCount) {
        for (PsiMethod method : dependencyHandlerClass.findMethodsByName(methodName, false)) {
            int methodParameterCount = method.getParameterList().getParametersCount();
            if (methodParameterCount != parametersCount || !method.getParameterList().getParameters()[methodParameterCount - 1].getType().equalsToText("groovy.lang.Closure")) continue;
            element.setNavigationElement((PsiElement)method);
        }
    }
}

