/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.AbstractInlineLocalDialog;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\nH\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValDialog;", "Lcom/intellij/refactoring/inline/AbstractInlineLocalDialog;", "element", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ref", "Lcom/intellij/psi/PsiReference;", "occurrenceCount", "", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lcom/intellij/psi/PsiReference;I)V", "kind", "", "property", "getProperty", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "refactoringName", "doAction", "", "getBorderTitle", "getInlineAllText", "getInlineThisText", "getNameLabelText", "isInlineThis", "", "idea"})
public final class KotlinInlineValDialog
extends AbstractInlineLocalDialog {
    private final String kind;
    private final String refactoringName;
    private final int occurrenceCount;

    private final KtProperty getProperty() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        }
        return (KtProperty)psiElement;
    }

    @NotNull
    protected String getBorderTitle() {
        return this.refactoringName;
    }

    @NotNull
    protected String getNameLabelText() {
        return StringsKt.capitalize((String)this.kind) + " " + this.getProperty().getName();
    }

    @Nullable
    protected String getInlineAllText() {
        String occurrencesString = this.occurrenceCount >= 0 ? " (" + this.occurrenceCount + " occurrence" + (this.occurrenceCount == 1 ? ")" : "s)") : "";
        return "Inline all references and remove the " + this.kind + occurrencesString;
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS;
    }

    @NotNull
    protected String getInlineThisText() {
        return "Inline this occurrence and leave the " + this.kind;
    }

    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_LOCAL_THIS = this.isInlineThisOnly();
        }
        this.close(AbstractInlineLocalDialog.OK_EXIT_CODE);
    }

    public KotlinInlineValDialog(@NotNull KtProperty element2, @Nullable PsiReference ref, int occurrenceCount) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        super(element2.getProject(), (PsiElement)element2, ref, occurrenceCount);
        this.occurrenceCount = occurrenceCount;
        this.kind = this.getProperty().isLocal() ? "local variable" : "property";
        this.refactoringName = "Inline " + StringUtil.capitalizeWords((String)this.kind, (boolean)true);
        this.myInvokedOnReference = ref != null;
        this.setTitle(this.refactoringName);
        this.init();
    }
}

