/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFixKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\"\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001dH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/WrongPrimitiveLiteralFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "constValue", "", "expectedTypeIsDouble", "", "expectedTypeIsFloat", "fixedExpression", "", "typeName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "Lorg/jetbrains/annotations/NotNull;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Lcom/intellij/psi/PsiFile;", "idea"})
public final class WrongPrimitiveLiteralFix
extends KotlinQuickFixAction<KtExpression> {
    private final FqNameUnsafe typeName;
    private final boolean expectedTypeIsFloat;
    private final boolean expectedTypeIsDouble;
    private final Number constValue;
    private final String fixedExpression;

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!super.isAvailable(project, editor, file2)) {
            return false;
        }
        if (this.constValue == null) {
            return false;
        }
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble) {
            return true;
        }
        if (this.constValue instanceof Float || this.constValue instanceof Double) {
            double value2 = this.constValue.doubleValue();
            if (value2 != Math.floor(value2)) {
                return false;
            }
            double d = value2;
            if (Double.compare(LongCompanionObject.MIN_VALUE, d) > 0 || Double.compare(d, LongCompanionObject.MAX_VALUE) > 0) {
                return false;
            }
        }
        LongRange longRange = (LongRange)WrongPrimitiveLiteralFixKt.access$getValueRanges$p().get(this.typeName);
        if (longRange == null) {
            return false;
        }
        return longRange.contains(this.constValue.longValue());
    }

    @NotNull
    public String getFamilyName() {
        return "Change to correct primitive type";
    }

    @NotNull
    public String getText() {
        return "Change to '" + this.fixedExpression + "'";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block4: {
            Object object;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtExpression expressionToInsert = KtPsiFactoryKt.KtPsiFactory((PsiElement)file2).createExpression(this.fixedExpression);
            Object t = this.getElement();
            PsiElement result$iv = $receiver$iv.replace((PsiElement)expressionToInsert);
            if (result$iv instanceof KtExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement = result$iv;
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression = ((KtParenthesizedExpression)psiElement).getExpression();
                if (ktExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                object = ktExpression;
            }
            KtExpression newExpression2 = (KtExpression)object;
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block4;
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)newExpression2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public WrongPrimitiveLiteralFix(@NotNull KtConstantExpression element2, @NotNull KotlinType type2) {
        String string;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)element2);
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        this.typeName = DescriptorUtils.getFqName(classifierDescriptor);
        this.expectedTypeIsFloat = KotlinBuiltIns.isFloat(type2);
        this.expectedTypeIsDouble = KotlinBuiltIns.isDouble(type2);
        ConstantValue<?> constantValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(element2, ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL));
        Object object = constantValue != null ? constantValue.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        this.constValue = (Number)object;
        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = this;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder;
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble) {
            $receiver.append(this.constValue);
            if (this.expectedTypeIsFloat) {
                $receiver.append('F');
            } else if (StringsKt.contains$default((CharSequence)((CharSequence)$receiver), (char)'.', (boolean)false, (int)2, null) ^ true) {
                $receiver.append(".0");
            }
        } else {
            if (this.constValue instanceof Float || this.constValue instanceof Double) {
                $receiver.append(this.constValue.longValue());
            } else {
                $receiver.append(StringsKt.trimEnd((String)element2.getText(), (char[])new char[]{'l', 'L'}));
            }
            if (KotlinBuiltIns.isLong(type2)) {
                $receiver.append('L');
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        wrongPrimitiveLiteralFix.fixedExpression = string = string2;
    }
}

