/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\r\u0010\u0010\u001a\u00070\r\u00a2\u0006\u0002\b\u0011H\u0016J\r\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u0011H\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001dH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionLiteralExpression", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "appropriateQuickFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "functionLiteralReturnTypeRef", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/annotations/Nullable;", "typePresentation", "", "typeSourceCode", "createAppropriateQuickFix", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Companion", "idea"})
public final class ChangeFunctionLiteralReturnTypeFix
extends KotlinQuickFixAction<KtLambdaExpression> {
    private final String typePresentation;
    private final String typeSourceCode;
    private final KtTypeReference functionLiteralReturnTypeRef;
    private final IntentionAction appropriateQuickFix;
    public static final Companion Companion = new Companion(null);

    private final IntentionAction createAppropriateQuickFix(KtLambdaExpression functionLiteralExpression, KotlinType type2) {
        ValueArgument valueArgument;
        KtParameter correspondingParameter;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        AnalysisResult analysisResult = ResolutionUtils.analyzeFullyAndGetResult(functionLiteralExpression.getContainingKtFile(), new KtFile[0]);
        BindingContext context = analysisResult.getBindingContext();
        KotlinType kotlinType = context.getType(functionLiteralExpression);
        if (kotlinType == null) {
            String string = "Type of function literal not available in binding context";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinType functionLiteralType = kotlinType;
        KotlinBuiltIns builtIns = analysisResult.getModuleDescriptor().getBuiltIns();
        ClassDescriptor functionClass = builtIns.getFunction(functionLiteralType.getArguments().size() - 1);
        LinkedList<KotlinType> functionClassTypeParameters = new LinkedList<KotlinType>();
        for (TypeProjection typeProjection : functionLiteralType.getArguments()) {
            functionClassTypeParameters.add(typeProjection.getType());
        }
        functionClassTypeParameters.remove(functionClassTypeParameters.size() - 1);
        functionClassTypeParameters.add(type2);
        KotlinType eventualFunctionLiteralType = TypeUtils.substituteParameters(functionClass, (List<KotlinType>)functionClassTypeParameters);
        KtProperty correspondingProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)functionLiteralExpression), KtProperty.class);
        if (correspondingProperty != null) {
            boolean bl;
            KtExpression ktExpression = correspondingProperty.getInitializer();
            if (ktExpression != null) {
                KtExpression ktExpression2 = ktExpression;
                KtExpression it = ktExpression2;
                bl = QuickFixUtil.canEvaluateTo(it, functionLiteralExpression);
            } else {
                bl = true;
            }
            if (bl) {
                IntentionAction intentionAction;
                KtTypeReference correspondingPropertyTypeRef = correspondingProperty.getTypeReference();
                KotlinType propertyType = (KotlinType)context.get(BindingContext.TYPE, correspondingPropertyTypeRef);
                if (propertyType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, propertyType)) {
                    KtVariableDeclaration ktVariableDeclaration = correspondingProperty;
                    KotlinType kotlinType2 = eventualFunctionLiteralType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"eventualFunctionLiteralType");
                    intentionAction = new ChangeVariableTypeFix(ktVariableDeclaration, kotlinType2);
                } else {
                    intentionAction = null;
                }
                return intentionAction;
            }
        }
        if ((resolvedCall2 = CallUtilKt.getParentResolvedCall(functionLiteralExpression, context, true)) != null && (correspondingParameter = QuickFixUtil.getParameterDeclarationForValueArgument(resolvedCall2, valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), functionLiteralExpression))) != null) {
            IntentionAction intentionAction;
            KtTypeReference correspondingParameterTypeRef = correspondingParameter.getTypeReference();
            KotlinType parameterType = (KotlinType)context.get(BindingContext.TYPE, correspondingParameterTypeRef);
            if (parameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parameterType)) {
                KotlinType kotlinType3 = eventualFunctionLiteralType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"eventualFunctionLiteralType");
                intentionAction = new ChangeParameterTypeFix(correspondingParameter, kotlinType3);
            } else {
                intentionAction = null;
            }
            return intentionAction;
        }
        KtFunction parentFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)functionLiteralExpression), KtFunction.class, (boolean)true);
        if (parentFunction != null && QuickFixUtil.canFunctionOrGetterReturnExpression(parentFunction, functionLiteralExpression)) {
            IntentionAction intentionAction;
            KtTypeReference parentFunctionReturnTypeRef = parentFunction.getTypeReference();
            KotlinType parentFunctionReturnType = (KotlinType)context.get(BindingContext.TYPE, parentFunctionReturnTypeRef);
            if (parentFunctionReturnType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parentFunctionReturnType)) {
                KotlinType kotlinType4 = eventualFunctionLiteralType;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"eventualFunctionLiteralType");
                intentionAction = new ChangeFunctionReturnTypeFix.ForEnclosing(parentFunction, kotlinType4);
            } else {
                intentionAction = null;
            }
            return intentionAction;
        }
        return null;
    }

    @NotNull
    public String getText() {
        Object object = this.appropriateQuickFix;
        if (object == null || (object = object.getText()) == null) {
            object = "Change lambda expression return type to '" + this.typePresentation + "'";
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("change.type.family", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!super.isAvailable(project, editor, file2)) return false;
        if (this.functionLiteralReturnTypeRef != null) return true;
        if (this.appropriateQuickFix == null) return false;
        Editor editor2 = editor;
        if (editor2 == null) {
            Intrinsics.throwNpe();
        }
        if (!this.appropriateQuickFix.isAvailable(project, editor2, file2)) return false;
        return true;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (this.functionLiteralReturnTypeRef != null) {
            PsiElement psiElement = this.functionLiteralReturnTypeRef.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory((PsiElement)file2).createType(this.typeSourceCode));
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            KtTypeReference newTypeRef = (KtTypeReference)psiElement;
            ShortenReferences.process$default(ShortenReferences.DEFAULT, newTypeRef, null, 2, null);
        }
        if (this.appropriateQuickFix != null) {
            Editor editor2 = editor;
            if (editor2 == null) {
                Intrinsics.throwNpe();
            }
            if (this.appropriateQuickFix.isAvailable(project, editor2, (PsiFile)file2)) {
                this.appropriateQuickFix.invoke(project, editor, (PsiFile)file2);
            }
        }
    }

    public ChangeFunctionLiteralReturnTypeFix(@NotNull KtLambdaExpression functionLiteralExpression, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)functionLiteralExpression, (String)"functionLiteralExpression");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((PsiElement)functionLiteralExpression);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(type2);
        this.typeSourceCode = IdeDescriptorRenderers.SOURCE_CODE.renderType(type2);
        this.functionLiteralReturnTypeRef = functionLiteralExpression.getFunctionLiteral().getTypeReference();
        this.appropriateQuickFix = this.createAppropriateQuickFix(functionLiteralExpression, type2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KtLambdaExpression functionLiteralExpression;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            KtLambdaExpression ktLambdaExpression = QuickFixUtil.getParentElementOfType(diagnostic, KtLambdaExpression.class);
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression ktLambdaExpression2 = functionLiteralExpression = ktLambdaExpression;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktLambdaExpression2, (String)"functionLiteralExpression");
            KotlinType kotlinType = PlatformKt.getPlatform(functionLiteralExpression).getBuiltIns().getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"functionLiteralExpressio\u2026latform.builtIns.unitType");
            return new ChangeFunctionLiteralReturnTypeFix(ktLambdaExpression2, kotlinType);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

