/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIconProvider;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u000f\u0010\u000b\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/presentation/KotlinDefaultNamedDeclarationPresentation;", "Lcom/intellij/navigation/ColoredItemPresentation;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "getIcon", "Ljavax/swing/Icon;", "unused", "", "getLocationString", "", "getPresentableText", "Lorg/jetbrains/annotations/Nullable;", "getTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "idea"})
public class KotlinDefaultNamedDeclarationPresentation
implements ColoredItemPresentation {
    private final KtNamedDeclaration declaration;

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        if (KtPsiUtil.isDeprecated(this.declaration)) {
            return CodeInsightColors.DEPRECATED_ATTRIBUTES;
        }
        return null;
    }

    @Nullable
    public String getPresentableText() {
        return this.declaration.getName();
    }

    @Nullable
    public String getLocationString() {
        KtTypeReference receiverTypeRef;
        String string;
        FqName fqName2 = this.declaration.getFqName();
        if (fqName2 == null) {
            return null;
        }
        FqName name2 = fqName2;
        String qualifiedContainer = name2.parent().toString();
        PsiElement parent2 = this.declaration.getParent();
        if (parent2 instanceof KtFile && this.declaration.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            string = ((KtFile)parent2).getName() + " in " + qualifiedContainer;
        } else {
            String string2 = qualifiedContainer;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"qualifiedContainer");
        }
        String containerText = string;
        KtNamedDeclaration ktNamedDeclaration = this.declaration;
        if (!(ktNamedDeclaration instanceof KtCallableDeclaration)) {
            ktNamedDeclaration = null;
        }
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)ktNamedDeclaration;
        KtTypeReference ktTypeReference = receiverTypeRef = ktCallableDeclaration != null ? ktCallableDeclaration.getReceiverTypeReference() : null;
        if (receiverTypeRef != null) {
            return "(for " + receiverTypeRef.getText() + " in " + containerText + ")";
        }
        if (parent2 instanceof KtFile) {
            return "(" + containerText + ")";
        }
        return "(in " + containerText + ")";
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return KotlinIconProvider.Companion.getINSTANCE().getIcon(this.declaration, 3);
    }

    public KotlinDefaultNamedDeclarationPresentation(@NotNull KtNamedDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        this.declaration = declaration;
    }
}

