/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u009c\u0001\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u0010*\u00020\u001f\u001a\n\u0010 \u001a\u00020\u0006*\u00020!\u001a\f\u0010\"\u001a\u00020\u0017*\u0004\u0018\u00010\u0006\u001a\u0014\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005*\u00020\u0006H\u0002\u001a\n\u0010$\u001a\u00020\u0017*\u00020\u0006\u001a \u0010%\u001a\u00020\u0017*\u00020\u00062\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00170'H\u0002\u001a\f\u0010)\u001a\u00020\u0017*\u00020(H\u0000\u001a\u0012\u0010*\u001a\u00020\u0017*\u00020\u000b2\u0006\u0010+\u001a\u00020\u0010\u001a\f\u0010,\u001a\u00020\u0017*\u0004\u0018\u00010-\u001a\n\u0010.\u001a\u00020\u0017*\u00020\f\u001a\f\u0010/\u001a\u00020\u0017*\u0004\u0018\u00010-\u001a\f\u00100\u001a\u00020\u0017*\u0004\u0018\u00010-\u001a\n\u00101\u001a\u00020\u0006*\u00020\u0006\u001a$\u00102\u001a\u00020\u0006*\u00020!2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00062\b\b\u0002\u00106\u001a\u00020\u0017\u001a\u0012\u00107\u001a\u00020\u0017*\n\u0012\u0006\b\u0001\u0012\u00020908\u001a\u0010\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u0005*\u00020\u0006\u001a\u0012\u0010<\u001a\u00020=*\u00020>2\u0006\u0010?\u001a\u00020(\u001a\u001c\u0010@\u001a\u00020=*\u00020>2\u0006\u0010A\u001a\u00020\u00102\b\b\u0002\u0010B\u001a\u00020\u0017\u001a\u001c\u0010@\u001a\u00020=*\u00020>2\u0006\u0010?\u001a\u00020(2\b\b\u0002\u0010B\u001a\u00020\u0017\u001a\u000e\u0010C\u001a\u0004\u0018\u00010\u0006*\u00020\u0006H\u0002\u001a\u001c\u0010D\u001a\f\u0012\u0006\b\u0001\u0012\u000209\u0018\u000108*\u00020\f2\u0006\u0010E\u001a\u00020F\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006G"}, d2={"NEGATABLE_OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "branches", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "getBranches", "(Lorg/jetbrains/kotlin/psi/KtIfExpression;)Ljava/util/List;", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getCallExpression", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Lorg/jetbrains/kotlin/psi/KtCallExpression;", "calleeName", "", "getCalleeName", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;)Ljava/lang/String;", "getNegatedOperatorText", "token", "Lcom/intellij/psi/tree/IElementType;", "isAutoCreatedItUsage", "", "expression", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "splitPropertyDeclaration", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "description", "Lorg/jetbrains/kotlin/psi/KtContainerNode;", "getLeftMostReceiverExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "hasResultingIfWithoutElse", "ifBranchesOrThis", "isExitStatement", "isExpressionOfTypeOrSubtype", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFlexibleRecursive", "isMethodCall", "fqMethodName", "isOne", "Lorg/jetbrains/kotlin/psi/KtElement;", "isReceiverExpressionWithValue", "isSizeOrLength", "isZero", "negate", "replaceFirstReceiver", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "newReceiver", "safeAccess", "resolvedToArrayType", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resultingWhens", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "setReceiverType", "", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "type", "setType", "typeString", "shortenReferences", "specialNegation", "toResolvedCall", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "idea"})
public final class UtilsKt {
    private static final Set<KtSingleValueToken> NEGATABLE_OPERATORS = SetsKt.setOf((Object[])new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ});

    public static final void setType(@NotNull KtCallableDeclaration $receiver, @NotNull KotlinType type2, boolean shortenReferences) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        if (type2.isError()) {
            return;
        }
        UtilsKt.setType($receiver, IdeDescriptorRenderers.SOURCE_CODE.renderType(type2), shortenReferences);
    }

    public static /* bridge */ /* synthetic */ void setType$default(KtCallableDeclaration ktCallableDeclaration, KotlinType kotlinType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setType");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        UtilsKt.setType(ktCallableDeclaration, kotlinType, bl);
    }

    public static final void setType(@NotNull KtCallableDeclaration $receiver, @NotNull String typeString, boolean shortenReferences) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)typeString, (String)"typeString");
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KtTypeReference typeReference = new KtPsiFactory(project).createType(typeString);
        $receiver.setTypeReference(typeReference);
        if (shortenReferences) {
            KtTypeReference ktTypeReference = $receiver.getTypeReference();
            if (ktTypeReference == null) {
                Intrinsics.throwNpe();
            }
            KtElement ktElement = ktTypeReference;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"getTypeReference()!!");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, ktElement, null, 2, null);
        }
    }

    public static /* bridge */ /* synthetic */ void setType$default(KtCallableDeclaration ktCallableDeclaration, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setType");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        UtilsKt.setType(ktCallableDeclaration, string, bl);
    }

    public static final void setReceiverType(@NotNull KtCallableDeclaration $receiver, @NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        if (type2.isError()) {
            return;
        }
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KtTypeReference typeReference = new KtPsiFactory(project).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(type2));
        TypeRefHelpersKt.setReceiverTypeReference($receiver, typeReference);
        KtTypeReference ktTypeReference = $receiver.getReceiverTypeReference();
        if (ktTypeReference == null) {
            Intrinsics.throwNpe();
        }
        KtElement ktElement = ktTypeReference;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"receiverTypeReference!!");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, ktElement, null, 2, null);
    }

    @Nullable
    public static final String description(@NotNull KtContainerNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        IElementType iElementType = $receiver.getNode().getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.THEN))) {
            return "if";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.ELSE))) {
            return "else";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtNodeTypes.BODY))) {
            PsiElement psiElement = $receiver.getParent();
            if (psiElement instanceof KtWhileExpression) {
                return "while";
            }
            if (psiElement instanceof KtDoWhileExpression) {
                return "do...while";
            }
            if (psiElement instanceof KtForExpression) {
                return "for";
            }
        }
        return null;
    }

    public static final boolean isMethodCall(@NotNull KtCallExpression $receiver, @NotNull String fqMethodName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)fqMethodName, (String)"fqMethodName");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
        if (resolvedCall2 == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(resolvedCall3.getResultingDescriptor()).asString(), (Object)fqMethodName);
    }

    public static final boolean isAutoCreatedItUsage(@NotNull KtNameReferenceExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getReferencedName(), (Object)"it") ^ true) {
            return false;
        }
        BindingContext context = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL);
        Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.getMainReference(expression2).resolveToDescriptors(context));
        if (!(object instanceof ValueParameterDescriptor)) {
            object = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)object;
        if (valueParameterDescriptor == null) {
            return false;
        }
        ValueParameterDescriptor target = valueParameterDescriptor;
        Object v = context.get(BindingContext.AUTO_CREATED_IT, target);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)v;
    }

    @NotNull
    public static final KtBinaryExpression splitPropertyDeclaration(@NotNull KtProperty property2) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        PsiElement psiElement = property2.getParent();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement parent2 = psiElement;
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression initializer2 = ktExpression;
        KotlinType explicitTypeToSet = property2.getTypeReference() != null ? (KotlinType)null : ResolutionUtils.analyze$default(initializer2, null, 1, null).getType(initializer2);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(property2);
        Object[] objectArray = new Object[2];
        Name name2 = property2.getNameAsName();
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"property.nameAsName!!");
        objectArray[0] = name2;
        KtExpression ktExpression2 = initializer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
        objectArray[1] = ktExpression2;
        KtExpression assignment = CreateByPatternKt.createExpressionByPattern(psiFactory, "$0 = $1", objectArray);
        PsiElement psiElement2 = parent2.addAfter((PsiElement)assignment, (PsiElement)property2);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        assignment = (KtBinaryExpression)psiElement2;
        parent2.addAfter(psiFactory.createNewLine(), (PsiElement)property2);
        property2.setInitializer(null);
        if (explicitTypeToSet != null) {
            UtilsKt.setType$default((KtCallableDeclaration)property2, explicitTypeToSet, false, 2, null);
        }
        return (KtBinaryExpression)assignment;
    }

    @Nullable
    public static final KtCallExpression getCallExpression(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver.getSelectorExpression();
        if (!(ktExpression instanceof KtCallExpression)) {
            ktExpression = null;
        }
        return (KtCallExpression)ktExpression;
    }

    @Nullable
    public static final String getCalleeName(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($receiver);
        KtExpression ktExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        return ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> toResolvedCall(@NotNull KtQualifiedExpression $receiver, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression($receiver);
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, ResolutionUtils.analyze(callExpression2, bodyResolveMode));
        if (resolvedCall2 == null) {
            return null;
        }
        return resolvedCall2;
    }

    public static final boolean isExitStatement(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver;
        return ktExpression instanceof KtContinueExpression || ktExpression instanceof KtBreakExpression || ktExpression instanceof KtThrowExpression || ktExpression instanceof KtReturnExpression;
    }

    public static final boolean isReceiverExpressionWithValue(@NotNull KtQualifiedExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression receiver = $receiver.getReceiverExpression();
        if (receiver instanceof KtSuperExpression) {
            return false;
        }
        return ResolutionUtils.analyze$default($receiver, null, 1, null).getType(receiver) != null;
    }

    @NotNull
    public static final KtExpression negate(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression specialNegation = UtilsKt.specialNegation($receiver);
        if (specialNegation != null) {
            return specialNegation;
        }
        return CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)$receiver), "!$0", $receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtWhenExpression> resultingWhens(@NotNull KtExpression $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtWhenExpression) {
            List list2;
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = ((KtWhenExpression)$receiver).getEntries();
            Collection collection = CollectionsKt.listOf((Object)$receiver);
            void var3_6 = $receiver$iv;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                list2 = destination$iv$iv;
                Object object2 = it.getExpression();
                if (object2 == null || (object2 = UtilsKt.resultingWhens((KtExpression)object2)) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object object3 = object2;
                list2.add(object3);
            }
            list2 = (List)destination$iv$iv;
            object = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.flatten((Iterable)list2));
        } else if (ktExpression instanceof KtIfExpression) {
            Iterable iterable;
            Object object4 = ((KtIfExpression)$receiver).getThen();
            if (object4 == null || (object4 = UtilsKt.resultingWhens((KtExpression)object4)) == null) {
                object4 = CollectionsKt.emptyList();
            }
            Collection collection = (Collection)object4;
            Object object5 = ((KtIfExpression)$receiver).getElse();
            if (object5 != null && (object5 = UtilsKt.resultingWhens((KtExpression)object5)) != null) {
                iterable = (Iterable)object5;
            } else {
                Collection collection3 = collection;
                List list3 = CollectionsKt.emptyList();
                collection = collection3;
                iterable = list3;
            }
            object = CollectionsKt.plus((Collection)collection, (Iterable)iterable);
        } else if (ktExpression instanceof KtBinaryExpression) {
            Iterable iterable;
            Object object6 = ((KtBinaryExpression)$receiver).getLeft();
            if (object6 == null || (object6 = UtilsKt.resultingWhens((KtExpression)object6)) == null) {
                object6 = CollectionsKt.emptyList();
            }
            Collection collection = (Collection)object6;
            Object object7 = ((KtBinaryExpression)$receiver).getRight();
            if (object7 != null && (object7 = UtilsKt.resultingWhens((KtExpression)object7)) != null) {
                iterable = (Iterable)object7;
            } else {
                Collection collection4 = collection;
                List list4 = CollectionsKt.emptyList();
                collection = collection4;
                iterable = list4;
            }
            object = CollectionsKt.plus((Collection)collection, (Iterable)iterable);
        } else if (ktExpression instanceof KtUnaryExpression) {
            object = ((KtUnaryExpression)$receiver).getBaseExpression();
            if (object == null || (object = UtilsKt.resultingWhens((KtExpression)object)) == null) {
                object = CollectionsKt.emptyList();
            }
        } else if (ktExpression instanceof KtBlockExpression) {
            object = (KtExpression)CollectionsKt.lastOrNull(((KtBlockExpression)$receiver).getStatements());
            if (object == null || (object = UtilsKt.resultingWhens((KtExpression)object)) == null) {
                object = CollectionsKt.emptyList();
            }
        } else {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final boolean hasResultingIfWithoutElse(@Nullable KtExpression $receiver) {
        boolean bl;
        block5: {
            KtExpression ktExpression = $receiver;
            if (ktExpression instanceof KtIfExpression) {
                bl = ((KtIfExpression)$receiver).getElse() == null || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$receiver).getThen()) || UtilsKt.hasResultingIfWithoutElse(((KtIfExpression)$receiver).getElse());
            } else if (ktExpression instanceof KtWhenExpression) {
                Iterable $receiver$iv = ((KtWhenExpression)$receiver).getEntries();
                for (Object element$iv : $receiver$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv;
                    if (!UtilsKt.hasResultingIfWithoutElse(it.getExpression())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            } else {
                bl = ktExpression instanceof KtBinaryExpression ? UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$receiver).getLeft()) || UtilsKt.hasResultingIfWithoutElse(((KtBinaryExpression)$receiver).getRight()) : (ktExpression instanceof KtUnaryExpression ? UtilsKt.hasResultingIfWithoutElse(((KtUnaryExpression)$receiver).getBaseExpression()) : (ktExpression instanceof KtBlockExpression ? UtilsKt.hasResultingIfWithoutElse((KtExpression)CollectionsKt.lastOrNull(((KtBlockExpression)$receiver).getStatements())) : false));
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private static final KtExpression specialNegation(@NotNull KtExpression $receiver) {
        block12: {
            block15: {
                block13: {
                    block14: {
                        block11: {
                            factory = KtPsiFactoryKt.KtPsiFactory((PsiElement)$receiver);
                            var2_2 = $receiver;
                            if (!(var2_2 instanceof KtPrefixExpression)) break block11;
                            if (Intrinsics.areEqual((Object)((KtPrefixExpression)$receiver).getOperationReference().getReferencedName(), (Object)"!") && (baseExpression = ((KtPrefixExpression)$receiver).getBaseExpression()) != null && (type = (bindingContext = ResolutionUtils.analyze(baseExpression, BodyResolveMode.PARTIAL)).getType(baseExpression)) != null && KotlinBuiltIns.isBoolean(type)) {
                                return KtPsiUtil.safeDeparenthesize(baseExpression);
                            }
                            break block12;
                        }
                        if (var2_2 instanceof KtBinaryExpression) {
                            operator = ((KtBinaryExpression)$receiver).getOperationToken();
                            if (CollectionsKt.contains((Iterable)UtilsKt.NEGATABLE_OPERATORS, (Object)operator) ^ true) {
                                return null;
                            }
                            v0 = ((KtBinaryExpression)$receiver).getLeft();
                            if (v0 == null) {
                                return null;
                            }
                            left = v0;
                            v1 = ((KtBinaryExpression)$receiver).getRight();
                            if (v1 == null) {
                                return null;
                            }
                            right = v1;
                            v2 = new Object[3];
                            v3 = left;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"left");
                            v2[0] = v3;
                            v4 = operator;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"operator");
                            v2[1] = UtilsKt.getNegatedOperatorText(v4);
                            v5 = right;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"right");
                            v2[2] = v5;
                            return CreateByPatternKt.createExpressionByPattern(factory, "$0 $1 $2", v2);
                        }
                        if (var2_2 instanceof KtIsExpression) {
                            v6 = new Object[3];
                            v7 = ((KtIsExpression)$receiver).getLeftHandSide();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"leftHandSide");
                            v6[0] = v7;
                            v6[1] = ((KtIsExpression)$receiver).isNegated() != false ? "is" : "!is";
                            v8 = ((KtIsExpression)$receiver).getTypeReference();
                            if (v8 == null) {
                                return null;
                            }
                            v6[2] = v8;
                            return CreateByPatternKt.createExpressionByPattern(factory, "$0 $1 $2", v6);
                        }
                        if (!(var2_2 instanceof KtConstantExpression)) break block12;
                        v9 = var3_5 = ((KtConstantExpression)$receiver).getText();
                        if (v9 == null) break block13;
                        switch (v9.hashCode()) {
                            case 3569038: {
                                if (!var3_5.equals("true")) ** break;
                                break;
                            }
                            case 97196323: {
                                if (!var3_5.equals("false")) ** break;
                                break block14;
                            }
                        }
                        v10 = factory.createExpression("false");
                        break block15;
                    }
                    v10 = factory.createExpression("true");
                    break block15;
                }
                v10 = null;
            }
            return v10;
        }
        return null;
    }

    private static final String getNegatedOperatorText(IElementType token) {
        String string;
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
            String string2 = KtTokens.EXCLEQ.getValue();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KtTokens.EXCLEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) {
            String string3 = KtTokens.EQEQ.getValue();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"KtTokens.EQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQEQ))) {
            String string4 = KtTokens.EXCLEQEQEQ.getValue();
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"KtTokens.EXCLEQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQEQEQ))) {
            String string5 = KtTokens.EQEQEQ.getValue();
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"KtTokens.EQEQEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IS_KEYWORD))) {
            String string6 = KtTokens.NOT_IS.getValue();
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"KtTokens.NOT_IS.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS))) {
            String string7 = KtTokens.IS_KEYWORD.getValue();
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"KtTokens.IS_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.IN_KEYWORD))) {
            String string8 = KtTokens.NOT_IN.getValue();
            string = string8;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"KtTokens.NOT_IN.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN))) {
            String string9 = KtTokens.IN_KEYWORD.getValue();
            string = string9;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"KtTokens.IN_KEYWORD.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LT))) {
            String string10 = KtTokens.GTEQ.getValue();
            string = string10;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"KtTokens.GTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LTEQ))) {
            String string11 = KtTokens.GT.getValue();
            string = string11;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"KtTokens.GT.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GT))) {
            String string12 = KtTokens.LTEQ.getValue();
            string = string12;
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"KtTokens.LTEQ.value");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.GTEQ))) {
            String string13 = KtTokens.LT.getValue();
            string = string13;
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"KtTokens.LT.value");
        } else {
            throw (Throwable)new IllegalArgumentException("The token " + token + " does not have a negated equivalent.");
        }
        return string;
    }

    public static final boolean isFlexibleRecursive(@NotNull KotlinType $receiver) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (FlexibleTypesKt.isFlexible($receiver)) {
                return true;
            }
            Iterable $receiver$iv = $receiver.getArguments();
            for (Object element$iv : $receiver$iv) {
                TypeProjection it = (TypeProjection)element$iv;
                if (!(!it.isStarProjection() && UtilsKt.isFlexibleRecursive(it.getType()))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final List<KtExpression> getBranches(@NotNull KtIfExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return UtilsKt.ifBranchesOrThis($receiver);
    }

    private static final List<KtExpression> ifBranchesOrThis(@NotNull KtExpression $receiver) {
        if (!($receiver instanceof KtIfExpression)) {
            return CollectionsKt.listOf((Object)$receiver);
        }
        KtExpression ktExpression = ((KtIfExpression)$receiver).getElse();
        List list2 = ktExpression != null ? UtilsKt.ifBranchesOrThis(ktExpression) : null;
        Collection collection = CollectionsKt.listOf((Object)((KtIfExpression)$receiver).getThen());
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        List list4 = list3;
        return CollectionsKt.plus((Collection)collection, (Iterable)list4);
    }

    public static final boolean resolvedToArrayType(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        KotlinType kotlinType = $receiver.getResultingDescriptor().getReturnType();
        KotlinType type2 = kotlinType;
        return type2 != null && (KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2));
    }

    public static final boolean isZero(@Nullable KtElement $receiver) {
        KtElement ktElement = $receiver;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"0");
    }

    public static final boolean isOne(@Nullable KtElement $receiver) {
        KtElement ktElement = $receiver;
        return Intrinsics.areEqual((Object)(ktElement != null ? ktElement.getText() : null), (Object)"1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isExpressionOfTypeOrSubtype(@NotNull KtExpression $receiver, Function1<? super KotlinType, Boolean> predicate) {
        Object element$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, ResolutionUtils.analyze$default($receiver, null, 1, null));
        Object object = resolvedCall2;
        if (resolvedCall2 == null) return false;
        CallableDescriptor callableDescriptor = object.getResultingDescriptor();
        object = callableDescriptor;
        if (callableDescriptor == null) return false;
        KotlinType kotlinType = object.getReturnType();
        KotlinType returnType2 = kotlinType;
        if (returnType2 == null) return false;
        Iterable $receiver$iv = CollectionsKt.plus(returnType2.getConstructor().getSupertypes(), (Object)returnType2);
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!((Boolean)predicate.invoke(element$iv = iterator2.next())).booleanValue());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final boolean isSizeOrLength(@Nullable KtElement $receiver) {
        block5: {
            boolean bl;
            block6: {
                String string;
                if (!($receiver instanceof KtDotQualifiedExpression)) {
                    return false;
                }
                KtExpression ktExpression = ((KtDotQualifiedExpression)$receiver).getSelectorExpression();
                if (ktExpression == null) return false;
                String string2 = ktExpression.getText();
                String string3 = string = string2;
                if (string3 == null) break block5;
                switch (string3.hashCode()) {
                    case 3530753: {
                        if (!string.equals("size")) return false;
                        break;
                    }
                    case -1106363674: {
                        if (!string.equals("length")) return false;
                        break block6;
                    }
                }
                bl = UtilsKt.isExpressionOfTypeOrSubtype(((KtDotQualifiedExpression)$receiver).getReceiverExpression(), (Function1<? super KotlinType, Boolean>)((Function1)isSizeOrLength.1.INSTANCE));
                return bl;
            }
            bl = UtilsKt.isExpressionOfTypeOrSubtype(((KtDotQualifiedExpression)$receiver).getReceiverExpression(), (Function1<? super KotlinType, Boolean>)((Function1)isSizeOrLength.2.INSTANCE));
            return bl;
        }
        return false;
    }

    @NotNull
    public static final KtExpression getLeftMostReceiverExpression(@NotNull KtDotQualifiedExpression $receiver) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression ktExpression2 = $receiver.getReceiverExpression();
        if (!(ktExpression2 instanceof KtDotQualifiedExpression)) {
            ktExpression2 = null;
        }
        if ((ktExpression = (KtDotQualifiedExpression)ktExpression2) == null || (ktExpression = UtilsKt.getLeftMostReceiverExpression(ktExpression)) == null) {
            ktExpression = $receiver.getReceiverExpression();
        }
        return ktExpression;
    }

    @NotNull
    public static final KtExpression replaceFirstReceiver(@NotNull KtDotQualifiedExpression $receiver, @NotNull KtPsiFactory factory2, @NotNull KtExpression newReceiver, boolean safeAccess) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)newReceiver, (String)"newReceiver");
        KtExpression receiver = $receiver.getReceiverExpression();
        if (safeAccess) {
            $receiver.getOperationTokenNode().getPsi().replace(factory2.createSafeCallNode().getPsi());
        }
        if ((ktExpression = receiver) instanceof KtDotQualifiedExpression) {
            UtilsKt.replaceFirstReceiver((KtDotQualifiedExpression)receiver, factory2, newReceiver, safeAccess);
        } else {
            receiver.replace((PsiElement)newReceiver);
        }
        return $receiver;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KtExpression replaceFirstReceiver$default(KtDotQualifiedExpression ktDotQualifiedExpression, KtPsiFactory ktPsiFactory, KtExpression ktExpression, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replaceFirstReceiver");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return UtilsKt.replaceFirstReceiver(ktDotQualifiedExpression, ktPsiFactory, ktExpression, bl);
    }
}

