/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0010*\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveBracesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "handleComments", "construct", "Lorg/jetbrains/kotlin/psi/KtExpression;", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "isApplicableTo", "caretOffset", "", "findChildBlock", "idea"})
public final class RemoveBracesIntention
extends SelfTargetingIntention<KtElement> {
    private final KtBlockExpression findChildBlock(@NotNull KtElement $receiver) {
        KtBlockExpression ktBlockExpression;
        KtElement ktElement = $receiver;
        if (ktElement instanceof KtBlockExpression) {
            ktBlockExpression = (KtBlockExpression)$receiver;
        } else if (ktElement instanceof KtLoopExpression) {
            KtExpression ktExpression = ((KtLoopExpression)$receiver).getBody();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else if (ktElement instanceof KtWhenEntry) {
            KtExpression ktExpression = ((KtWhenEntry)$receiver).getExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else {
            ktBlockExpression = null;
        }
        return ktBlockExpression;
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element2, int caretOffset) {
        PsiElement container2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element2);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block = ktBlockExpression;
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(block.getStatements());
        if (ktExpression == null) {
            return false;
        }
        KtExpression singleStatement = ktExpression;
        PsiElement psiElement = container2 = block.getParent();
        if (psiElement instanceof KtContainerNode) {
            if (singleStatement instanceof KtIfExpression && ((KtContainerNode)container2).getParent() instanceof KtIfExpression) {
                return false;
            }
            String string = UtilsKt.description((KtContainerNode)container2);
            if (string == null) {
                return false;
            }
            String description = string;
            this.setText("Remove braces from '" + description + "' statement");
            return true;
        }
        if (psiElement instanceof KtWhenEntry) {
            this.setText("Remove braces from 'when' entry");
            return !(singleStatement instanceof KtNamedDeclaration);
        }
        return false;
    }

    @Override
    public void applyTo(@NotNull KtElement element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element2);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression block = ktBlockExpression;
        KtExpression statement = (KtExpression)CollectionsKt.single(block.getStatements());
        PsiElement psiElement = block.getParent();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement container2 = psiElement;
        PsiElement psiElement2 = container2.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression construct = (KtExpression)psiElement2;
        this.handleComments(construct, block);
        PsiElement psiElement3 = statement.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"statement.copy()");
        PsiElement newElement = block.replace(psiElement3);
        if (construct instanceof KtDoWhileExpression) {
            PsiElement psiElement4 = newElement.getParent();
            if (psiElement4 == null) {
                Intrinsics.throwNpe();
            }
            psiElement4.addAfter(KtPsiFactoryKt.KtPsiFactory((PsiElement)block).createNewLine(), newElement);
        }
    }

    private final void handleComments(KtExpression construct, KtBlockExpression block) {
        PsiElement sibling;
        PsiElement psiElement = block.getFirstChild();
        Object object = sibling = psiElement != null ? psiElement.getNextSibling() : null;
        while (sibling != null) {
            if (sibling instanceof PsiComment) {
                KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)construct);
                if (construct.getPrevSibling() instanceof PsiWhiteSpace) {
                    PsiElement psiElement2 = construct.getPrevSibling();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement2.replace(psiFactory.createNewLine());
                }
                PsiElement psiElement3 = construct.getParent();
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement commentElement = psiElement3.addBefore(sibling, construct.getPrevSibling());
                PsiElement psiElement4 = construct.getParent();
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                psiElement4.addBefore(psiFactory.createNewLine(), commentElement);
            }
            sibling = sibling.getNextSibling();
        }
    }

    @Override
    protected boolean allowCaretInsideElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return !(element2 instanceof KtBlockExpression) || ((KtBlockExpression)element2).getParent() instanceof KtWhenEntry;
    }

    public RemoveBracesIntention() {
        super(KtElement.class, "Remove braces", null, 4, null);
    }
}

