/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ChooseStringExpression;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddForLoopIndicesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "WITH_INDEX_FQ_NAMES", "", "", "WITH_INDEX_NAME", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "createWithIndexExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "originalExpression", "runTemplate", "forExpression", "indexVariable", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "idea"})
public final class AddForLoopIndicesIntention
extends SelfTargetingRangeIntention<KtForExpression>
implements LowPriorityAction {
    private final String WITH_INDEX_NAME = "withIndex";
    private final Set<String> WITH_INDEX_FQ_NAMES;

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtForExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getLoopParameter() == null) {
            return null;
        }
        KtExpression ktExpression = element2.getLoopRange();
        if (ktExpression == null) {
            return null;
        }
        KtExpression loopRange = ktExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(loopRange, bindingContext2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (CollectionsKt.contains((Iterable)this.WITH_INDEX_FQ_NAMES, resolvedCall3 != null && (resolvedCall3 = resolvedCall3.getResultingDescriptor()) != null && (resolvedCall3 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((Object)resolvedCall3))) != null ? ((FqNameUnsafe)((Object)resolvedCall3)).asString() : null)) {
            return null;
        }
        LexicalScope resolutionScope = ScopeUtils.getResolutionScope((PsiElement)element2, bindingContext2, ResolutionUtils.getResolutionFacade(element2));
        KtExpression ktExpression2 = loopRange;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"loopRange");
        KtExpression potentialExpression = this.createWithIndexExpression(ktExpression2);
        KtExpression ktExpression3 = loopRange;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"loopRange");
        BindingContext newBindingContext = AnalyzerUtilKt.analyzeInContext$default(potentialExpression, resolutionScope, ktExpression3, null, null, null, false, null, 124, null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(potentialExpression, newBindingContext);
        if (resolvedCall4 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> newResolvedCall = resolvedCall4;
        if (this.WITH_INDEX_FQ_NAMES.contains(DescriptorUtilsKt.getFqNameUnsafe(newResolvedCall.getResultingDescriptor()).asString()) ^ true) {
            return null;
        }
        KtExpression ktExpression4 = element2.getBody();
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)element2), ktExpression4 != null ? PsiUtilsKt.getStartOffset((PsiElement)ktExpression4) : PsiUtilsKt.getEndOffset((PsiElement)element2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtForExpression element2, @Nullable Editor editor) {
        PsiElement psiElement;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (editor == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        KtExpression ktExpression = element2.getLoopRange();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression loopRange = ktExpression;
        KtParameter ktParameter = element2.getLoopParameter();
        if (ktParameter == null) {
            Intrinsics.throwNpe();
        }
        KtParameter loopParameter = ktParameter;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
        KtExpression ktExpression2 = loopRange;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"loopRange");
        loopRange.replace((PsiElement)this.createWithIndexExpression(ktExpression2));
        Object[] objectArray = new Object[1];
        String string = loopParameter.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loopParameter.text");
        objectArray[0] = string;
        KtExpression ktExpression3 = CreateByPatternKt.createExpressionByPattern(psiFactory, "for((index, $0) in x){}", objectArray);
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        }
        KtDestructuringDeclaration ktDestructuringDeclaration = ((KtForExpression)ktExpression3).getDestructuringParameter();
        if (ktDestructuringDeclaration == null) {
            Intrinsics.throwNpe();
        }
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration;
        PsiElement psiElement2 = loopParameter;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)multiParameter);
        if (result$iv instanceof KtDestructuringDeclaration) {
            psiElement = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression4 = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
            }
            psiElement = (KtDestructuringDeclaration)ktExpression4;
        }
        multiParameter = (KtDestructuringDeclaration)psiElement;
        KtDestructuringDeclarationEntry indexVariable = multiParameter.getEntries().get(0);
        editor.getCaretModel().moveToOffset(PsiUtilsKt.getStartOffset(indexVariable));
        KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = indexVariable;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"indexVariable");
        this.runTemplate(editor, element2, ktDestructuringDeclarationEntry);
    }

    private final void runTemplate(Editor editor, KtForExpression forExpression, KtDestructuringDeclarationEntry indexVariable) {
        KtExpression body2;
        PsiDocumentManager.getInstance((Project)forExpression.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)forExpression);
        templateBuilder.replaceElement((PsiElement)indexVariable, (Expression)new ChooseStringExpression((Collection)CollectionsKt.listOf((Object[])new String[]{"index", "i"}), null, null, 6, null));
        KtExpression ktExpression = body2 = forExpression.getBody();
        if (ktExpression instanceof KtBlockExpression) {
            KtExpression statement = (KtExpression)CollectionsKt.firstOrNull(((KtBlockExpression)body2).getStatements());
            if (statement != null) {
                templateBuilder.setEndVariableBefore((PsiElement)statement);
            } else {
                templateBuilder.setEndVariableAfter(((KtBlockExpression)body2).getLBrace());
            }
        } else if (Intrinsics.areEqual((Object)ktExpression, null)) {
            PsiElement psiElement = forExpression.getRightParenthesis();
            PsiElement it = psiElement;
            templateBuilder.setEndVariableAfter(it);
        } else {
            templateBuilder.setEndVariableBefore((PsiElement)body2);
        }
        templateBuilder.run(editor, true);
    }

    private final KtExpression createWithIndexExpression(KtExpression originalExpression2) {
        return CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory((PsiElement)originalExpression2), "$" + "0." + this.WITH_INDEX_NAME + "()", originalExpression2);
    }

    /*
     * WARNING - void declaration
     */
    public AddForLoopIndicesIntention() {
        super(KtForExpression.class, "Add indices to 'for' loop", null, 4, null);
        void var3_4;
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = CollectionsKt.listOf((Object[])new String[]{"collections", "sequences", "text", "ranges"});
        AddForLoopIndicesIntention addForLoopIndicesIntention = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            String string2 = "kotlin." + (String)it + "." + this.WITH_INDEX_NAME;
            collection.add(string2);
        }
        collection = (List)var3_4;
        addForLoopIndicesIntention.WITH_INDEX_FQ_NAMES = CollectionsKt.toSet((Iterable)collection);
    }
}

