/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.Deprecation;
import org.jetbrains.kotlin.resolve.DeprecationUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/OverridingDeprecatedMemberInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "idea"})
public final class OverridingDeprecatedMemberInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                this.registerProblemIfNeeded(declaration, psiElement);
            }

            public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
                KtDeclaration ktDeclaration = accessor;
                PsiElement psiElement = accessor.getNamePlaceholder();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"accessor.namePlaceholder");
                this.registerProblemIfNeeded(ktDeclaration, psiElement);
            }

            private final void registerProblemIfNeeded(KtDeclaration declaration, PsiElement targetForProblem) {
                if (declaration instanceof KtDestructuringDeclarationEntry) {
                    return;
                }
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(declaration);
                if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                    declarationDescriptor = null;
                }
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                if (callableMemberDescriptor == null) {
                    return;
                }
                CallableMemberDescriptor accessorDescriptor = callableMemberDescriptor;
                Object object = DeprecationUtilKt.getDeprecation(accessorDescriptor);
                if (object == null || (object = DeprecationUtilKt.deprecatedByOverriddenMessage((Deprecation)object)) == null) {
                    return;
                }
                Object message2 = object;
                ProblemDescriptor problem = this.$holder.getManager().createProblemDescriptor(targetForProblem, (String)message2, true, ProblemHighlightType.LIKE_DEPRECATED, this.$isOnTheFly, new LocalQuickFix[0]);
                this.$holder.registerProblem(problem);
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$isOnTheFly = $captured_local_variable$1;
            }
        };
    }
}

