/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/KotlinTypeHierarchyProvider;", "Lcom/intellij/ide/hierarchy/type/JavaTypeHierarchyProvider;", "()V", "getTarget", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargetByContainingElement", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getTargetByReference", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
public final class KotlinTypeHierarchyProvider
extends JavaTypeHierarchyProvider {
    private final PsiElement getTargetByReference(Project project, Editor editor) {
        PsiElement psiElement;
        PsiElement target = TargetElementUtil.findTargetElement((Editor)editor, (int)TargetElementUtil.getInstance().getAllAccepted());
        PsiElement psiElement2 = target;
        if (psiElement2 instanceof PsiClass) {
            psiElement = target;
        } else if (psiElement2 instanceof KtClassOrObject) {
            psiElement = (PsiElement)SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass((KtClassOrObject)target);
        } else if (psiElement2 instanceof KtNamedFunction) {
            KotlinType type2;
            String functionName2 = ((KtNamedFunction)target).getName();
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)ResolutionUtils.analyze$default((KtElement)target, null, 1, null).get(BindingContext.FUNCTION, target);
            if (simpleFunctionDescriptor == null) {
                return null;
            }
            SimpleFunctionDescriptor functionDescriptor = simpleFunctionDescriptor;
            KotlinType kotlinType = functionDescriptor.getReturnType();
            if (kotlinType == null) {
                return null;
            }
            KotlinType kotlinType2 = type2 = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
            String returnTypeText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(kotlinType2);
            if (Intrinsics.areEqual((Object)returnTypeText, (Object)functionName2) ^ true) {
                return null;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.singleOrNull((Iterable)KotlinClassShortNameIndex.getInstance().get(functionName2, project, SearchUtilKt.allScope(project)));
            if (ktClassOrObject == null) {
                return null;
            }
            KtClassOrObject classOrObject = ktClassOrObject;
            psiElement = (PsiElement)SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass(classOrObject);
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement getTargetByContainingElement(Editor editor, PsiFile file2) {
        void $receiver$iv;
        PsiElement element2;
        int offset2 = editor.getCaretModel().getOffset();
        PsiElement psiElement = file2.findElementAt(offset2);
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = element2 = psiElement;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        return (PsiElement)SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass(classOrObject);
    }

    @Nullable
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return null;
            }
            PsiFile file2 = psiFile;
            PsiElement psiElement = (PsiElement)file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"file");
            if (!ProjectRootsUtil.isInProjectOrLibSource(psiElement)) {
                return null;
            }
            Project project3 = project2;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            PsiElement psiElement2 = this.getTargetByReference(project3, editor);
            if (psiElement2 == null) {
                PsiFile psiFile2 = file2;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
                psiElement2 = this.getTargetByContainingElement(editor, psiFile2);
            }
            return psiElement2;
        }
        PsiElement element2 = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element2 instanceof KtClassOrObject) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)element2;
            if (ktClassOrObject == null) {
                Intrinsics.throwNpe();
            }
            return (PsiElement)SourceNavigationHelper.getOriginalPsiClassOrCreateLightClass(ktClassOrObject);
        }
        return null;
    }
}

