/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.filters;

import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.SmapData;
import org.jetbrains.kotlin.idea.debugger.SmapUtilKt;
import org.jetbrains.kotlin.idea.debugger.SourceLineKind;
import org.jetbrains.kotlin.idea.filters.InlineFunctionHyperLinkInfo;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter;", "Lcom/intellij/execution/filters/Filter;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/psi/search/GlobalSearchScope;)V", "exceptionFilter", "Lcom/intellij/execution/filters/ExceptionFilter;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "createHyperlinks", "Lorg/jetbrains/kotlin/idea/filters/InlineFunctionHyperLinkInfo;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "patchResult", "result", "Companion", "idea"})
public final class KotlinExceptionFilter
implements Filter {
    private final ExceptionFilter exceptionFilter;
    private final GlobalSearchScope searchScope;
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN;
    public static final Companion Companion;

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Filter.Result result2 = this.exceptionFilter.applyFilter(line, entireLength);
        return result2 == null ? (Filter.Result)null : this.patchResult(result2, line);
    }

    /*
     * WARNING - void declaration
     */
    private final Filter.Result patchResult(Filter.Result result2, String line) {
        List list2;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Filter.Result result3;
        HyperlinkInfo hyperlinkInfo = this.createHyperlinkInfo(line);
        if (hyperlinkInfo == null) {
            return result2;
        }
        HyperlinkInfo newHyperlinkInfo = hyperlinkInfo;
        Iterable iterable = result2.getResultItems();
        Filter.Result result4 = result3;
        Filter.Result result5 = result3;
        void var5_7 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Filter.ResultItem resultItem = (Filter.ResultItem)item$iv$iv;
            list2 = destination$iv$iv;
            Filter.ResultItem resultItem2 = new Filter.ResultItem(it.getHighlightStartOffset(), it.getHighlightEndOffset(), newHyperlinkInfo, it.getHighlightAttributes());
            list2.add(resultItem2);
        }
        list2 = (List)destination$iv$iv;
        result4(list2);
        return result5;
    }

    private final HyperlinkInfo createHyperlinkInfo(String line) {
        Project project = this.searchScope.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        StackTraceElement stackTraceElement = KotlinExceptionFilter.Companion.parseStackTraceLine(line);
        if (stackTraceElement == null) {
            return null;
        }
        StackTraceElement element2 = stackTraceElement;
        String fileName = element2.getFileName();
        String fullyQualifiedName = element2.getClassName();
        int lineNumber = element2.getLineNumber() - 1;
        String internalName = StringsKt.replace$default((String)fullyQualifiedName, (char)'.', (char)'/', (boolean)false, (int)4, null);
        JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        JvmClassName jvmClassName2 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        String string = fileName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
        KtFile ktFile = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project3, this.searchScope, jvmClassName2, string);
        if (ktFile == null) {
            return null;
        }
        KtFile file2 = ktFile;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        JvmClassName jvmClassName3 = jvmClassName;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"jvmClassName");
        Project project4 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        InlineFunctionHyperLinkInfo hyperlinkInfoForInline = this.createHyperlinks(jvmClassName3, virtualFile3, lineNumber + 1, project4);
        if (hyperlinkInfoForInline != null) {
            return (HyperlinkInfo)hyperlinkInfoForInline;
        }
        return (HyperlinkInfo)new OpenFileHyperlinkInfo(project2, virtualFile3, lineNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final InlineFunctionHyperLinkInfo createHyperlinks(JvmClassName jvmName, VirtualFile file2, int line, Project project) {
        void inlineFunctionBodyLine;
        void inlineFunctionBodyFile;
        byte[] byArray = SmapUtilKt.readClassFile$default(project, jvmName, file2, (Function1)new Function1<VirtualFile, Boolean>(line, project){
            final /* synthetic */ int $line;
            final /* synthetic */ Project $project;

            public final boolean invoke(@NotNull VirtualFile sourceFile) {
                Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
                return SmapUtilKt.isInlineFunctionLineNumber(sourceFile, this.$line, this.$project);
            }
            {
                this.$line = n;
                this.$project = project;
                super(1);
            }
        }, null, 16, null);
        if (byArray == null) {
            return null;
        }
        byte[] bytes2 = byArray;
        SmapData smapData = SmapUtilKt.readDebugInfo(bytes2);
        if (smapData == null) {
            return null;
        }
        SmapData smapData2 = smapData;
        ArrayList inlineInfos = CollectionsKt.arrayListOf((Object[])new InlineFunctionHyperLinkInfo.InlineInfo[0]);
        Pair<KtFile, Integer> pair2 = SmapUtilKt.mapStacktraceLineToSource(smapData2, line, project, SourceLineKind.EXECUTED_LINE, this.searchScope);
        if (pair2 == null) {
            return null;
        }
        Pair<KtFile, Integer> pair3 = pair2;
        KtFile ktFile = (KtFile)pair3.component1();
        int n = ((Number)pair3.component2()).intValue();
        pair3 = null;
        VirtualFile virtualFile2 = inlineFunctionBodyFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"inlineFunctionBodyFile.virtualFile");
        inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.InlineFunctionBodyInfo(virtualFile2, (int)inlineFunctionBodyLine));
        Pair<KtFile, Integer> inlineFunCallInfo = SmapUtilKt.mapStacktraceLineToSource(smapData2, line, project, SourceLineKind.CALL_LINE, this.searchScope);
        if (inlineFunCallInfo != null) {
            void callSiteLine;
            void callSiteFile;
            Pair<KtFile, Integer> pair4 = inlineFunCallInfo;
            KtFile ktFile2 = (KtFile)pair4.component1();
            int n2 = ((Number)pair4.component2()).intValue();
            pair4 = null;
            VirtualFile virtualFile3 = callSiteFile.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"callSiteFile.virtualFile");
            inlineInfos.add(new InlineFunctionHyperLinkInfo.InlineInfo.CallSiteInfo(virtualFile3, (int)callSiteLine));
        }
        return new InlineFunctionHyperLinkInfo(project, inlineInfos);
    }

    public KotlinExceptionFilter(@NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        this.searchScope = searchScope2;
        this.exceptionFilter = new ExceptionFilter(this.searchScope);
    }

    static {
        Companion = new Companion(null);
        STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^[\\w|\\s]*at\\s+(.+)\\.(.+)\\((.+):(\\d+)\\)\\s*$");
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/filters/KotlinExceptionFilter$Companion;", "", "()V", "STACK_TRACE_ELEMENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getSTACK_TRACE_ELEMENT_PATTERN", "()Ljava/util/regex/Pattern;", "parseStackTraceLine", "Ljava/lang/StackTraceElement;", "line", "", "idea"})
    public static final class Companion {
        private final Pattern getSTACK_TRACE_ELEMENT_PATTERN() {
            return STACK_TRACE_ELEMENT_PATTERN;
        }

        private final StackTraceElement parseStackTraceLine(String line) {
            Matcher matcher2 = this.getSTACK_TRACE_ELEMENT_PATTERN().matcher(line);
            if (matcher2.matches()) {
                String declaringClass = matcher2.group(1);
                String methodName = matcher2.group(2);
                String fileName = matcher2.group(3);
                String lineNumber = matcher2.group(4);
                return new StackTraceElement(declaringClass, methodName, fileName, Integer.parseInt(lineNumber));
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

