/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.common.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.idea.decompiler.js.JsMetaFileUtils;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.KotlinStubVersions;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptClassDataFinder;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderComponents;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "getStubVersion", "", "idea-analysis"})
public final class KotlinJavaScriptStubBuilder
extends ClsStubBuilder {
    public int getStubVersion() {
        return 18 + KotlinStubVersions.JS_STUB_VERSION;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        VirtualFile file2;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
                file2 = content2.getFile();
                if (Intrinsics.areEqual((Object)file2.getFileSystem().getProtocol(), (Object)"jar") ^ true) break block2;
                VirtualFile virtualFile2 = file2;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                if (!JsMetaFileUtils.INSTANCE.isKotlinJavaScriptInternalCompiledFile(virtualFile2)) break block3;
            }
            return null;
        }
        VirtualFile virtualFile3 = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
        return this.doBuildFileStub(virtualFile3);
    }

    @Nullable
    public final PsiFileStub<KtFile> doBuildFileStub(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        FqName packageFqName = JsMetaFileUtils.INSTANCE.getPackageFqName(file2);
        byte[] content2 = file2.contentsToByteArray(false);
        boolean isPackageHeader = JsMetaFileUtils.INSTANCE.isPackageHeader(file2);
        VirtualFile moduleDirectory = JsMetaFileUtils.INSTANCE.getModuleDirectory(file2);
        String stringsFileName = KotlinJavascriptSerializedResourcePaths.INSTANCE.getStringTableFilePath(packageFqName);
        VirtualFile virtualFile2 = moduleDirectory.findFileByRelativePath(stringsFileName);
        if (virtualFile2 == null) {
            String string = "strings file not found: " + stringsFileName;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        VirtualFile stringsFile = virtualFile2;
        NameResolverImpl nameResolver = NameResolverImpl.Companion.read(new ByteArrayInputStream(stringsFile.contentsToByteArray(false)));
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file2, nameResolver);
        if (isPackageHeader) {
            ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(content2, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            ProtoBuf.Package package_ = packageProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageProto");
            return ClsStubBuildingKt.createPackageFacadeStub(package_, packageFqName, context);
        }
        ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(content2, JsSerializerProtocol.INSTANCE.getExtensionRegistry());
        NameResolver nameResolver3 = nameResolver;
        ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classProto.typeTable");
        ClsStubBuilderContext context = components.createContext(nameResolver3, packageFqName, new TypeTable(typeTable));
        ClassId classId = JsMetaFileUtils.INSTANCE.getClassId(file2);
        ProtoBuf.Class clazz = classProto;
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"classProto");
        return ClsStubBuildingKt.createTopLevelClassStub(classId, clazz, null, context);
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file2, NameResolver nameResolver) {
        KotlinJavascriptClassDataFinder classDataFinder2 = new KotlinJavascriptClassDataFinder(nameResolver, (Function1<? super String, ? extends InputStream>)((Function1)new Function1<String, InputStream>(file2){
            final /* synthetic */ VirtualFile $file;

            @Nullable
            public final InputStream invoke(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                VirtualFile virtualFile2 = this.$file.getParent().findChild(StringsKt.substringAfterLast$default((String)path, (String)"/", null, (int)2, null));
                return virtualFile2 != null ? virtualFile2.getInputStream() : null;
            }
            {
                this.$file = virtualFile2;
                super(1);
            }
        }));
        AnnotationLoaderForStubBuilderImpl annotationLoader = new AnnotationLoaderForStubBuilderImpl(JsSerializerProtocol.INSTANCE);
        return new ClsStubBuilderComponents(classDataFinder2, annotationLoader, file2);
    }
}

