/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.IncorrectOperationException;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.TemplateKind;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"ATTRIBUTE_FUNCTION_NAME", "", "FUNCTION_BODY_TEMPLATE", "SECONDARY_CONSTRUCTOR_BODY_TEMPLATE", "getFunctionBodyTextFromTemplate", "project", "Lcom/intellij/openapi/project/Project;", "kind", "Lorg/jetbrains/kotlin/idea/core/TemplateKind;", "name", "returnType", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "idea-core"})
public final class TemplatesKt {
    private static final String FUNCTION_BODY_TEMPLATE = "New Kotlin Function Body.kt";
    private static final String SECONDARY_CONSTRUCTOR_BODY_TEMPLATE = "New Kotlin Secondary Constructor Body.kt";
    private static final String ATTRIBUTE_FUNCTION_NAME = "FUNCTION_NAME";

    @NotNull
    public static final String getFunctionBodyTextFromTemplate(@NotNull Project project, @NotNull TemplateKind kind2, @Nullable String name2, @NotNull String returnType2, @Nullable FqName classFqName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)returnType2, (String)"returnType");
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
        if (fileTemplateManager == null) {
            Intrinsics.throwNpe();
        }
        FileTemplate fileTemplate = fileTemplateManager.getCodeTemplate(kind2.getTemplateFileName());
        Properties properties2 = new Properties();
        properties2.setProperty("RETURN_TYPE", returnType2);
        if (classFqName != null) {
            properties2.setProperty("CLASS_NAME", classFqName.asString());
            properties2.setProperty("SIMPLE_CLASS_NAME", classFqName.shortName().asString());
        }
        if (name2 != null) {
            properties2.setProperty(ATTRIBUTE_FUNCTION_NAME, name2);
        }
        try {
            FileTemplate fileTemplate2 = fileTemplate;
            if (fileTemplate2 == null) {
                Intrinsics.throwNpe();
            }
            String string2 = fileTemplate2.getText(properties2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fileTemplate!!.getText(properties)");
            string = string2;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            throw (Throwable)new IncorrectOperationException("Failed to parse file template", e);
        }
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String getFunctionBodyTextFromTemplate$default(Project project, TemplateKind templateKind, String string, String string2, FqName fqName2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFunctionBodyTextFromTemplate");
        }
        if ((n & 0x10) != 0) {
            fqName2 = null;
        }
        return TemplatesKt.getFunctionBodyTextFromTemplate(project, templateKind, string, string2, fqName2);
    }

    static {
        FUNCTION_BODY_TEMPLATE = FUNCTION_BODY_TEMPLATE;
        SECONDARY_CONSTRUCTOR_BODY_TEMPLATE = SECONDARY_CONSTRUCTOR_BODY_TEMPLATE;
        ATTRIBUTE_FUNCTION_NAME = ATTRIBUTE_FUNCTION_NAME;
    }

    @NotNull
    public static final /* synthetic */ String access$getFUNCTION_BODY_TEMPLATE$p() {
        return FUNCTION_BODY_TEMPLATE;
    }

    @NotNull
    public static final /* synthetic */ String access$getSECONDARY_CONSTRUCTOR_BODY_TEMPLATE$p() {
        return SECONDARY_CONSTRUCTOR_BODY_TEMPLATE;
    }
}

