/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.notification.Notification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0004\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0005\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0005\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\r\u001a\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\r\u001a\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"EAP_REPOSITORY", "Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "SNAPSHOT_REPOSITORY", "getAbleToRunConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "project", "Lcom/intellij/openapi/project/Project;", "getApplicableConfigurators", "module", "Lcom/intellij/openapi/module/Module;", "getConfiguratorByName", "name", "", "getModulesWithKotlinFiles", "getNonConfiguredModules", "excludeModules", "", "configurator", "getNonConfiguredModulesWithKotlinFiles", "hasKotlinFilesInSources", "", "hasKotlinFilesOnlyInTests", "hasKotlinJsRuntimeInScope", "hasKotlinJvmOrJsRuntimeInScope", "hasKotlinJvmRuntimeInScope", "isEap", "version", "isModuleConfigured", "isProjectConfigured", "isSnapshot", "showConfigureKotlinNotificationIfNeeded", "", "idea"})
public final class ConfigureKotlinInProjectUtilsKt {
    @JvmField
    @NotNull
    public static final RepositoryDescription SNAPSHOT_REPOSITORY = new RepositoryDescription("sonatype.oss.snapshots", "Sonatype OSS Snapshot Repository", "http://oss.sonatype.org/content/repositories/snapshots", true);
    @JvmField
    @NotNull
    public static final RepositoryDescription EAP_REPOSITORY = new RepositoryDescription("bintray.kotlin.eap", "Bintray Kotlin EAP Repository", "http://dl.bintray.com/kotlin/kotlin-eap", false);

    public static final boolean isProjectConfigured(@NotNull Project project) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
            Iterable $receiver$iv = modules;
            for (Object element$iv : $receiver$iv) {
                Module it = (Module)element$iv;
                if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public static final boolean isModuleConfigured(@NotNull Module module) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Collection<KotlinProjectConfigurator> configurators = ConfigureKotlinInProjectUtilsKt.getApplicableConfigurators(module);
            Iterable $receiver$iv = configurators;
            for (Object element$iv : $receiver$iv) {
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!it.isConfigured(module)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getModulesWithKotlinFiles(@NotNull Project project) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        if (!FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            return CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = ProjectStructureUtilKt.allModules(project);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(module)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        ConfigureKotlinNotificationManager.notify$default(ConfigureKotlinNotificationManager.INSTANCE, project, null, 2, null);
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Project project, @NotNull List<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, excludeModules){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $excludeModules;

            public final void run() {
                String notificationString2 = (String)DumbService.getInstance((Project)this.$project).runReadActionInSmartMode((Computable)new Computable<String>(this){
                    final /* synthetic */ showConfigureKotlinNotificationIfNeeded.1 this$0;

                    @Nullable
                    public final String compute() {
                        boolean bl;
                        block1: {
                            List modules = CollectionsKt.minus((Iterable)ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(this.this$0.$project), (Iterable)this.this$0.$excludeModules);
                            Iterable $receiver$iv = modules;
                            for (T element$iv : $receiver$iv) {
                                Module it = (Module)element$iv;
                                if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(it)) continue;
                                bl = false;
                                break block1;
                            }
                            bl = true;
                        }
                        return bl ? (String)null : ConfigureKotlinNotification.Companion.getNotificationString(this.this$0.$project, this.this$0.$excludeModules);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (notificationString2 != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, notificationString2){
                        final /* synthetic */ showConfigureKotlinNotificationIfNeeded.1 this$0;
                        final /* synthetic */ String $notificationString;

                        public final void run() {
                            ConfigureKotlinNotificationManager.INSTANCE.notify(this.this$0.$project, (Notification)new ConfigureKotlinNotification(this.this$0.$project, this.this$0.$excludeModules, this.$notificationString));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$notificationString = string;
                        }
                    });
                }
            }
            {
                this.$project = project;
                this.$excludeModules = list2;
            }
        });
    }

    public static /* bridge */ /* synthetic */ void showConfigureKotlinNotificationIfNeeded$default(Project project, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showConfigureKotlinNotificationIfNeeded");
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(project, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Project project) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object[] $receiver$iv = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
        Object[] modules = $receiver$iv.isEmpty() ? (Object[])ProjectStructureUtilKt.allModules(project) : $receiver$iv;
        $receiver$iv = Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME);
        Object[] $i$a$1$ifEmpty = $receiver$iv;
        Collection $i$f$ifEmpty = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            boolean bl;
            void element$iv$iv;
            block2: {
                void $receiver$iv2;
                element$iv$iv = $receiver$iv$iv[i];
                KotlinProjectConfigurator configurator = (KotlinProjectConfigurator)element$iv$iv;
                Iterable iterable = (Iterable)modules;
                for (Object element$iv : $receiver$iv2) {
                    Module module = (Module)element$iv;
                    if (!(configurator.isApplicable(module) && !configurator.isConfigured(module))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getApplicableConfigurators(@NotNull Module module) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Object[] $receiver$iv = Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME);
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv$iv;
            if (!it.isApplicable(module)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public static final KotlinProjectConfigurator getConfiguratorByName(@NotNull String name2) {
        Object object;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Object[] $receiver$iv = Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME);
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (KotlinProjectConfigurator)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getNonConfiguredModules(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Iterable $receiver$iv = ProjectStructureUtilKt.allModules(project);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!(configurator.isApplicable(module) && !configurator.isConfigured(module))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getNonConfiguredModulesWithKotlinFiles(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
        Iterable $receiver$iv = modules;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!(configurator.isApplicable(module) && !configurator.isConfigured(module))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getNonConfiguredModules(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        List modulesWithKotlinFiles = CollectionsKt.minus((Iterable)ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project), (Iterable)excludeModules);
        Collection<KotlinProjectConfigurator> ableToRunConfigurators = ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(project);
        Iterable iterable = modulesWithKotlinFiles;
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block2: {
                void $receiver$iv2;
                Module module = (Module)element$iv$iv;
                Iterable iterable2 = ableToRunConfigurators;
                for (Object element$iv : $receiver$iv2) {
                    KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                    if (!(!it.isConfigured(module))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Collection getNonConfiguredModules$default(Project project, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNonConfiguredModules");
        }
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ConfigureKotlinInProjectUtilsKt.getNonConfiguredModules(project, collection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasKotlinJvmOrJsRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        if (KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null) return true;
        Project project2 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
        GlobalSearchScope globalSearchScope2 = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"scope");
        if (KotlinRuntimeLibraryUtilKt.getKotlinJsRuntimeMarkerClass(project2, globalSearchScope2) == null) return false;
        return true;
    }

    public static final boolean hasKotlinJvmRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        return KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null;
    }

    public static final boolean hasKotlinJsRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        return KotlinRuntimeLibraryUtilKt.getKotlinJsRuntimeMarkerClass(project, globalSearchScope) != null;
    }

    public static final boolean hasKotlinFilesOnlyInTests(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return !ConfigureKotlinInProjectUtilsKt.hasKotlinFilesInSources(module) && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(true));
    }

    public static final boolean hasKotlinFilesInSources(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(false));
    }

    public static final boolean isSnapshot(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains$default((CharSequence)version, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
    }

    public static final boolean isEap(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains$default((CharSequence)version, (CharSequence)"rc", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)version, (CharSequence)"eap", (boolean)false, (int)2, null);
    }
}

