/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.PositionElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.completion.KeywordCompletion;
import org.jetbrains.kotlin.idea.completion.KeywordLookupObject;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00043456B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J.\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\u0017H\u0002J2\u0010$\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u00152\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020 0\u0014J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0014\u0010+\u001a\u00020 *\u00020\"2\u0006\u0010,\u001a\u00020\u0017H\u0002J\u0014\u0010-\u001a\u00020.*\u00020\u00172\u0006\u0010/\u001a\u00020\u0017H\u0002J\u0014\u00100\u001a\u00020\u0015*\u0002012\u0006\u00102\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00050\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion;", "", "()V", "ALL_KEYWORDS", "", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "COMPOUND_KEYWORDS", "", "GENERAL_FILTER", "Lcom/intellij/psi/filters/NotFilter;", "KEYWORDS_TO_IGNORE_PREFIX", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "KEYWORD_CONSTRUCTS", "", "NON_ACTUAL_KEYWORDS", "", "kotlin.jvm.PlatformType", "NO_SPACE_AFTER", "buildFilter", "Lkotlin/Function1;", "", "position", "Lcom/intellij/psi/PsiElement;", "buildFilterByText", "prefixText", "project", "Lcom/intellij/openapi/project/Project;", "buildFilterWithContext", "contextElement", "buildFilterWithReducedContext", "buildReducedContextBefore", "", "builder", "Ljava/lang/StringBuilder;", "scope", "complete", "prefix", "isJvmModule", "consumer", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isErrorElementBefore", "token", "appendReducedText", "element", "getStartOffsetInAncestor", "", "ancestor", "matchesKeyword", "Lcom/intellij/psi/tree/IElementType;", "keywordType", "CommentFilter", "ParentFilter", "SpaceAfterInsertHandler", "UseSiteAnnotationTargetInsertHandler", "idea-completion"})
public final class KeywordCompletion {
    private static final Set<KtKeywordToken> NON_ACTUAL_KEYWORDS;
    private static final List<KtKeywordToken> ALL_KEYWORDS;
    private static final TokenSet KEYWORDS_TO_IGNORE_PREFIX;
    private static final Map<KtKeywordToken, KtKeywordToken> COMPOUND_KEYWORDS;
    private static final Map<KtKeywordToken, String> KEYWORD_CONSTRUCTS;
    private static final List<String> NO_SPACE_AFTER;
    private static final NotFilter GENERAL_FILTER;
    public static final KeywordCompletion INSTANCE;

    public final void complete(@NotNull PsiElement position2, @NotNull String prefix, boolean isJvmModule, @NotNull Function1<? super LookupElement, Unit> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        if (!GENERAL_FILTER.isAcceptable((Object)position2, position2)) {
            return;
        }
        Function1<KtKeywordToken, Boolean> parserFilter = this.buildFilter(position2);
        for (KtKeywordToken keywordToken : ALL_KEYWORDS) {
            LookupElementBuilder element2;
            String keyword = keywordToken.getValue();
            KtKeywordToken nextKeyword = COMPOUND_KEYWORDS.get((Object)keywordToken);
            if (nextKeyword != null) {
                String next2;
                complete.1 isSpace$ = complete.1.INSTANCE;
                PsiElement psiElement = PsiUtilsKt.nextLeaf(position2, (Function1<? super PsiElement, Boolean>)((Function1)complete.next.1.INSTANCE));
                String string = next2 = psiElement != null ? psiElement.getText() : null;
                if (next2 != null && StringsKt.startsWith$default((String)next2, (String)"$", (boolean)false, (int)2, null)) {
                    String string2 = next2;
                    int n = 1;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    next2 = string4;
                }
                if (Intrinsics.areEqual((Object)next2, (Object)nextKeyword.getValue()) ^ true) {
                    keyword = keyword + " " + nextKeyword.getValue();
                }
            }
            if (Intrinsics.areEqual((Object)((Object)keywordToken), (Object)((Object)KtTokens.DYNAMIC_KEYWORD)) && isJvmModule || !StringsKt.startsWith$default((String)keyword, (String)prefix, (boolean)false, (int)2, null) && KEYWORDS_TO_IGNORE_PREFIX.contains((IElementType)keywordToken) ^ true || !((Boolean)parserFilter.invoke((Object)keywordToken)).booleanValue()) continue;
            String constructText = KEYWORD_CONSTRUCTS.get((Object)keywordToken);
            if (constructText != null) {
                Project project = position2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"position.project");
                String string = keyword;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keyword");
                element2 = HandlerUtilsKt.createKeywordConstructLookupElement$default(project, string, constructText, false, 8, null);
                consumer2.invoke((Object)element2);
                continue;
            }
            element2 = LookupElementBuilder.create((Object)new KeywordLookupObject(), (String)keyword).bold();
            PsiElement psiElement = PsiUtilsKt.prevLeaf$default(position2, false, 1, null);
            boolean isUseSiteAnnotationTarget = Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)((Object)KtTokens.AT));
            InsertHandler insertHandler = isUseSiteAnnotationTarget ? (InsertHandler)UseSiteAnnotationTargetInsertHandler.INSTANCE : (NO_SPACE_AFTER.contains(keyword) ? (InsertHandler)null : (InsertHandler)SpaceAfterInsertHandler.INSTANCE);
            element2 = element2.withInsertHandler(insertHandler);
            if (isUseSiteAnnotationTarget) {
                element2 = element2.withPresentableText(keyword + ":");
            }
            LookupElementBuilder lookupElementBuilder = element2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupElementBuilder, (String)"element");
            consumer2.invoke((Object)lookupElementBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<KtKeywordToken, Boolean> buildFilter(PsiElement position2) {
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = position2;
        for (PsiElement parent2 = position2.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            KtExpression ktExpression;
            void prevParent;
            PsiElement psiElement = parent2;
            if (psiElement instanceof KtBlockExpression) {
                Object v4;
                String prefixText;
                block21: {
                    void $receiver$iv;
                    Object blockParent;
                    prefixText = "fun foo() { ";
                    if ((PsiElement)prevParent.element instanceof KtExpression) {
                        PsiElement prevLeaf2 = PsiUtilsKt.prevLeaf((PsiElement)prevParent.element, (Function1<? super PsiElement, Boolean>)((Function1)buildFilter.prevLeaf.1.INSTANCE));
                        PsiElement psiElement2 = prevLeaf2;
                        if (Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)((Object)KtTokens.RBRACE))) {
                            PsiElement psiElement3 = prevLeaf2;
                            Object object = psiElement3 != null ? psiElement3.getParent() : null;
                            if (!(object instanceof KtBlockExpression)) {
                                object = null;
                            }
                            KtBlockExpression ktBlockExpression = (KtBlockExpression)object;
                            blockParent = ktBlockExpression != null ? ktBlockExpression.getParent() : null;
                            Iterator iterator2 = blockParent;
                            if (iterator2 instanceof KtTryExpression) {
                                prefixText = prefixText + "try {}\n";
                            } else if (iterator2 instanceof KtCatchClause) {
                                prefixText = prefixText + "try {} catch (e: E) {}\n";
                            }
                        }
                        return this.buildFilterWithContext(prefixText, (PsiElement)prevParent.element, position2);
                    }
                    blockParent = PsiUtilsKt.siblings((PsiElement)prevParent.element, false, false);
                    for (Object element$iv : $receiver$iv) {
                        if (!(element$iv instanceof KtExpression)) continue;
                        v4 = element$iv;
                        break block21;
                    }
                    v4 = null;
                }
                KtExpression lastExpression = v4;
                if (lastExpression != null) {
                    String contextAfterExpression2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile(PsiUtilsKt.siblings((PsiElement)lastExpression, true, false), (Function1)((Function1)new Function1<PsiElement, Boolean>((Ref.ObjectRef)prevParent){
                        final /* synthetic */ Ref.ObjectRef $prevParent;

                        public final boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it, (Object)((PsiElement)this.$prevParent.element)) ^ true;
                        }
                        {
                            this.$prevParent = objectRef;
                            super(1);
                        }
                    })), null, null, null, (int)0, null, (Function1)buildFilter.contextAfterExpression.2.INSTANCE, (int)31, null);
                    return this.buildFilterWithContext(prefixText + "x" + contextAfterExpression2, (PsiElement)prevParent.element, position2);
                }
            } else if (psiElement instanceof KtDeclarationWithInitializer) {
                KtExpression initializer2 = ((KtDeclarationWithInitializer)parent2).getInitializer();
                if (Intrinsics.areEqual((Object)((PsiElement)prevParent.element), (Object)initializer2)) {
                    KtExpression ktExpression2 = initializer2;
                    if (ktExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement psiElement4 = (PsiElement)ktExpression2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"initializer!!");
                    return this.buildFilterWithContext("val v = ", psiElement4, position2);
                }
            } else if (psiElement instanceof KtParameter && Intrinsics.areEqual((Object)((PsiElement)prevParent.element), (Object)(ktExpression = ((KtParameter)parent2).getDefaultValue()))) {
                KtExpression ktExpression3 = ktExpression;
                if (ktExpression3 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement psiElement5 = (PsiElement)ktExpression3;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"default!!");
                return this.buildFilterWithContext("val v = ", psiElement5, position2);
            }
            if (parent2 instanceof KtDeclaration) {
                PsiElement scope2 = ((KtDeclaration)parent2).getParent();
                PsiElement psiElement6 = scope2;
                if (psiElement6 instanceof KtClassOrObject) {
                    if (parent2 instanceof KtPrimaryConstructor) {
                        return this.buildFilterWithReducedContext("class X ", parent2, position2);
                    }
                    return this.buildFilterWithReducedContext("class X { ", parent2, position2);
                }
                if (psiElement6 instanceof KtFile) {
                    return this.buildFilterWithReducedContext("", parent2, position2);
                }
            }
            prevParent.element = parent2;
        }
        return this.buildFilterWithReducedContext("", null, position2);
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithContext(String prefixText, PsiElement contextElement, PsiElement position2) {
        int offset2 = this.getStartOffsetInAncestor(position2, contextElement);
        String string = contextElement.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, offset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String truncatedContext = string4;
        String string5 = prefixText + truncatedContext;
        Project project = contextElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"contextElement.project");
        return this.buildFilterByText(string5, project);
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithReducedContext(String prefixText, PsiElement contextElement, PsiElement position2) {
        StringBuilder builder = new StringBuilder();
        this.buildReducedContextBefore(builder, position2, contextElement);
        String string = prefixText + builder.toString();
        Project project = position2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"position.project");
        return this.buildFilterByText(string, project);
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterByText(String prefixText, Project project) {
        KtPsiFactory psiFactory = new KtPsiFactory(project);
        return (Function1)new Function1<KtKeywordToken, Boolean>(prefixText, psiFactory){
            final /* synthetic */ String $prefixText;
            final /* synthetic */ KtPsiFactory $psiFactory;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull KtKeywordToken keywordTokenType) {
                KotlinTarget kotlinTarget;
                KtDeclaration ownerDeclaration;
                KtDeclaration ktDeclaration;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)((Object)keywordTokenType), (String)"keywordTokenType");
                String postfix = StringsKt.endsWith$default((String)this.$prefixText, (String)"@", (boolean)false, (int)2, null) ? ":X Y.Z" : " X";
                KtFile file2 = this.$psiFactory.createFile(this.$prefixText + keywordTokenType.getValue() + postfix);
                PsiElement psiElement = file2.findElementAt(this.$prefixText.length());
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement elementAt = psiElement;
                ASTNode aSTNode = elementAt.getNode();
                if (aSTNode == null) {
                    Intrinsics.throwNpe();
                }
                if (!KeywordCompletion.access$matchesKeyword(KeywordCompletion.INSTANCE, aSTNode.getElementType(), keywordTokenType)) {
                    return false;
                }
                PsiElement psiElement2 = elementAt;
                if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, PsiErrorElement.class, (boolean)false) != null) {
                    return false;
                }
                PsiElement psiElement3 = elementAt;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"elementAt");
                if (KeywordCompletion.access$isErrorElementBefore(KeywordCompletion.INSTANCE, psiElement3)) {
                    return false;
                }
                if (!(keywordTokenType instanceof KtModifierKeywordToken)) {
                    return true;
                }
                if (!(elementAt.getParent() instanceof KtModifierList)) {
                    return true;
                }
                PsiElement container2 = elementAt.getParent().getParent();
                PsiElement psiElement4 = container2;
                List possibleTargets = psiElement4 instanceof KtParameter ? (((KtParameter)container2).getOwnerFunction() instanceof KtPrimaryConstructor ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.MEMBER_PROPERTY}) : CollectionsKt.listOf((Object)((Object)KotlinTarget.VALUE_PARAMETER))) : (psiElement4 instanceof KtTypeParameter ? CollectionsKt.listOf((Object)((Object)KotlinTarget.TYPE_PARAMETER)) : (psiElement4 instanceof KtEnumEntry ? CollectionsKt.listOf((Object)((Object)KotlinTarget.ENUM_ENTRY)) : (psiElement4 instanceof KtClassBody ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.INNER_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY}) : (psiElement4 instanceof KtFile ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY}) : (List)null))));
                Set<KotlinTarget> modifierTargets = ModifierCheckerCore.INSTANCE.getPossibleTargetMap().get((Object)((Object)keywordTokenType));
                if (modifierTargets != null && possibleTargets != null) {
                    boolean bl;
                    block19: {
                        void $receiver$iv2;
                        Iterable iterable = possibleTargets;
                        for (E element$iv : $receiver$iv2) {
                            KotlinTarget it = (KotlinTarget)((Object)element$iv);
                            if (!modifierTargets.contains((Object)((Object)it))) continue;
                            bl = false;
                            break block19;
                        }
                        bl = true;
                    }
                    if (bl) {
                        return false;
                    }
                }
                PsiElement psiElement5 = container2;
                if (psiElement5 != null) {
                    void strict$iv;
                    void $receiver$iv3;
                    PsiElement psiElement6 = psiElement5;
                    boolean element$iv = true;
                    ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtDeclaration.class, (boolean)strict$iv);
                } else {
                    ktDeclaration = null;
                }
                KtDeclaration strict$iv = ownerDeclaration = ktDeclaration;
                if (Intrinsics.areEqual(strict$iv, null)) {
                    kotlinTarget = KotlinTarget.FILE;
                } else if (strict$iv instanceof KtClass) {
                    kotlinTarget = ((KtClass)ownerDeclaration).isInterface() ? KotlinTarget.INTERFACE : (((KtClass)ownerDeclaration).isEnum() ? KotlinTarget.ENUM_CLASS : (((KtClass)ownerDeclaration).isAnnotation() ? KotlinTarget.ANNOTATION_CLASS : (((KtClass)ownerDeclaration).isInner() ? KotlinTarget.INNER_CLASS : KotlinTarget.CLASS_ONLY)));
                } else if (strict$iv instanceof KtObjectDeclaration) {
                    kotlinTarget = ((KtObjectDeclaration)ownerDeclaration).isObjectLiteral() ? KotlinTarget.OBJECT_LITERAL : KotlinTarget.OBJECT;
                } else {
                    return true;
                }
                KotlinTarget parentTarget = kotlinTarget;
                Set<KotlinTarget> modifierParents = ModifierCheckerCore.INSTANCE.getPossibleParentTargetMap().get((Object)((Object)keywordTokenType));
                if (modifierParents != null && modifierParents.contains((Object)((Object)parentTarget)) ^ true) {
                    return false;
                }
                Set<KotlinTarget> deprecatedParents = ModifierCheckerCore.INSTANCE.getDeprecatedParentTargetMap().get((Object)((Object)keywordTokenType));
                return deprecatedParents == null || !deprecatedParents.contains((Object)((Object)parentTarget));
            }
            {
                this.$prefixText = string;
                this.$psiFactory = ktPsiFactory;
                super(1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isErrorElementBefore(PsiElement token) {
        for (PsiElement leaf : PsiUtilsKt.getPrevLeafs(token)) {
            boolean bl;
            block3: {
                void $receiver$iv;
                if (leaf instanceof PsiWhiteSpace || leaf instanceof PsiComment) continue;
                Sequence<PsiElement> sequence2 = PsiUtilsKt.getParentsWithSelf(leaf);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it instanceof PsiErrorElement)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            if (leaf.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private final boolean matchesKeyword(@NotNull IElementType $receiver, KtKeywordToken keywordType) {
        IElementType iElementType = $receiver;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)keywordType)) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN)) ? Intrinsics.areEqual((Object)((Object)keywordType), (Object)((Object)KtTokens.IN_KEYWORD)) : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS)) ? Intrinsics.areEqual((Object)((Object)keywordType), (Object)((Object)KtTokens.IS_KEYWORD)) : false));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildReducedContextBefore(StringBuilder builder, PsiElement position2, PsiElement scope2) {
        Object v1;
        PsiElement parent2;
        block8: {
            void $receiver$iv;
            if (Intrinsics.areEqual((Object)position2, (Object)scope2)) {
                return;
            }
            PsiElement psiElement = position2.getParent();
            if (psiElement == null) {
                return;
            }
            parent2 = psiElement;
            this.buildReducedContextBefore(builder, parent2, scope2);
            Sequence<PsiElement> sequence2 = PsiUtilsKt.siblings(position2, false, false);
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof KtDeclaration)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        PsiElement prevDeclaration = v1;
        PsiElement child = parent2.getFirstChild();
        while (Intrinsics.areEqual((Object)child, (Object)position2) ^ true) {
            if (child instanceof KtDeclaration) {
                if (Intrinsics.areEqual((Object)child, (Object)prevDeclaration)) {
                    this.appendReducedText(builder, child);
                }
            } else {
                PsiElement psiElement = child;
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                builder.append(psiElement.getText());
            }
            child = child.getNextSibling();
        }
    }

    private final void appendReducedText(@NotNull StringBuilder $receiver, PsiElement element2) {
        PsiElement child = element2.getFirstChild();
        if (child == null) {
            String string = element2.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            $receiver.append(string);
        } else {
            while (child != null) {
                PsiElement psiElement = child;
                if (psiElement instanceof KtBlockExpression || psiElement instanceof KtClassBody) {
                    $receiver.append("{}");
                } else {
                    this.appendReducedText($receiver, child);
                }
                child = child.getNextSibling();
            }
        }
    }

    private final int getStartOffsetInAncestor(@NotNull PsiElement $receiver, PsiElement ancestor) {
        if (Intrinsics.areEqual((Object)ancestor, (Object)$receiver)) {
            return 0;
        }
        PsiElement psiElement = $receiver.getParent();
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return this.getStartOffsetInAncestor(psiElement, ancestor) + $receiver.getStartOffsetInParent();
    }

    /*
     * WARNING - void declaration
     */
    private KeywordCompletion() {
        void var3_3;
        Object object;
        Collection collection;
        Object item$iv$iv;
        IElementType it;
        Object $receiver$iv$iv;
        INSTANCE = this;
        NON_ACTUAL_KEYWORDS = SetsKt.setOf((Object)((Object)KtTokens.TYPE_ALIAS_KEYWORD));
        Object[] objectArray = KtTokens.KEYWORDS.getTypes();
        Object[] objectArray2 = KtTokens.SOFT_KEYWORDS.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"SOFT_KEYWORDS.types");
        Object $receiver$iv = ArraysKt.plus((Object[])objectArray, (Object[])objectArray2);
        Object[] objectArray3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            it = (IElementType)element$iv$iv;
            if (!(CollectionsKt.contains((Iterable)NON_ACTUAL_KEYWORDS, (Object)it) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (IElementType)item$iv$iv;
            collection = destination$iv$iv;
            IElementType iElementType = it;
            if (iElementType == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtKeywordToken");
            }
            object = (KtKeywordToken)iElementType;
            collection.add(object);
        }
        ALL_KEYWORDS = (List)destination$iv$iv;
        KEYWORDS_TO_IGNORE_PREFIX = TokenSet.create((IElementType[])new IElementType[]{KtTokens.OVERRIDE_KEYWORD});
        COMPOUND_KEYWORDS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.COMPANION_KEYWORD), (Object)((Object)KtTokens.OBJECT_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.ENUM_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.ANNOTATION_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD))});
        KEYWORD_CONSTRUCTS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.IF_KEYWORD), (Object)"fun foo() { if (caret)"), TuplesKt.to((Object)((Object)KtTokens.WHILE_KEYWORD), (Object)"fun foo() { while(caret)"), TuplesKt.to((Object)((Object)KtTokens.FOR_KEYWORD), (Object)"fun foo() { for(caret)"), TuplesKt.to((Object)((Object)KtTokens.TRY_KEYWORD), (Object)"fun foo() { try {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.CATCH_KEYWORD), (Object)"fun foo() { try {} catch (caret)"), TuplesKt.to((Object)((Object)KtTokens.FINALLY_KEYWORD), (Object)"fun foo() { try {\n}\nfinally{\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.DO_KEYWORD), (Object)"fun foo() { do {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.INIT_KEYWORD), (Object)"class C { init {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.CONSTRUCTOR_KEYWORD), (Object)"class C { constructor(caret)")});
        $receiver$iv = CollectionsKt.listOf((Object[])new KtKeywordToken[]{KtTokens.THIS_KEYWORD, KtTokens.SUPER_KEYWORD, KtTokens.NULL_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.FILE_KEYWORD, KtTokens.DYNAMIC_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD});
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (KtKeywordToken)((Object)item$iv$iv);
            collection = destination$iv$iv;
            object = it.getValue();
            collection.add(object);
        }
        NO_SPACE_AFTER = CollectionsKt.plus((Collection)((List)var3_3), (Object)"companion object");
        GENERAL_FILTER = new NotFilter((ElementFilter)new OrFilter(new ElementFilter[]{new CommentFilter(), (ElementFilter)new ParentFilter((ElementFilter)new ClassFilter(KtLiteralStringTemplateEntry.class)), (ElementFilter)new ParentFilter((ElementFilter)new ClassFilter(KtConstantExpression.class)), (ElementFilter)new LeftNeighbour((ElementFilter)new TextFilter(".")), (ElementFilter)new LeftNeighbour((ElementFilter)new TextFilter("?."))}));
    }

    static {
        new KeywordCompletion();
    }

    public static final /* synthetic */ boolean access$matchesKeyword(KeywordCompletion $this, @NotNull IElementType $receiver, @NotNull KtKeywordToken keywordType) {
        return $this.matchesKeyword($receiver, keywordType);
    }

    public static final /* synthetic */ boolean access$isErrorElementBefore(KeywordCompletion $this, @NotNull PsiElement token) {
        return $this.isErrorElementBefore(token);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$UseSiteAnnotationTargetInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea-completion"})
    private static final class UseSiteAnnotationTargetInsertHandler
    implements InsertHandler<LookupElement> {
        public static final UseSiteAnnotationTargetInsertHandler INSTANCE;

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            new WithTailInsertHandler(":", false, false, false, 8, null).postHandleInsert(context, item);
        }

        private UseSiteAnnotationTargetInsertHandler() {
            INSTANCE = this;
        }

        static {
            new UseSiteAnnotationTargetInsertHandler();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$SpaceAfterInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea-completion"})
    private static final class SpaceAfterInsertHandler
    implements InsertHandler<LookupElement> {
        public static final SpaceAfterInsertHandler INSTANCE;

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            WithTailInsertHandler.Companion.getSPACE().postHandleInsert(context, item);
        }

        private SpaceAfterInsertHandler() {
            INSTANCE = this;
        }

        static {
            new SpaceAfterInsertHandler();
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\u0010\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$CommentFilter;", "Lcom/intellij/psi/filters/ElementFilter;", "()V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "isClassAcceptable", "hintClass", "Ljava/lang/Class;", "idea-completion"})
    private static final class CommentFilter
    implements ElementFilter {
        public boolean isAcceptable(@Nullable Object element2, @Nullable PsiElement context) {
            return element2 instanceof PsiElement && KtPsiUtil.isInComment((PsiElement)element2);
        }

        public boolean isClassAcceptable(@NotNull Class<? extends Object> hintClass) {
            Intrinsics.checkParameterIsNotNull(hintClass, (String)"hintClass");
            return true;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$ParentFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "idea-completion"})
    private static final class ParentFilter
    extends PositionElementFilter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element2, @Nullable PsiElement context) {
            Object object = element2;
            if (!(object instanceof PsiElement)) {
                object = null;
            }
            PsiElement psiElement = (PsiElement)object;
            if (psiElement == null) return false;
            PsiElement psiElement2 = psiElement.getParent();
            PsiElement parent2 = psiElement2;
            if (parent2 == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)parent2, context);
            if (!bl) return false;
            return true;
        }

        public ParentFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkParameterIsNotNull((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }
    }
}

