/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/completion/DeclarationLookupObjectImpl;", "Lorg/jetbrains/kotlin/idea/core/completion/DeclarationLookupObject;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lcom/intellij/psi/PsiElement;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "importableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getImportableFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "isDeprecated", "", "()Z", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "equals", "other", "", "hashCode", "", "toString", "", "idea-completion"})
public abstract class DeclarationLookupObjectImpl
implements DeclarationLookupObject {
    private final boolean isDeprecated;
    @Nullable
    private final DeclarationDescriptor descriptor;
    @Nullable
    private final PsiElement psiElement;

    @Override
    @Nullable
    public Name getName() {
        Object object = this.descriptor;
        if (object == null || (object = object.getName()) == null) {
            Object object2;
            PsiElement psiElement = this.psiElement;
            if (!(psiElement instanceof PsiNamedElement)) {
                psiElement = null;
            }
            if ((object2 = (PsiNamedElement)psiElement) != null && (object2 = object2.getName()) != null) {
                Object object3 = object2;
                String it = (String)object3;
                object = Name.identifier(it);
            } else {
                object = null;
            }
        }
        return object;
    }

    @Override
    @Nullable
    public FqName getImportableFqName() {
        FqName fqName2;
        if (this.descriptor != null) {
            fqName2 = ImportsUtils.getImportableFqName(this.descriptor);
        } else {
            Object object;
            PsiElement psiElement = this.psiElement;
            if (!(psiElement instanceof PsiClass)) {
                psiElement = null;
            }
            if ((object = (PsiClass)psiElement) != null && (object = object.getQualifiedName()) != null) {
                Object object2 = object;
                String it = (String)object2;
                fqName2 = new FqName(it);
            } else {
                fqName2 = null;
            }
        }
        return fqName2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(super.toString()).append(" ");
        DeclarationDescriptor declarationDescriptor = this.descriptor;
        if (declarationDescriptor == null) {
            declarationDescriptor = this.psiElement;
        }
        return stringBuilder.append(declarationDescriptor).toString();
    }

    public int hashCode() {
        int n;
        if (this.descriptor != null) {
            n = this.descriptor.getOriginal().hashCode();
        } else {
            PsiElement psiElement = this.psiElement;
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            n = psiElement.hashCode();
        }
        return n;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        Object object = other;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.DeclarationLookupObjectImpl");
        }
        DeclarationLookupObjectImpl lookupObject2 = (DeclarationLookupObjectImpl)object;
        return DescriptorUtilsKt.descriptorsEqualWithSubstitution(this.descriptor, lookupObject2.descriptor) && Intrinsics.areEqual((Object)this.psiElement, (Object)lookupObject2.psiElement);
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    @Nullable
    public final DeclarationDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @Nullable
    public final PsiElement getPsiElement() {
        return this.psiElement;
    }

    public DeclarationLookupObjectImpl(@Nullable DeclarationDescriptor descriptor2, @Nullable PsiElement psiElement) {
        boolean bl;
        this.descriptor = descriptor2;
        this.psiElement = psiElement;
        boolean bl2 = this.descriptor != null || this.psiElement != null;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.descriptor != null) {
            bl = KotlinBuiltIns.isDeprecated(this.descriptor);
        } else {
            PsiElement psiElement2 = this.psiElement;
            if (!(psiElement2 instanceof PsiDocCommentOwner)) {
                psiElement2 = null;
            }
            PsiDocCommentOwner psiDocCommentOwner = (PsiDocCommentOwner)psiElement2;
            bl = psiDocCommentOwner != null ? psiDocCommentOwner.isDeprecated() : false;
        }
        this.isDeprecated = bl;
    }
}

