/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

public abstract class KotlinExpressionSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements2) {
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "isApplicable"));
        }
        if (elements2.length != 1 || !(elements2[0] instanceof KtExpression)) {
            return false;
        }
        KtExpression expression2 = (KtExpression)elements2[0];
        if (expression2 instanceof KtCallExpression && expression2.getParent() instanceof KtQualifiedExpression) {
            return false;
        }
        KotlinType type2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (type2 == null || KotlinBuiltIns.isUnit(type2)) {
            return false;
        }
        return this.isApplicable(expression2);
    }

    protected abstract boolean isApplicable(@NotNull KtExpression var1);

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "surroundElements"));
        }
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "surroundElements"));
        }
        assert (elements2.length == 1) : "KotlinExpressionSurrounder should be applicable only for 1 expression: " + elements2.length;
        return this.surroundExpression(project, editor, (KtExpression)elements2[0]);
    }

    @Nullable
    protected abstract TextRange surroundExpression(@NotNull Project var1, @NotNull Editor var2, @NotNull KtExpression var3);
}

