/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodBodyVisitor;
import org.jetbrains.kotlin.codegen.inline.RegeneratedLambdaFieldRemapper;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class RemapVisitor
extends MethodBodyVisitor {
    private final LocalVarRemapper remapper;
    private final FieldRemapper nodeRemapper;
    private final InstructionAdapter instructionAdapter;

    public RemapVisitor(@NotNull MethodVisitor mv, @NotNull LocalVarRemapper remapper, @NotNull FieldRemapper nodeRemapper) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "<init>"));
        }
        if (remapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapper", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "<init>"));
        }
        if (nodeRemapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeRemapper", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "<init>"));
        }
        super(mv);
        this.instructionAdapter = new InstructionAdapter(mv);
        this.remapper = remapper;
        this.nodeRemapper = nodeRemapper;
    }

    public void visitIincInsn(int var, int increment) {
        this.remapper.visitIincInsn(var, increment, this.mv);
    }

    public void visitVarInsn(int opcode, int var) {
        this.remapper.visitVarInsn(opcode, var, this.instructionAdapter);
    }

    public void visitLocalVariable(@NotNull String name2, @NotNull String desc, String signature, @NotNull Label start, @NotNull Label end, int index2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitLocalVariable"));
        }
        this.remapper.visitLocalVariable(name2, desc, signature, start, end, index2, this.mv);
    }

    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String desc) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitFieldInsn"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitFieldInsn"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/RemapVisitor", "visitFieldInsn"));
        }
        if (name2.startsWith("$$$") && (this.nodeRemapper instanceof RegeneratedLambdaFieldRemapper || this.nodeRemapper.isRoot())) {
            FieldInsnNode fin = new FieldInsnNode(opcode, owner, name2, desc);
            StackValue inline = this.nodeRemapper.getFieldForInline(fin, null);
            assert (inline != null) : "Captured field should have not null stackValue " + fin;
            inline.put(inline.type, this);
            return;
        }
        super.visitFieldInsn(opcode, owner, name2, desc);
    }
}

