/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsObjectScope;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsScopesKt;
import com.google.dart.compiler.util.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names;
    private final JsScope parent;
    private int tempIndex;
    private final String scopeId;
    private static final Pattern FRESH_NAME_SUFFIX = Pattern.compile("[\\$_]\\d+$");

    public JsScope(JsScope parent2, @NotNull String description, @Nullable String scopeId) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/google/dart/compiler/backend/js/ast/JsScope", "<init>"));
        }
        this.names = Collections.emptyMap();
        this.tempIndex = 0;
        this.scopeId = scopeId;
        this.description = description;
        this.parent = parent2;
    }

    protected JsScope(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/google/dart/compiler/backend/js/ast/JsScope", "<init>"));
        }
        this.names = Collections.emptyMap();
        this.tempIndex = 0;
        this.description = description;
        this.parent = null;
        this.scopeId = null;
    }

    @NotNull
    public JsScope innerObjectScope(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/google/dart/compiler/backend/js/ast/JsScope", "innerObjectScope"));
        }
        JsObjectScope jsObjectScope = JsScopesKt.JsObjectScope(this, scopeName);
        if (jsObjectScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "innerObjectScope"));
        }
        return jsObjectScope;
    }

    @NotNull
    public JsName declareName(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/google/dart/compiler/backend/js/ast/JsScope", "declareName"));
        }
        JsName name2 = this.findOwnName(identifier);
        JsName jsName = name2 != null ? name2 : this.doCreateName(identifier);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "declareName"));
        }
        return jsName;
    }

    @NotNull
    public JsName declareFreshName(@NotNull String suggestedName) {
        if (suggestedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedName", "com/google/dart/compiler/backend/js/ast/JsScope", "declareFreshName"));
        }
        assert (!suggestedName.isEmpty());
        String ident = this.getFreshIdent(suggestedName);
        JsName jsName = this.doCreateName(ident);
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "declareFreshName"));
        }
        return jsName;
    }

    private String getNextTempName() {
        return "tmp$" + (this.scopeId != null ? this.scopeId + "$" : "") + this.tempIndex++;
    }

    @NotNull
    public JsName declareTemporary() {
        JsName jsName = this.declareFreshName(this.getNextTempName());
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "declareTemporary"));
        }
        return jsName;
    }

    @Nullable
    public final JsName findName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsScope", "findName"));
        }
        JsName name2 = this.findOwnName(ident);
        if (name2 == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name2;
    }

    public boolean hasOwnName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/google/dart/compiler/backend/js/ast/JsScope", "hasOwnName"));
        }
        return this.names.containsKey(name2);
    }

    @Nullable
    public boolean hasName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/google/dart/compiler/backend/js/ast/JsScope", "hasName"));
        }
        return this.hasOwnName(name2) || this.parent != null && this.parent.hasName(name2);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    public void copyOwnNames(JsScope other) {
        this.names = new HashMap<String, JsName>(this.names);
        this.names.putAll(other.names);
    }

    @NotNull
    public String getDescription() {
        String string = this.description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "getDescription"));
        }
        return string;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsScope", "doCreateName"));
        }
        JsName name2 = new JsName(this, ident);
        this.names = Maps.put(this.names, ident, name2);
        JsName jsName = name2;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "doCreateName"));
        }
        return jsName;
    }

    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "com/google/dart/compiler/backend/js/ast/JsScope", "findOwnName"));
        }
        return this.names.get(ident);
    }

    @NotNull
    protected String getFreshIdent(@NotNull String suggestedIdent) {
        if (suggestedIdent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedIdent", "com/google/dart/compiler/backend/js/ast/JsScope", "getFreshIdent"));
        }
        char sep = '_';
        String baseName = suggestedIdent;
        int counter = 0;
        Matcher matcher2 = FRESH_NAME_SUFFIX.matcher(suggestedIdent);
        if (matcher2.find()) {
            String group = matcher2.group();
            baseName = matcher2.replaceAll("");
            sep = group.charAt(0);
            counter = Integer.valueOf(group.substring(1));
        }
        String freshName = suggestedIdent;
        while (this.hasName(freshName)) {
            freshName = baseName + sep + counter++;
        }
        String string = freshName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsScope", "getFreshIdent"));
        }
        return string;
    }
}

