/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsFunction
extends JsLiteral
implements HasName {
    @NotNull
    private JsBlock body;
    private List<JsParameter> params;
    @NotNull
    private final JsFunctionScope scope;
    private JsName name;

    public JsFunction(@NotNull JsScope parentScope, @NotNull String description) {
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        this(parentScope, description, null);
    }

    public JsFunction(@NotNull JsScope parentScope, @NotNull JsBlock body2, @NotNull String description) {
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        if (body2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        this(parentScope, description, null);
        this.body = body2;
    }

    private JsFunction(@NotNull JsScope parentScope, @NotNull String description, @Nullable JsName name2) {
        if (parentScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentScope", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/google/dart/compiler/backend/js/ast/JsFunction", "<init>"));
        }
        this.name = name2;
        this.scope = new JsFunctionScope(parentScope, name2 == null ? description : name2.getIdent());
    }

    @NotNull
    public JsBlock getBody() {
        JsBlock jsBlock = this.body;
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFunction", "getBody"));
        }
        return jsBlock;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    @Override
    public Symbol getSymbol() {
        return this.name;
    }

    @NotNull
    public List<JsParameter> getParameters() {
        if (this.params == null) {
            this.params = new SmartList();
        }
        List<JsParameter> list2 = this.params;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFunction", "getParameters"));
        }
        return list2;
    }

    @NotNull
    public JsFunctionScope getScope() {
        JsFunctionScope jsFunctionScope = this.scope;
        if (jsFunctionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFunction", "getScope"));
        }
        return jsFunctionScope;
    }

    public void setBody(@NotNull JsBlock body2) {
        if (body2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/google/dart/compiler/backend/js/ast/JsFunction", "setBody"));
        }
        this.body = body2;
    }

    public void setName(@Nullable JsName name2) {
        this.name = name2;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFunction(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.getParameters());
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.getParameters());
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsFunction deepCopy() {
        JsFunction functionCopy = new JsFunction(this.scope.getParent(), this.scope.getDescription(), this.name);
        functionCopy.getScope().copyOwnNames(this.scope);
        functionCopy.setBody(this.body.deepCopy());
        functionCopy.params = AstUtil.deepCopy(this.params);
        JsFunction jsFunction = functionCopy.withMetadataFrom(this);
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsFunction", "deepCopy"));
        }
        return jsFunction;
    }
}

