/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;

public class FileWatcher {
    private final String name;
    private final Set<Path> targets = new HashSet<Path>();
    private final Map<Path, FileTime> modifiedTimes = new HashMap<Path, FileTime>();
    private final long pollingTime;
    private final Delegate delegate;
    private boolean started;
    private Timer watchingTimer;

    public FileWatcher(long pollingTime, Delegate delegate, String name) {
        assert (pollingTime > 0L);
        assert (delegate != null);
        assert (name != null);
        this.pollingTime = pollingTime;
        this.delegate = delegate;
        this.name = this.getClass().getSimpleName() + "[" + name + "]";
    }

    public synchronized void addTarget(Path target) {
        assert (target != null);
        assert (!this.targets.contains(target));
        this.targets.add(target);
        try {
            FileTime modifiedTime = Files.getLastModifiedTime(target, new LinkOption[0]);
            this.modifiedTimes.put(target, modifiedTime);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateWatchingTimer();
    }

    public synchronized void removeTarget(Path target) {
        assert (target != null);
        assert (this.targets.contains(target));
        this.targets.remove(target);
        this.modifiedTimes.remove(target);
        this.updateWatchingTimer();
    }

    public synchronized void setTargets(Collection<Path> newTargets) {
        HashSet<Path> toBeAdded = new HashSet<Path>();
        toBeAdded.addAll(newTargets);
        toBeAdded.removeAll(this.targets);
        HashSet<Path> toBeRemoved = new HashSet<Path>();
        toBeRemoved.addAll(this.targets);
        toBeRemoved.removeAll(newTargets);
        for (Path target : toBeAdded) {
            this.addTarget(target);
        }
        for (Path target : toBeRemoved) {
            this.removeTarget(target);
        }
    }

    public synchronized Set<Path> getTargets() {
        return Collections.unmodifiableSet(this.targets);
    }

    public synchronized void start() {
        assert (!this.isStarted());
        this.started = true;
        this.updateWatchingTimer();
    }

    public synchronized void stop() {
        assert (this.isStarted());
        this.started = false;
        this.updateWatchingTimer();
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    private void updateWatchingTimer() {
        boolean timerNeeded;
        boolean bl = timerNeeded = this.started && !this.targets.isEmpty();
        if (timerNeeded) {
            if (this.watchingTimer == null) {
                this.watchingTimer = new Timer(this.name, true);
                this.watchingTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        FileWatcher.this.runWatching();
                    }
                }, this.pollingTime, this.pollingTime);
            }
        } else if (this.watchingTimer != null) {
            this.watchingTimer.cancel();
            this.watchingTimer = null;
        }
    }

    private synchronized void runWatching() {
        if (this.watchingTimer != null) {
            for (Path target : this.targets) {
                FileTime newModifiedTime;
                try {
                    newModifiedTime = Files.getLastModifiedTime(target, new LinkOption[0]);
                }
                catch (IOException x) {
                    newModifiedTime = null;
                }
                FileTime lastModifiedTime = this.modifiedTimes.get(target);
                if (lastModifiedTime == null && newModifiedTime != null) {
                    this.modifiedTimes.put(target, newModifiedTime);
                    Platform.runLater(() -> this.delegate.fileWatcherDidWatchTargetCreation(target));
                    continue;
                }
                if (lastModifiedTime != null && newModifiedTime == null) {
                    this.modifiedTimes.remove(target);
                    Platform.runLater(() -> this.delegate.fileWatcherDidWatchTargetDeletion(target));
                    continue;
                }
                if (Objects.equals(lastModifiedTime, newModifiedTime)) continue;
                assert (newModifiedTime != null);
                this.modifiedTimes.put(target, newModifiedTime);
                Platform.runLater(() -> this.delegate.fileWatcherDidWatchTargetModification(target));
            }
        }
    }

    public static interface Delegate {
        public void fileWatcherDidWatchTargetCreation(Path var1);

        public void fileWatcherDidWatchTargetDeletion(Path var1);

        public void fileWatcherDidWatchTargetModification(Path var1);
    }
}

