/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.library;

import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportRow;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.ImportRowComparator;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.LibraryPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.ErrorDialog;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.library.user.UserLibrary;
import com.oracle.javafx.scenebuilder.kit.library.util.JarExplorer;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReport;
import com.oracle.javafx.scenebuilder.kit.library.util.JarReportEntry;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class ImportWindowController
extends AbstractModalDialog {
    final List<File> importFiles;
    private final LibraryPanelController libPanelController;
    Task<List<JarReport>> exploringTask = null;
    URLClassLoader importClassLoader;
    Node zeNode = new Label(I18N.getString("import.preview.unable"));
    double builtinPrefWidth;
    double builtinPrefHeight;
    private int numOfImportedJar;
    private List<String> alreadyExcludedItems = new ArrayList<String>();
    @FXML
    private VBox leftHandSidePart;
    @FXML
    private Label processingLabel;
    @FXML
    ProgressIndicator processingProgressIndicator;
    @FXML
    ListView<ImportRow> importList = new ListView();
    @FXML
    ChoiceBox<String> defSizeChoice;
    @FXML
    private Label sizeLabel;
    @FXML
    private SplitPane topSplitPane;
    @FXML
    Group previewGroup;
    @FXML
    Label numOfItemsLabel;
    @FXML
    Label classNameLabel;
    @FXML
    Label previewHintLabel;
    @FXML
    ToggleButton checkAllUncheckAllToggle;

    public ImportWindowController(LibraryPanelController lpc, List<File> files, Window owner) {
        super(ImportWindowController.class.getResource("ImportDialog.fxml"), I18N.getBundle(), owner);
        this.libPanelController = lpc;
        this.importFiles = new ArrayList<File>(files);
    }

    @Override
    protected void cancelButtonPressed(ActionEvent e) {
        if (this.exploringTask != null && this.exploringTask.isRunning()) {
            this.exploringTask.setOnCancelled(t -> this.getStage().close());
            this.exploringTask.cancel(true);
        } else {
            this.getStage().close();
        }
        this.exploringTask = null;
        try {
            this.closeClassLoader();
        }
        catch (IOException ex) {
            this.showErrorDialog(ex);
        }
    }

    @Override
    protected void okButtonPressed(ActionEvent e) {
        this.exploringTask = null;
        this.getStage().close();
        try {
            this.closeClassLoader();
            this.libPanelController.copyFilesToUserLibraryDir(this.importFiles);
            UserLibrary userLib = (UserLibrary)this.libPanelController.getEditorController().getLibrary();
            userLib.setFilter(this.getExcludedItems());
        }
        catch (IOException ex) {
            this.showErrorDialog(ex);
        }
        finally {
            this.alreadyExcludedItems.clear();
        }
    }

    @Override
    protected void actionButtonPressed(ActionEvent e) {
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.cancelButtonPressed(null);
    }

    @Override
    public void controllerDidLoadContentFxml() {
        assert (this.topSplitPane != null);
        assert (!this.topSplitPane.isVisible());
        assert (this.processingLabel != null);
        assert (this.processingProgressIndicator != null);
        assert (this.sizeLabel != null);
        assert (this.previewGroup != null);
        assert (this.importList != null);
        assert (this.defSizeChoice != null);
        assert (this.numOfItemsLabel != null);
        assert (this.leftHandSidePart != null);
        assert (this.classNameLabel != null);
        assert (this.previewHintLabel != null);
        assert (this.checkAllUncheckAllToggle != null);
        this.setOKButtonVisible(true);
        this.setDefaultButtonID(AbstractModalDialog.ButtonID.OK);
        this.setShowDefaultButton(true);
        this.defSizeChoice.getItems().clear();
        this.defSizeChoice.getItems().addAll((Object[])new String[]{I18N.getString("import.choice.builtin"), "200 x 100", "200 x 200"});
        this.defSizeChoice.getSelectionModel().selectFirst();
        this.defSizeChoice.getSelectionModel().selectedIndexProperty().addListener((ov, t, t1) -> {
            assert (t1 instanceof Integer);
            this.updateSize((Integer)t1);
        });
        this.checkAllUncheckAllToggle.selectedProperty().addListener((ov, t, t1) -> {
            if (t1.booleanValue()) {
                for (ImportRow row1 : this.importList.getItems()) {
                    row1.setImportRequired(false);
                }
                this.checkAllUncheckAllToggle.setText(I18N.getString("import.toggle.checkall"));
            } else {
                for (ImportRow row2 : this.importList.getItems()) {
                    row2.setImportRequired(true);
                }
                this.checkAllUncheckAllToggle.setText(I18N.getString("import.toggle.uncheckall"));
            }
        });
        this.setProcessing();
        SplitPane.setResizableWithParent((Node)this.leftHandSidePart, (Boolean)false);
        this.work();
    }

    @Override
    protected void controllerDidCreateStage() {
        this.getStage().setTitle(I18N.getString("import.window.title"));
        this.getStage().initModality(Modality.APPLICATION_MODAL);
    }

    private void closeClassLoader() throws IOException {
        if (this.importClassLoader != null) {
            this.importClassLoader.close();
        }
    }

    List<File> buildListOfAllFiles(List<File> importFiles) throws IOException {
        ArrayList<File> res = new ArrayList<File>(importFiles);
        String userLibraryDir = ((UserLibrary)this.libPanelController.getEditorController().getLibrary()).getPath();
        Path userLibraryPath = new File(userLibraryDir).toPath();
        try (Stream<Path> pathStream = Files.list(userLibraryPath);){
            Iterator pathIterator = pathStream.iterator();
            while (pathIterator.hasNext()) {
                Path element = (Path)pathIterator.next();
                if (!element.toString().endsWith(".jar")) continue;
                res.add(element.toFile());
            }
        }
        return res;
    }

    private void work() {
        this.exploringTask = new Task<List<JarReport>>(){

            protected List<JarReport> call() throws Exception {
                ArrayList<JarReport> res = new ArrayList<JarReport>();
                ImportWindowController.this.numOfImportedJar = ImportWindowController.this.importFiles.size();
                List<File> allFiles = ImportWindowController.this.buildListOfAllFiles(ImportWindowController.this.importFiles);
                URLClassLoader classLoader = ImportWindowController.this.getClassLoaderForFiles(allFiles);
                int index = 1;
                for (File file : ImportWindowController.this.importFiles) {
                    if (this.isCancelled()) {
                        this.updateMessage(I18N.getString("import.work.cancelled"));
                        break;
                    }
                    this.updateMessage(I18N.getString("import.work.exploring", file.getName()));
                    JarExplorer explorer = new JarExplorer(Paths.get(file.getAbsolutePath(), new String[0]));
                    JarReport jarReport = explorer.explore(classLoader);
                    res.add(jarReport);
                    this.updateProgress(index, ImportWindowController.this.numOfImportedJar);
                    ++index;
                }
                this.updateProgress(ImportWindowController.this.numOfImportedJar, ImportWindowController.this.numOfImportedJar);
                ImportWindowController.this.updateImportClassLoader(classLoader);
                return res;
            }
        };
        Thread th = new Thread((Runnable)this.exploringTask);
        th.setDaemon(true);
        this.processingProgressIndicator.progressProperty().bind((ObservableValue)this.exploringTask.progressProperty());
        this.exploringTask.setOnFailed(t -> {
            this.getStage().toFront();
            this.updateNumOfItemsLabelAndSelectionToggleState();
        });
        this.exploringTask.setOnSucceeded(t -> {
            assert (Platform.isFxApplicationThread());
            this.getStage().toFront();
            try {
                UserLibrary userLib = (UserLibrary)this.libPanelController.getEditorController().getLibrary();
                this.alreadyExcludedItems = userLib.getFilter();
                List jarReportList = (List)this.exploringTask.get();
                Callback importRequired = row -> row.importRequired();
                this.importList.setCellFactory(CheckBoxListCell.forListView((Callback)importRequired));
                for (JarReport jarReport : jarReportList) {
                    for (JarReportEntry e : jarReport.getEntries()) {
                        if (e.getStatus() != JarReportEntry.Status.OK || !e.isNode()) continue;
                        boolean checked = true;
                        if (this.alreadyExcludedItems.contains(e.getKlass().getCanonicalName())) {
                            checked = false;
                            this.alreadyExcludedItems.remove(e.getKlass().getCanonicalName());
                        }
                        ImportRow importRow = new ImportRow(checked, e, null);
                        this.importList.getItems().add((Object)importRow);
                        importRow.importRequired().addListener((ov, oldValue, newValue) -> {
                            int numOfComponentToImport = this.getNumOfComponentToImport(this.importList);
                            this.updateOKButtonTitle(numOfComponentToImport);
                            this.updateSelectionToggleText(numOfComponentToImport);
                        });
                    }
                }
                Collections.sort(this.importList.getItems(), new ImportRowComparator());
                int numOfComponentToImport = this.getNumOfComponentToImport(this.importList);
                this.updateOKButtonTitle(numOfComponentToImport);
                this.updateSelectionToggleText(numOfComponentToImport);
                this.updateNumOfItemsLabelAndSelectionToggleState();
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                this.getStage().close();
                this.showErrorDialog(ex);
            }
            this.unsetProcessing();
        });
        th.start();
    }

    private void showErrorDialog(Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(null);
        errorDialog.setTitle(I18N.getString("import.error.title"));
        errorDialog.setMessage(I18N.getString("import.error.message"));
        errorDialog.setDetails(I18N.getString("import.error.details"));
        errorDialog.setDebugInfoWithThrowable(exception);
        errorDialog.showAndWait();
    }

    void updateImportClassLoader(URLClassLoader cl) {
        this.importClassLoader = cl;
    }

    void unsetProcessing() {
        this.processingProgressIndicator.setVisible(false);
        this.processingLabel.setVisible(false);
        this.topSplitPane.setVisible(true);
        this.importList.getSelectionModel().selectedItemProperty().addListener((ov, t, t1) -> {
            this.previewGroup.getChildren().clear();
            String fxmlText = JarExplorer.makeFxmlText(t1.getJarReportEntry().getKlass());
            try {
                FXOMDocument fxomDoc = new FXOMDocument(fxmlText, null, this.importClassLoader, null);
                this.zeNode = (Node)fxomDoc.getSceneGraphRoot();
            }
            catch (IOException ioe) {
                this.showErrorDialog(ioe);
            }
            try {
                Group visualGroup = new Group(new Node[]{this.zeNode});
                Scene hiddenScene = new Scene((Parent)visualGroup);
                Stage hiddenStage = new Stage();
                hiddenStage.setScene(hiddenScene);
                visualGroup.applyCss();
                visualGroup.layout();
                Bounds zeBounds = this.zeNode.getLayoutBounds();
                this.builtinPrefWidth = zeBounds.getWidth();
                this.builtinPrefHeight = zeBounds.getHeight();
                hiddenScene.setRoot((Parent)new Group());
                hiddenStage.close();
            }
            catch (Error e) {
                this.builtinPrefWidth = 0.0;
                this.builtinPrefHeight = 0.0;
            }
            if (this.builtinPrefWidth == 0.0 || this.builtinPrefHeight == 0.0) {
                ((Region)this.zeNode).setPrefSize(200.0, 200.0);
                this.setSizeLabel(PrefSize.TWO_HUNDRED_BY_TWO_HUNDRED);
                this.defSizeChoice.getSelectionModel().select(2);
            } else {
                this.setSizeLabel(PrefSize.DEFAULT);
                this.defSizeChoice.getSelectionModel().selectFirst();
            }
            this.previewGroup.getChildren().add((Object)this.zeNode);
            this.defSizeChoice.setDisable(false);
            this.classNameLabel.setText(t1.getJarReportEntry().getKlass().getName());
        });
        if (this.importList.getItems().size() > 0) {
            this.importList.getSelectionModel().selectFirst();
        }
    }

    private URLClassLoader getClassLoaderForFiles(List<File> files) {
        return new URLClassLoader(this.makeURLArrayFromFiles(files));
    }

    private URL[] makeURLArrayFromFiles(List<File> files) {
        URL[] result = new URL[files.size()];
        try {
            int index = 0;
            for (File file : files) {
                result[index] = new URL("jar", "", file.toURI().toURL() + "!/");
                ++index;
            }
        }
        catch (MalformedURLException x) {
            throw new RuntimeException("Bug in " + this.getClass().getSimpleName(), x);
        }
        return result;
    }

    private void setProcessing() {
        this.cancelButton.setDefaultButton(true);
    }

    private int getNumOfComponentToImport(ListView<ImportRow> list) {
        int res = 0;
        for (ImportRow row : list.getItems()) {
            if (!row.isImportRequired()) continue;
            ++res;
        }
        return res;
    }

    private List<String> getExcludedItems() {
        ArrayList<String> res = new ArrayList<String>(this.alreadyExcludedItems);
        for (ImportRow row : this.importList.getItems()) {
            if (row.isImportRequired()) continue;
            res.add(row.getCanonicalClassName());
        }
        return res;
    }

    private void updateOKButtonTitle(int numOfComponentToImport) {
        if (numOfComponentToImport == 0) {
            if (this.numOfImportedJar == 1) {
                this.setOKButtonTitle(I18N.getString("import.button.import.jar"));
            } else {
                this.setOKButtonTitle(I18N.getString("import.button.import.jars"));
            }
        } else if (numOfComponentToImport == 1) {
            this.setOKButtonTitle(I18N.getString("import.button.import.component"));
        } else {
            this.setOKButtonTitle(I18N.getString("import.button.import.components"));
        }
    }

    void updateNumOfItemsLabelAndSelectionToggleState() {
        int num = this.importList.getItems().size();
        if (num == 0 || num == 1) {
            this.numOfItemsLabel.setText(num + " " + I18N.getString("import.num.item"));
        } else {
            this.numOfItemsLabel.setText(num + " " + I18N.getString("import.num.items"));
        }
        if (num >= 1) {
            this.checkAllUncheckAllToggle.setDisable(false);
        }
    }

    private void updateSelectionToggleText(int numOfComponentToImport) {
        if (numOfComponentToImport == 0) {
            this.checkAllUncheckAllToggle.setText(I18N.getString("import.toggle.checkall"));
        } else {
            this.checkAllUncheckAllToggle.setText(I18N.getString("import.toggle.uncheckall"));
        }
    }

    private void updateSize(Integer choice) {
        if (this.zeNode instanceof Region) {
            PrefSize prefSize = PrefSize.values()[choice];
            switch (prefSize) {
                case DEFAULT: {
                    ((Region)this.zeNode).setPrefSize(this.builtinPrefWidth, this.builtinPrefHeight);
                    this.setSizeLabel(prefSize);
                    break;
                }
                case TWO_HUNDRED_BY_ONE_HUNDRED: {
                    ((Region)this.zeNode).setPrefSize(200.0, 100.0);
                    this.setSizeLabel(prefSize);
                    break;
                }
                case TWO_HUNDRED_BY_TWO_HUNDRED: {
                    ((Region)this.zeNode).setPrefSize(200.0, 200.0);
                    this.setSizeLabel(prefSize);
                    break;
                }
            }
            this.defSizeChoice.getSelectionModel().select(choice.intValue());
        }
    }

    private void setSizeLabel(PrefSize ps) {
        switch (ps) {
            case DEFAULT: {
                this.sizeLabel.setText(this.builtinPrefWidth + " x " + this.builtinPrefHeight);
                break;
            }
            case TWO_HUNDRED_BY_ONE_HUNDRED: {
                this.sizeLabel.setText("200 x 100");
                break;
            }
            case TWO_HUNDRED_BY_TWO_HUNDRED: {
                this.sizeLabel.setText("200 x 200");
                break;
            }
        }
    }

    public static enum PrefSize {
        DEFAULT,
        TWO_HUNDRED_BY_ONE_HUNDRED,
        TWO_HUNDRED_BY_TWO_HUNDRED;

    }
}

