/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.DoubleField;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;

public class Point3DEditor
extends PropertyEditor {
    private Parent root;
    @FXML
    private DoubleField xDf;
    @FXML
    private DoubleField yDf;
    @FXML
    private DoubleField zDf;
    DoubleField[] doubleFields = new DoubleField[3];

    public Point3DEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initialize();
    }

    private void initialize() {
        this.root = EditorUtils.loadFxml("Point3DEditor.fxml", (Object)this);
        this.doubleFields[0] = this.xDf;
        this.doubleFields[1] = this.yDf;
        this.doubleFields[2] = this.zDf;
        for (DoubleField doubleField : this.doubleFields) {
            EventHandler valueListener = event -> this.userUpdateValueProperty(this.getValue());
            this.setNumericEditorBehavior(this, (Control)doubleField, (EventHandler<ActionEvent>)valueListener, false);
        }
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_BOTTOM);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.root);
    }

    @Override
    public Object getValue() {
        Double[] values = new Double[3];
        int index = 0;
        for (DoubleField doubleField : this.doubleFields) {
            String val = doubleField.getText();
            if (val.isEmpty()) {
                val = "0";
                doubleField.setText(val);
            } else {
                try {
                    Double.parseDouble(val);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            values[index] = Double.valueOf(val);
            ++index;
        }
        return new Point3D(values[0].doubleValue(), values[1].doubleValue(), values[2].doubleValue());
    }

    @Override
    public void setValue(Object value) {
        assert (value != null);
        assert (value instanceof Point3D);
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        Point3D point3D = (Point3D)value;
        this.xDf.setText(EditorUtils.valAsStr(point3D.getX()));
        this.yDf.setText(EditorUtils.valAsStr(point3D.getY()));
        this.zDf.setText(EditorUtils.valAsStr(point3D.getZ()));
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.SIMPLE_LINE_BOTTOM);
    }

    @Override
    protected void valueIsIndeterminate() {
        for (DoubleField doubleField : this.doubleFields) {
            Point3DEditor.handleIndeterminate((Node)doubleField);
        }
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.xDf.requestFocus());
    }
}

