/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;

public class IntegerEditor
extends AutoSuggestEditor {
    private Map<String, Object> constants;
    private int min;
    private int max;

    public IntegerEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Object> constants, int minVal, int maxVal) {
        super(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()), AutoSuggestEditor.Type.INTEGER);
        this.initialize(constants, minVal, maxVal);
    }

    private void initialize(Map<String, Object> constants, int minVal, int maxVal) {
        this.constants = constants;
        this.min = minVal;
        this.max = maxVal;
        EventHandler onActionListener = event -> {
            if (this.isHandlingError()) {
                return;
            }
            Object value = this.getValue();
            if (value != null && ((IntegerPropertyMetadata)this.getPropertyMeta()).isValidValue((Integer)value)) {
                String constantStr = this.getConstant(value);
                if (constantStr != null) {
                    this.getTextField().setText(constantStr);
                } else {
                    assert (value instanceof Integer);
                    int val = (Integer)value;
                    if (val < this.min) {
                        val = this.min;
                    } else if (val > this.max) {
                        val = this.max;
                    }
                    value = val;
                    this.getTextField().setText(value.toString());
                }
                this.userUpdateValueProperty(value);
                this.getTextField().selectAll();
            } else {
                this.handleInvalidValue(this.getTextField().getText());
            }
        };
        this.setNumericEditorBehavior(this, (Control)this.getTextField(), (EventHandler<ActionEvent>)onActionListener);
    }

    @Override
    public Object getValue() {
        String val = this.getTextField().getText();
        if (val.isEmpty()) {
            val = "0";
            this.getTextField().setText(val);
            return Integer.valueOf(val);
        }
        Object constantValue = this.constants.get(val.toUpperCase(Locale.ROOT));
        if (constantValue != null) {
            val = EditorUtils.valAsStr(constantValue);
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            value = 0;
        }
        assert (value instanceof Integer);
        String constantStr = this.getConstant(value);
        if (constantStr != null) {
            value = constantStr;
        }
        this.getTextField().setText(EditorUtils.valAsStr(value));
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.getTextField().requestFocus());
    }

    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, Map<String, Object> constants, int minVal, int maxVal) {
        super.reset(propMeta, selectedClasses, new ArrayList<String>(constants.keySet()));
        this.constants = constants;
        this.min = minVal;
        this.max = maxVal;
    }

    private String getConstant(Object value) {
        for (Map.Entry<String, Object> entry : this.constants.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

