/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItem;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorItemDelegate;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.InlineListEditor;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ButtonTypePropertyMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

public class ButtonTypeEditor
extends InlineListEditor {
    private static Map<String, ButtonType> predefinedButtonsNames = new TreeMap<String, ButtonType>();
    private Collection<ButtonType> buttonList = new TreeSet<ButtonType>(this.getButtonTypeComparator());

    public ButtonTypeEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initialize();
    }

    private void initialize() {
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
        for (Map.Entry<ButtonType, String> entry : ButtonTypePropertyMetadata.getButtonTypeMap().entrySet()) {
            predefinedButtonsNames.put(entry.getValue(), entry.getKey());
        }
        this.updateButtonLists();
        this.addItem(this.getNewButtonTypeItem());
    }

    private ButtonTypeItem getNewButtonTypeItem() {
        return new ButtonTypeItem(this, this.buttonList);
    }

    private void updateButtonLists() {
        this.buttonList.clear();
        this.buttonList.addAll(predefinedButtonsNames.values());
        for (EditorItem item : this.getEditorItems()) {
            Object itemValueObj = item.getValue();
            if (itemValueObj == null) continue;
            assert (itemValueObj instanceof ButtonType);
            ButtonType itemValue = (ButtonType)itemValueObj;
            this.buttonList.remove(itemValue);
        }
        for (EditorItem item : this.getEditorItems()) {
            assert (item instanceof ButtonTypeItem);
            ((ButtonTypeItem)item).updateButtonList(this.buttonList);
        }
    }

    private Comparator<ButtonType> getButtonTypeComparator() {
        Comparator comparator = (bt1, bt2) -> bt1.getText().compareTo(bt2.getText());
        return comparator;
    }

    @Override
    public Object getValue() {
        ObservableList value = FXCollections.observableArrayList();
        for (EditorItem buttonTypeItem : this.getEditorItems()) {
            Object itemValueObj = buttonTypeItem.getValue();
            if (itemValueObj == null) continue;
            assert (itemValueObj instanceof ButtonType);
            ButtonType itemValue = (ButtonType)itemValueObj;
            value.add(itemValue);
        }
        if (value.isEmpty()) {
            return super.getPropertyMeta().getDefaultValueObject();
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (value == null) {
            this.reset();
            return;
        }
        assert (value instanceof List);
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        Iterator<EditorItem> itemsIter = new ArrayList<EditorItem>(this.getEditorItems()).iterator();
        for (ButtonType item : (List)value) {
            EditorItem editorItem;
            if (itemsIter.hasNext()) {
                editorItem = itemsIter.next();
                assert (editorItem instanceof ButtonTypeItem);
                ((ButtonTypeItem)editorItem).reset(predefinedButtonsNames.values());
            } else {
                editorItem = this.addItem(this.getNewButtonTypeItem());
            }
            editorItem.setValue(item);
        }
        while (itemsIter.hasNext()) {
            EditorItem editorItem = itemsIter.next();
            this.removeItem(editorItem);
        }
        this.updateButtonLists();
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.buttonList.clear();
        this.buttonList.addAll(predefinedButtonsNames.values());
        this.addItem(this.getNewButtonTypeItem());
    }

    @Override
    public void requestFocus() {
        EditorItem firstItem = this.getEditorItems().get(0);
        assert (firstItem instanceof ButtonTypeItem);
        ((ButtonTypeItem)firstItem).requestFocus();
    }

    @Override
    public void commit(EditorItem source) {
        super.commit(source);
        this.updateButtonLists();
    }

    @Override
    public void remove(EditorItem source) {
        super.remove(source);
        this.updateButtonLists();
    }

    private class ButtonTypeItem
    implements EditorItem {
        @FXML
        private Button plusBt;
        @FXML
        private Button minusBt;
        @FXML
        private ChoiceBox<ButtonType> buttonTypeCb;
        private Parent root;
        private EditorItemDelegate editor;

        public ButtonTypeItem(EditorItemDelegate editor, Collection<ButtonType> buttonList) {
            this.initialize(editor, buttonList);
        }

        private void initialize(final EditorItemDelegate editor, Collection<ButtonType> buttonList) {
            this.editor = editor;
            this.root = EditorUtils.loadFxml("ButtonTypeEditorItem.fxml", (Object)this);
            this.buttonTypeCb.setConverter(this.getButtonTypeConverter());
            this.buttonTypeCb.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ButtonType>(){

                public void changed(ObservableValue<? extends ButtonType> value, ButtonType prevValue, ButtonType newValue) {
                    editor.commit(ButtonTypeItem.this);
                    ButtonTypeItem.this.updatePlusMinusButtons();
                }
            });
            this.updateButtonList(buttonList);
            this.updatePlusMinusButtons();
        }

        public void updateButtonList(Collection<ButtonType> buttonList) {
            for (ButtonType buttonType : buttonList) {
                if (this.buttonTypeCb.getItems().contains((Object)buttonType)) continue;
                this.buttonTypeCb.getItems().add((Object)buttonType);
            }
            ArrayList currentItems = new ArrayList(this.buttonTypeCb.getItems());
            for (ButtonType buttonType : currentItems) {
                if (buttonList.contains(buttonType) || buttonType == this.getValue()) continue;
                this.buttonTypeCb.getItems().remove((Object)buttonType);
            }
        }

        @Override
        public final Node getNode() {
            return this.root;
        }

        @Override
        public Object getValue() {
            return this.buttonTypeCb.getSelectionModel().getSelectedItem();
        }

        @Override
        public void setValue(Object buttonType) {
            assert (buttonType instanceof ButtonType);
            this.buttonTypeCb.getSelectionModel().select((Object)((ButtonType)buttonType));
            this.updatePlusMinusButtons();
        }

        @Override
        public void reset() {
            this.buttonTypeCb.getSelectionModel().clearSelection();
        }

        public void reset(Collection<ButtonType> buttonList) {
            this.buttonTypeCb.getItems().clear();
            this.updateButtonList(buttonList);
        }

        public void requestFocus() {
            this.buttonTypeCb.requestFocus();
        }

        @Override
        public void setValueAsIndeterminate() {
            PropertyEditor.handleIndeterminate(this.buttonTypeCb);
        }

        @Override
        public MenuItem getMoveUpMenuItem() {
            return null;
        }

        @Override
        public MenuItem getMoveDownMenuItem() {
            return null;
        }

        @Override
        public MenuItem getRemoveMenuItem() {
            return null;
        }

        @Override
        public Button getPlusButton() {
            return this.plusBt;
        }

        @Override
        public Button getMinusButton() {
            return this.minusBt;
        }

        @FXML
        void add(ActionEvent event) {
            ButtonTypeItem buttonTypeItem = ButtonTypeEditor.this.getNewButtonTypeItem();
            this.editor.add(this, buttonTypeItem);
            buttonTypeItem.requestFocus();
        }

        @FXML
        void remove(ActionEvent event) {
            this.editor.remove(this);
        }

        @FXML
        void plusBtTyped(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                this.editor.add(this, ButtonTypeEditor.this.getNewButtonTypeItem());
            }
        }

        private void updatePlusMinusButtons() {
            if (this.buttonTypeCb.getSelectionModel().isEmpty()) {
                this.plusBt.setDisable(true);
                this.minusBt.setDisable(true);
            } else {
                this.plusBt.setDisable(false);
                this.minusBt.setDisable(false);
            }
        }

        protected void disablePlusButton(boolean disable) {
            this.plusBt.setDisable(disable);
        }

        protected void disableMinusButton(boolean disable) {
            this.minusBt.setDisable(disable);
        }

        private StringConverter<ButtonType> getButtonTypeConverter() {
            final Map<ButtonType, String> predefinedButtons = ButtonTypePropertyMetadata.getButtonTypeMap();
            return new StringConverter<ButtonType>(){

                public String toString(ButtonType buttonType) {
                    return (String)predefinedButtons.get(buttonType);
                }

                public ButtonType fromString(String buttonName) {
                    for (Map.Entry entry : predefinedButtons.entrySet()) {
                        if (!((String)entry.getValue()).equals(buttonName)) continue;
                        return (ButtonType)entry.getKey();
                    }
                    assert (false);
                    return null;
                }
            };
        }
    }
}

