/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver;

import com.oracle.javafx.scenebuilder.kit.util.Deprecation;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;

public class TableViewDesignInfoX {
    public Bounds getColumnBounds(TableColumn<?, ?> tableColumn) {
        TableView tv = tableColumn.getTableView();
        Bounds tb = tv.getLayoutBounds();
        Bounds hb = this.getColumnHeaderBounds(tableColumn);
        double x0 = hb.getMinX();
        double x1 = hb.getMaxX();
        double y0 = hb.getMinY();
        double y1 = tb.getMaxY();
        return new BoundingBox(x0, y0, x1 - x0, y1 - y0);
    }

    public Bounds getColumnHeaderBounds(TableColumn<?, ?> tableColumn) {
        TableView tv = tableColumn.getTableView();
        Node hn = this.getColumnNode(tableColumn);
        return Deprecation.localToLocal(hn, hn.getLayoutBounds(), (Node)tv);
    }

    public Node getColumnNode(TableColumn<?, ?> tableColumn) {
        assert (tableColumn != null);
        assert (tableColumn.getTableView() != null);
        TableView tableView = tableColumn.getTableView();
        Set set = tableView.lookupAll(".column-header");
        Node result = null;
        Iterator it = set.iterator();
        while (result == null && it.hasNext()) {
            Node n = (Node)it.next();
            assert (n instanceof TableColumnHeader);
            TableColumnBase tc = ((TableColumnHeader)n).getTableColumn();
            if (tc != tableColumn) continue;
            result = n;
        }
        return result;
    }

    public <T> TableColumn<T, ?> lookupColumn(TableView<T> tableView, double sceneX, double sceneY) {
        TableColumn result = null;
        Object tableColumns = tableView.getColumns();
        ArrayList columnPath = new ArrayList();
        while (!tableColumns.isEmpty()) {
            TableColumn<T, ?> tc = this.lookupColumn((List<TableColumn<T, ?>>)tableColumns, sceneX);
            if (tc != null) {
                columnPath.add(0, tc);
                tableColumns = tc.getColumns();
                continue;
            }
            tableColumns = Collections.emptyList();
        }
        if (columnPath.isEmpty()) {
            result = null;
        } else {
            for (TableColumn tableColumn : columnPath) {
                Point2D p;
                Node headerNode = this.getColumnNode(tableColumn);
                Bounds headerBounds = headerNode.getLayoutBounds();
                if (!headerBounds.contains(p = headerNode.sceneToLocal(sceneX, sceneY, true))) continue;
                result = tableColumn;
                break;
            }
        }
        return result;
    }

    private <T> TableColumn<T, ?> lookupColumn(List<TableColumn<T, ?>> tableColumns, double sceneX) {
        TableColumn<T, ?> result = null;
        for (TableColumn<T, ?> tc : tableColumns) {
            Node headerNode = this.getColumnNode(tc);
            if (headerNode == null) continue;
            Bounds headerBounds = headerNode.getLayoutBounds();
            Point2D p = headerNode.sceneToLocal(sceneX, 0.0, true);
            if (!(headerBounds.getMinX() <= p.getX()) || !(p.getX() < headerBounds.getMaxX())) continue;
            result = tc;
            break;
        }
        return result;
    }
}

