/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class RemoveCollectionItemJob
extends Job {
    private final FXOMObject targetValue;
    private FXOMCollection parentCollection;
    private int indexInParentCollection;

    public RemoveCollectionItemJob(FXOMObject value, EditorController editorController) {
        super(editorController);
        this.targetValue = value;
    }

    @Override
    public boolean isExecutable() {
        return this.targetValue.getParentCollection() != null;
    }

    @Override
    public void execute() {
        assert (this.parentCollection == null);
        assert (this.isExecutable());
        this.parentCollection = this.targetValue.getParentCollection();
        this.indexInParentCollection = this.targetValue.getIndexInParentCollection();
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.targetValue.getParentCollection() == null);
        this.getEditorController().getFxomDocument().beginUpdate();
        this.targetValue.addToParentCollection(this.indexInParentCollection, this.parentCollection);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetValue.getParentCollection() == this.parentCollection);
        assert (this.targetValue.getIndexInParentCollection() == this.indexInParentCollection);
    }

    @Override
    public void redo() {
        assert (this.targetValue.getParentCollection() == this.parentCollection);
        assert (this.targetValue.getIndexInParentCollection() == this.indexInParentCollection);
        this.getEditorController().getFxomDocument().beginUpdate();
        this.targetValue.removeFromParentCollection();
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetValue.getParentCollection() == null);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "[" + this.targetValue.getGlueElement().getTagName() + "]";
    }
}

