/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ToggleFxRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMFxIdIndex;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;

public class TrimSelectionJob
extends BatchSelectionJob {
    public TrimSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.canTrim()) {
            Selection selection = this.getEditorController().getSelection();
            assert (selection.getGroup() instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            assert (osg.getItems().size() == 1);
            FXOMObject oldRoot = this.getEditorController().getFxomDocument().getFxomRoot();
            FXOMObject candidateRoot = osg.getItems().iterator().next();
            assert (oldRoot instanceof FXOMInstance);
            boolean isFxRoot = ((FXOMInstance)oldRoot).isFxRoot();
            String fxController = oldRoot.getFxController();
            if (isFxRoot) {
                ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                result.add(fxRootJob);
            }
            if (fxController != null) {
                ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(oldRoot, null, this.getEditorController());
                result.add(fxControllerJob);
            }
            RemoveObjectJob deleteNewRoot = new RemoveObjectJob(candidateRoot, this.getEditorController());
            result.add(deleteNewRoot);
            SetDocumentRootJob setDocumentRoot = new SetDocumentRootJob(candidateRoot, this.getEditorController());
            result.add(setDocumentRoot);
            if (isFxRoot) {
                ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                result.add(fxRootJob);
            }
            if (fxController != null) {
                ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(candidateRoot, fxController, this.getEditorController());
                result.add(fxControllerJob);
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("label.action.edit.trim");
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        return this.getOldSelectionGroup();
    }

    private boolean canTrim() {
        FXOMDocument fxomDocument;
        FXOMObject fxomObject;
        ObjectSelectionGroup osg;
        Selection selection = this.getEditorController().getSelection();
        boolean result = selection.getGroup() instanceof ObjectSelectionGroup ? ((osg = (ObjectSelectionGroup)selection.getGroup()).getItems().size() == 1 ? ((fxomObject = osg.getItems().iterator().next()) instanceof FXOMInstance ? fxomObject != (fxomDocument = fxomObject.getFxomDocument()).getFxomRoot() && FXOMFxIdIndex.isSelfContainedObject(fxomObject) : false) : false) : false;
        return result;
    }
}

