/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class IncludeFileJob
extends BatchSelectionJob {
    private final File file;
    private FXOMObject targetObject;
    private FXOMIntrinsic newInclude;

    public IncludeFileJob(File file, EditorController editorController) {
        super(editorController);
        assert (file != null);
        this.file = file;
    }

    public FXOMObject getTargetObject() {
        return this.targetObject;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        try {
            FXOMDocument targetDocument = this.getEditorController().getFxomDocument();
            URL documentURL = this.getEditorController().getFxmlLocation();
            URL fileURL = this.file.toURI().toURL();
            if (documentURL != null && !URLUtils.equals(documentURL, fileURL)) {
                FXOMObject rootObject;
                this.newInclude = FXOMNodes.newInclude(targetDocument, this.file);
                if (this.newInclude != null && (rootObject = targetDocument.getFxomRoot()) != null) {
                    Selection selection = this.getEditorController().getSelection();
                    this.targetObject = selection.isEmpty() || selection.isSelected(rootObject) ? rootObject : selection.getAncestor();
                    DesignHierarchyMask targetMask = new DesignHierarchyMask(this.targetObject);
                    if (targetMask.isAcceptingSubComponent(this.newInclude)) {
                        result.add(new InsertAsSubComponentJob(this.newInclude, this.targetObject, targetMask.getSubComponentCount(), this.getEditorController()));
                    }
                }
            }
        }
        catch (IOException ex) {
            result.clear();
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("include.file", this.file.getName());
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        ArrayList<FXOMObject> fxomObjects = new ArrayList<FXOMObject>();
        fxomObjects.add(this.newInclude);
        return new ObjectSelectionGroup(fxomObjects, this.newInclude, null);
    }
}

