/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.drag.source;

import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

class DragSourceShadow
extends Group {
    private final ImageView imageView = new ImageView();
    private final Region glass = new Region();
    private static final String NID_DRAG_SHADOW = "dragShadow";

    public DragSourceShadow() {
        this.setId(NID_DRAG_SHADOW);
        this.getChildren().add((Object)this.imageView);
        this.getChildren().add((Object)this.glass);
        this.getStyleClass().add((Object)"drag-shadow");
        this.glass.getStyleClass().add((Object)"drag-shadow-glass");
    }

    public void setupForNode(Node node) {
        assert (node != null);
        assert (node.getScene() != null);
        SnapshotParameters sp = new SnapshotParameters();
        Transform l2p = node.getLocalToParentTransform();
        try {
            sp.setTransform(l2p.createInverse());
        }
        catch (NonInvertibleTransformException x) {
            throw new RuntimeException(x);
        }
        Bounds vp = node.getLayoutBounds();
        if (vp.getWidth() >= 0.0 && vp.getHeight() >= 0.0) {
            sp.setViewport(new Rectangle2D(vp.getMinX(), vp.getMinY(), vp.getWidth(), vp.getHeight()));
        }
        this.imageView.setImage((Image)node.snapshot(sp, null));
        Bounds inputBounds = vp;
        this.imageView.setLayoutX(inputBounds.getMinX());
        this.imageView.setLayoutY(inputBounds.getMinY());
        this.glass.setLayoutX(inputBounds.getMinX());
        this.glass.setLayoutY(inputBounds.getMinY());
        this.glass.setPrefWidth(inputBounds.getWidth());
        this.glass.setPrefHeight(inputBounds.getHeight());
        Bounds outputBounds = this.getLayoutBounds();
        assert (MathUtils.equals(inputBounds.getMinX(), outputBounds.getMinX())) : "inputBounds=" + inputBounds + ", outputBounds=" + outputBounds;
        assert (MathUtils.equals(inputBounds.getMinY(), outputBounds.getMinY())) : "inputBounds=" + inputBounds + ", outputBounds=" + outputBounds;
        assert (MathUtils.equals(inputBounds.getWidth(), outputBounds.getWidth(), 5.0)) : "inputBounds=" + inputBounds + ", outputBounds=" + outputBounds;
        assert (MathUtils.equals(inputBounds.getHeight(), outputBounds.getHeight(), 5.0)) : "inputBounds=" + inputBounds + ", outputBounds=" + outputBounds;
    }
}

