/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/AutolinkParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "typesAfterLT", "", "Lorg/intellij/markdown/IElementType;", "(Ljava/util/List;)V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;"})
public final class AutolinkParser
implements SequentialParser {
    private final List<IElementType> typesAfterLT;

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull Collection<IntRange> rangesToGlue) {
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        Intrinsics.checkParameterIsNotNull(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result = new SequentialParser.ParsingResultBuilder();
        ArrayList<Integer> delegateIndices = new ArrayList<Integer>();
        List<Integer> indices = SequentialParserUtil.Companion.textRangesToIndices(rangesToGlue);
        for (int i = 0; i < indices.size(); ++i) {
            TokensCache.Iterator iterator = tokens.new TokensCache.ListIterator(indices, i);
            if (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.LT)) {
                IElementType iElementType = iterator.rawLookup(1);
                IElementType it = iElementType;
                if (it != null && this.typesAfterLT.contains(it)) {
                    int start = i;
                    while (Intrinsics.areEqual((Object)iterator.getType(), (Object)MarkdownTokenTypes.GT) ^ true && iterator.getType() != null) {
                        iterator = iterator.advance();
                        ++i;
                    }
                    if (iterator.getType() == null) {
                        --i;
                    }
                    result.withNode(new SequentialParser.Node(new IntRange(((Number)indices.get(start)).intValue(), ((Number)indices.get(i)).intValue() + 1), MarkdownElementTypes.AUTOLINK));
                    continue;
                }
            }
            delegateIndices.add(indices.get(i));
        }
        return result.withFurtherProcessing(SequentialParserUtil.Companion.indicesToTextRanges((List<Integer>)delegateIndices));
    }

    public AutolinkParser(@NotNull List<? extends IElementType> typesAfterLT) {
        Intrinsics.checkParameterIsNotNull(typesAfterLT, (String)"typesAfterLT");
        this.typesAfterLT = typesAfterLT;
    }
}

