/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Locale;

public class AppMain {
    private static final String PROPERTY_PORT_NUMBER = "idea.launcher.port";
    private static final String PROPERTY_BIN_PATH = "idea.launcher.bin.path";
    private static final String JAVAFX_LAUNCHER = "com.sun.javafx.application.LauncherImpl";
    private static final String LAUNCH_APPLICATION_METHOD_NAME = "launchApplication";
    private static boolean ourHasSecurityProblem = false;

    private static native void triggerControlBreak();

    public static void main(String[] args) throws Throwable {
        Method m;
        if (!ourHasSecurityProblem) {
            final int portNumber = Integer.getInteger(PROPERTY_PORT_NUMBER);
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        ServerSocket socket = new ServerSocket(portNumber);
                        try {
                            Socket client = socket.accept();
                            try {
                                BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                                try {
                                    while (true) {
                                        String msg;
                                        if ("TERM".equals(msg = reader.readLine())) {
                                            return;
                                        }
                                        if ("BREAK".equals(msg)) {
                                            AppMain.triggerControlBreak();
                                            continue;
                                        }
                                        if (!"STOP".equals(msg)) continue;
                                        System.exit(1);
                                    }
                                }
                                finally {
                                    reader.close();
                                }
                            }
                            finally {
                                client.close();
                            }
                        }
                        finally {
                            socket.close();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }, "Monitor Ctrl-Break");
            try {
                t.setDaemon(true);
                t.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String mainClass = args[0];
        String[] params = new String[args.length - 1];
        System.arraycopy(args, 1, params, 0, args.length - 1);
        Class<?> appClass = Class.forName(mainClass);
        try {
            m = appClass.getMethod("main", params.getClass());
        }
        catch (NoSuchMethodException e) {
            if (!AppMain.startJavaFXApplication(params, appClass)) {
                throw e;
            }
            return;
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            System.err.println("main method should be static");
            return;
        }
        if (!Void.TYPE.isAssignableFrom(m.getReturnType())) {
            System.err.println("main method must return a value of type void");
            return;
        }
        try {
            ((AccessibleObject)m).setAccessible(true);
            m.invoke(null, new Object[]{params});
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static boolean startJavaFXApplication(String[] params, Class appClass) throws NoSuchMethodException {
        try {
            Class[] types = new Class[]{appClass.getClass(), params.getClass()};
            Method launchApplication = Class.forName(JAVAFX_LAUNCHER).getMethod(LAUNCH_APPLICATION_METHOD_NAME, types);
            launchApplication.invoke(null, appClass, params);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static {
        try {
            String binPath = System.getProperty(PROPERTY_BIN_PATH) + File.separator;
            String osName = System.getProperty("os.name").toLowerCase(Locale.US);
            String arch = System.getProperty("os.arch").toLowerCase(Locale.US);
            String libPath = null;
            if (osName.startsWith("windows")) {
                libPath = binPath + (arch.equals("amd64") ? "breakgen64.dll" : "breakgen.dll");
            } else if (osName.startsWith("linux")) {
                libPath = binPath + (arch.equals("amd64") ? "libbreakgen64.so" : "libbreakgen.so");
            } else if (osName.startsWith("mac")) {
                libPath = binPath + (arch.endsWith("64") ? "libbreakgen64.jnilib" : "libbreakgen.jnilib");
            }
            if (libPath != null) {
                System.load(libPath);
            }
        }
        catch (UnsatisfiedLinkError binPath) {
        }
        catch (SecurityException e) {
            ourHasSecurityProblem = true;
            System.out.println("break in console is not supported due to security permissions: " + e.getMessage());
        }
    }
}

