/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashMap;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.ExternalOptionHelper;
import com.maddyhome.idea.copyright.ui.CopyrightConfigurable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyrightProfilesPanel
extends MasterDetailsComponent
implements SearchableConfigurable {
    private final Project myProject;
    private final CopyrightManager myManager;
    private final AtomicBoolean myInitialized = new AtomicBoolean(false);
    private Runnable myUpdate;

    public CopyrightProfilesPanel(Project project) {
        this.myProject = project;
        this.myManager = CopyrightManager.getInstance(project);
        this.initTree();
    }

    public void setUpdate(Runnable update) {
        this.myUpdate = update;
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    protected String getComponentStateKey() {
        return "Copyright.UI";
    }

    protected void processRemovedItems() {
        Map<String, CopyrightProfile> profiles = this.getAllProfiles();
        for (CopyrightProfile profile : new ArrayList<CopyrightProfile>(this.myManager.getCopyrights())) {
            if (profiles.containsValue((Object)profile)) continue;
            this.myManager.removeCopyright(profile);
        }
    }

    protected boolean wasObjectStored(Object o) {
        return this.myManager.getCopyrights().contains((Object)((CopyrightProfile)((Object)o)));
    }

    @Nls
    public String getDisplayName() {
        return "Copyright Profiles";
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        if ("copyright.profiles" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel", "getHelpTopic"));
        }
        return "copyright.profiles";
    }

    protected void reloadAvailableProfiles() {
        if (this.myUpdate != null) {
            this.myUpdate.run();
        }
    }

    public void apply() throws ConfigurationException {
        HashSet<String> profiles = new HashSet<String>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            String profileName = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject().getName();
            if (profiles.contains(profileName)) {
                this.selectNodeInTree(profileName);
                throw new ConfigurationException("Duplicate copyright profile name: '" + profileName + "'");
            }
            profiles.add(profileName);
        }
        super.apply();
    }

    public Map<String, CopyrightProfile> getAllProfiles() {
        HashMap profiles = new HashMap();
        if (!this.myInitialized.get()) {
            for (CopyrightProfile profile : this.myManager.getCopyrights()) {
                profiles.put(profile.getName(), profile);
            }
        } else {
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
                CopyrightProfile copyrightProfile = ((CopyrightConfigurable)node.getConfigurable()).getEditableObject();
                profiles.put(copyrightProfile.getName(), copyrightProfile);
            }
        }
        return profiles;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myInitialized.set(false);
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        result.add((AnAction)new DumbAwareAction("Add", "Add", IconUtil.getAddIcon()){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)CopyrightProfilesPanel.this.myTree);
            }

            public void actionPerformed(AnActionEvent event) {
                String name = CopyrightProfilesPanel.this.askForProfileName("Create Copyright Profile", "");
                if (name != null) {
                    CopyrightProfilesPanel.this.addProfileNode(new CopyrightProfile(name));
                }
            }
        });
        result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        result.add((AnAction)new DumbAwareAction("Copy", "Copy", PlatformIcons.COPY_ICON){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 2)), (JComponent)CopyrightProfilesPanel.this.myTree);
            }

            public void actionPerformed(AnActionEvent event) {
                String profileName = CopyrightProfilesPanel.this.askForProfileName("Copy Copyright Profile", "");
                if (profileName == null) {
                    return;
                }
                CopyrightProfile clone = new CopyrightProfile();
                clone.copyFrom((CopyrightProfile)((Object)CopyrightProfilesPanel.this.getSelectedObject()));
                clone.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(clone);
            }

            public void update(AnActionEvent event) {
                super.update(event);
                event.getPresentation().setEnabled(CopyrightProfilesPanel.this.getSelectedObject() != null);
            }
        });
        result.add((AnAction)new DumbAwareAction("Import", "Import", PlatformIcons.IMPORT_ICON){

            public void actionPerformed(AnActionEvent event) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> {
                    FileType fileType = file.getFileType();
                    return fileType != PlainTextFileType.INSTANCE && (fileType == StdFileTypes.IDEA_MODULE || fileType == StdFileTypes.XML);
                }).withTitle("Choose File Containing Copyright Notice");
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)CopyrightProfilesPanel.this.myProject, null, file -> {
                    List<CopyrightProfile> profiles = ExternalOptionHelper.loadOptions(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                    if (profiles == null) {
                        return;
                    }
                    if (!profiles.isEmpty()) {
                        if (profiles.size() == 1) {
                            this.importProfile(profiles.get(0));
                        } else {
                            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<CopyrightProfile>("Choose profile to import", profiles){

                                public PopupStep onChosen(CopyrightProfile selectedValue, boolean finalChoice) {
                                    return this.doFinalStep(() -> this.importProfile(selectedValue));
                                }

                                @NotNull
                                public String getTextFor(CopyrightProfile value) {
                                    String string = value.getName();
                                    if (string == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel$3$1", "getTextFor"));
                                    }
                                    return string;
                                }
                            }).showUnderneathOf((Component)CopyrightProfilesPanel.this.myNorthPanel);
                        }
                    } else {
                        Messages.showWarningDialog((Project)CopyrightProfilesPanel.this.myProject, (String)"The selected file does not contain any copyright settings.", (String)"Import Failure");
                    }
                });
            }

            private void importProfile(CopyrightProfile copyrightProfile) {
                String profileName = CopyrightProfilesPanel.this.askForProfileName("Import copyright profile", copyrightProfile.getName());
                if (profileName == null) {
                    return;
                }
                copyrightProfile.setName(profileName);
                CopyrightProfilesPanel.this.addProfileNode(copyrightProfile);
                Messages.showInfoMessage((Project)CopyrightProfilesPanel.this.myProject, (String)"The copyright settings have been successfully imported.", (String)"Import Complete");
            }
        });
        return result;
    }

    @Nullable
    private String askForProfileName(String title, String initialName) {
        return Messages.showInputDialog((String)"New copyright profile name:", (String)title, (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)new InputValidator(){

            public boolean checkInput(String s) {
                return !CopyrightProfilesPanel.this.getAllProfiles().containsKey(s) && s.length() > 0;
            }

            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    private void addProfileNode(@NotNull CopyrightProfile copyrightProfile) {
        if (copyrightProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyrightProfile", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel", "addProfileNode"));
        }
        CopyrightConfigurable copyrightConfigurable = new CopyrightConfigurable(this.myProject, copyrightProfile, this.TREE_UPDATER);
        copyrightConfigurable.setModified(true);
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)copyrightConfigurable);
        this.addNode(node, this.myRoot);
        this.selectNodeInTree((DefaultMutableTreeNode)node);
        this.reloadAvailableProfiles();
    }

    protected void removePaths(TreePath ... paths) {
        super.removePaths(paths);
        this.reloadAvailableProfiles();
    }

    private void reloadTree() {
        this.myRoot.removeAllChildren();
        Collection<CopyrightProfile> collection = this.myManager.getCopyrights();
        for (CopyrightProfile profile : collection) {
            CopyrightProfile clone = new CopyrightProfile();
            clone.copyFrom(profile);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new CopyrightConfigurable(this.myProject, clone, this.TREE_UPDATER)), this.myRoot);
        }
        this.myInitialized.set(true);
    }

    public void reset() {
        this.reloadTree();
        super.reset();
    }

    protected String getEmptySelectionString() {
        return "Select a profile to view or edit its details here";
    }

    public void addItemsChangeListener(final Runnable runnable) {
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object deletedItem) {
                SwingUtilities.invokeLater(runnable);
            }

            public void itemsExternallyChanged() {
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/maddyhome/idea/copyright/ui/CopyrightProfilesPanel", "getId"));
        }
        return string;
    }
}

