/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataGroupVirtualFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataLineMarkerProvider;
import org.jetbrains.idea.devkit.testAssistant.TestDataReferenceCollector;

public class TestDataNavigationHandler
implements GutterIconNavigationHandler<PsiMethod> {
    public void navigate(MouseEvent e, PsiMethod elt) {
        List<String> fileNames = TestDataNavigationHandler.getFileNames(elt);
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        TestDataNavigationHandler.navigate(new RelativePoint(e), fileNames, elt.getProject());
    }

    @Nullable
    static List<String> getFileNames(PsiMethod method) {
        List<String> fileNames = null;
        String testDataPath = TestDataLineMarkerProvider.getTestDataBasePath(method.getContainingClass());
        if (testDataPath != null) {
            fileNames = new TestDataReferenceCollector(testDataPath, method.getName().substring(4)).collectTestDataReferences(method);
        }
        if (fileNames == null || fileNames.isEmpty()) {
            fileNames = TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method);
        }
        return fileNames;
    }

    public static void navigate(@NotNull RelativePoint point, @NotNull List<String> testDataFiles, Project project) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler", "navigate"));
        }
        if (testDataFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDataFiles", "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler", "navigate"));
        }
        if (testDataFiles.size() == 1) {
            TestDataNavigationHandler.openFileByIndex(project, testDataFiles, 0);
        } else if (testDataFiles.size() > 1) {
            TestDataGroupVirtualFile groupFile = TestDataNavigationHandler.getTestDataGroup(testDataFiles);
            if (groupFile != null) {
                new OpenFileDescriptor(project, (VirtualFile)groupFile).navigate(true);
            } else {
                TestDataNavigationHandler.showNavigationPopup(project, testDataFiles, point);
            }
        }
    }

    @Nullable
    private static TestDataGroupVirtualFile getTestDataGroup(List<String> fileNames) {
        if (fileNames.size() != 2) {
            return null;
        }
        VirtualFile file1 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fileNames.get(0));
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fileNames.get(1));
        if (file1 == null || file2 == null) {
            return null;
        }
        int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)file1.getName(), (CharSequence)file2.getName());
        if (file1.getName().substring(commonPrefixLength).toLowerCase().contains("after")) {
            return new TestDataGroupVirtualFile(file2, file1);
        }
        if (file2.getName().substring(commonPrefixLength).toLowerCase().contains("after")) {
            return new TestDataGroupVirtualFile(file1, file2);
        }
        return null;
    }

    private static void showNavigationPopup(Project project, List<String> fileNames, RelativePoint point) {
        ArrayList<String> listPaths = new ArrayList<String>(fileNames);
        String CREATE_MISSING_OPTION = "Create Missing Files";
        if (fileNames.size() == 2) {
            VirtualFile file1 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fileNames.get(0));
            VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fileNames.get(1));
            if (file1 == null || file2 == null) {
                listPaths.add("Create Missing Files");
            }
        }
        JBList list = new JBList((Object[])ArrayUtil.toStringArray(listPaths));
        list.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationHandler$1", "customizeCellRenderer"));
                }
                String path = (String)value;
                String fileName = PathUtil.getFileName((String)path);
                if (!fileName.equals("Create Missing Files")) {
                    FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
                    this.setIcon(fileType.getIcon());
                }
                this.append(String.format("%s (%s)", fileName, PathUtil.getParentPath((String)path)));
            }
        });
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        builder.setItemChoosenCallback(() -> TestDataNavigationHandler.lambda$showNavigationPopup$0((JList)list, fileNames, project)).createPopup().show(point);
    }

    private static void createMissingFiles(Project project, List<String> fileNames) {
        for (String name : fileNames) {
            if (LocalFileSystem.getInstance().refreshAndFindFileByPath(name) != null) continue;
            TestDataNavigationHandler.createFileByName(project, name);
        }
        TestDataGroupVirtualFile testDataGroup = TestDataNavigationHandler.getTestDataGroup(fileNames);
        if (testDataGroup != null) {
            new OpenFileDescriptor(project, (VirtualFile)testDataGroup).navigate(true);
        }
    }

    private static void openFileByIndex(Project project, List<String> fileNames, int index) {
        String path = fileNames.get(index);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (file != null) {
            new OpenFileDescriptor(project, file).navigate(true);
        } else {
            int rc = Messages.showYesNoDialog((Project)project, (String)("The referenced testdata file " + path + " does not exist. Would you like to create it?"), (String)"Create Testdata File", (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                VirtualFile vFile = TestDataNavigationHandler.createFileByName(project, path);
                new OpenFileDescriptor(project, vFile).navigate(true);
            }
        }
    }

    private static VirtualFile createFileByName(final Project project, final String path) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    File file = new File(path);
                    VirtualFile parent = VfsUtil.createDirectories((String)file.getParent());
                    return parent.createChildData((Object)this, file.getName());
                }
                catch (IOException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Create Testdata File");
                    return null;
                }
            }
        });
    }

    private static /* synthetic */ void lambda$showNavigationPopup$0(JList list, List fileNames, Project project) {
        int[] indices = list.getSelectedIndices();
        if (ArrayUtil.indexOf((int[])indices, (int)fileNames.size()) >= 0) {
            TestDataNavigationHandler.createMissingFiles(project, fileNames);
        } else {
            for (int index : indices) {
                TestDataNavigationHandler.openFileByIndex(project, fileNames, index);
            }
        }
    }
}

