/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.ITabbedPane;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.properties.BorderProperty;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class StringDescriptorInspection
extends BaseFormInspection {
    private static final NotNullLazyValue<BorderProperty> myBorderProperty = new NotNullLazyValue<BorderProperty>(){

        @NotNull
        protected BorderProperty compute() {
            BorderProperty borderProperty = new BorderProperty(null);
            if (borderProperty == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/StringDescriptorInspection$1", "compute"));
            }
            return borderProperty;
        }
    };

    public StringDescriptorInspection(@NonNls String inspectionKey) {
        super(inspectionKey);
    }

    @Override
    protected void checkComponentProperties(Module module, IComponent component, FormErrorCollector collector) {
        IContainer container;
        StringDescriptor descriptor;
        for (IProperty prop : component.getModifiedProperties()) {
            Object propValue = prop.getPropertyValue(component);
            if (!(propValue instanceof StringDescriptor)) continue;
            StringDescriptor descriptor2 = (StringDescriptor)propValue;
            this.checkStringDescriptor(module, component, prop, descriptor2, collector);
        }
        if (component instanceof IContainer && (descriptor = (container = (IContainer)component).getBorderTitle()) != null) {
            this.checkStringDescriptor(module, component, (IProperty)myBorderProperty.getValue(), descriptor, collector);
        }
        if (component.getParentContainer() instanceof ITabbedPane) {
            ITabbedPane parentTabbedPane = (ITabbedPane)component.getParentContainer();
            descriptor = parentTabbedPane.getTabProperty(component, "Tab Title");
            if (descriptor != null) {
                this.checkStringDescriptor(module, component, MockTabTitleProperty.INSTANCE, descriptor, collector);
            }
            if ((descriptor = parentTabbedPane.getTabProperty(component, "Tab Tooltip")) != null) {
                this.checkStringDescriptor(module, component, MockTabToolTipProperty.INSTANCE, descriptor, collector);
            }
        }
    }

    protected abstract void checkStringDescriptor(Module var1, IComponent var2, IProperty var3, StringDescriptor var4, FormErrorCollector var5);

    private static class MockTabToolTipProperty
    implements IProperty {
        public static MockTabToolTipProperty INSTANCE = new MockTabToolTipProperty();

        private MockTabToolTipProperty() {
        }

        public String getName() {
            return "Tab Tooltip";
        }

        public Object getPropertyValue(IComponent component) {
            return null;
        }
    }

    private static class MockTabTitleProperty
    implements IProperty {
        public static MockTabTitleProperty INSTANCE = new MockTabTitleProperty();

        private MockTabTitleProperty() {
        }

        public String getName() {
            return "Tab Title";
        }

        public Object getPropertyValue(IComponent component) {
            return null;
        }
    }
}

