/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.designSurface.CachedGridImage;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadNestedForm;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.shared.BorderType;
import com.intellij.util.ui.PlatformColors;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public final class Painter {
    private static final Color NON_SELECTED_BOUNDARY_COLOR = new Color(114, 126, 143);
    private static final Color SELECTED_BOUNDARY_COLOR = new Color(8, 8, 108);
    private static final Color HIGHLIGHTED_BOUNDARY_COLOR = Color.RED;
    static final Color SELECTED_GRID_COLOR = new Color(47, 67, 96);
    static final Color NON_SELECTED_GRID_COLOR = new Color(130, 140, 155);
    public static final int WEST_MASK = 1;
    public static final int EAST_MASK = 2;
    public static final int NORTH_MASK = 4;
    public static final int SOUTH_MASK = 8;
    private static final int R = 2;
    private static final int GAP = 2;
    private static final int NW = 0;
    private static final int N = 1;
    private static final int NE = 2;
    private static final int E = 3;
    private static final int SE = 4;
    private static final int S = 5;
    private static final int SW = 6;
    private static final int W = 7;

    private Painter() {
    }

    public static void paintComponentDecoration(final GuiEditor editor, RadComponent component, final Graphics g) {
        final ArrayList selection = new ArrayList();
        final Rectangle layeredPaneRect = editor.getLayeredPane().getVisibleRect();
        FormEditingUtil.iterate(component, new FormEditingUtil.ComponentVisitor<RadComponent>(){

            @Override
            public boolean visit(RadComponent component) {
                if (!component.getDelegee().isShowing()) {
                    return true;
                }
                Shape oldClip = g.getClip();
                RadContainer parent = component.getParent();
                if (parent != null) {
                    Point p = SwingUtilities.convertPoint(component.getDelegee(), 0, 0, editor.getLayeredPane());
                    Rectangle visibleRect = layeredPaneRect.intersection(new Rectangle(p.x, p.y, parent.getWidth(), parent.getHeight()));
                    g.setClip(visibleRect);
                }
                if (component.isSelected()) {
                    selection.add(component);
                } else {
                    Painter.paintComponentBoundsImpl(editor, component, g);
                }
                Painter.paintGridOutline(editor, component, g);
                if (parent != null) {
                    g.setClip(oldClip);
                }
                return true;
            }
        });
        for (int i = selection.size() - 1; i >= 0; --i) {
            Shape oldClip = g.getClip();
            RadComponent c = (RadComponent)selection.get(i);
            RadContainer parent = c.getParent();
            if (parent != null) {
                Point p = SwingUtilities.convertPoint(c.getDelegee(), 0, 0, editor.getLayeredPane());
                Rectangle visibleRect = layeredPaneRect.intersection(new Rectangle(p.x, p.y, parent.getWidth(), parent.getHeight()));
                g.setClip(visibleRect);
            }
            Painter.paintComponentBoundsImpl(editor, c, g);
            if (parent == null) continue;
            g.setClip(oldClip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintComponentBoundsImpl(GuiEditor editor, @NotNull RadComponent component, Graphics g) {
        boolean highlightBoundaries;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/designSurface/Painter", "paintComponentBoundsImpl"));
        }
        if (!(component instanceof RadContainer || component instanceof RadNestedForm || component.isDragBorder())) {
            return;
        }
        boolean bl = highlightBoundaries = Painter.getDesignTimeInsets(component) > 2;
        if (component instanceof RadContainer && !component.isDragBorder()) {
            RadContainer container = (RadContainer)component;
            if (!(highlightBoundaries || container.getBorderTitle() == null && container.getBorderType() == BorderType.NONE)) {
                return;
            }
        }
        Point point = SwingUtilities.convertPoint(component.getDelegee(), 0, 0, editor.getRootContainer().getDelegee());
        g.translate(point.x, point.y);
        try {
            if (component.isDragBorder()) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(LightColors.YELLOW);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.translate(1, 1);
            } else if (highlightBoundaries) {
                g.setColor(HIGHLIGHTED_BOUNDARY_COLOR);
            } else if (component.isSelected()) {
                g.setColor(SELECTED_BOUNDARY_COLOR);
            } else {
                g.setColor(NON_SELECTED_BOUNDARY_COLOR);
            }
            g.drawRect(0, 0, component.getWidth() - 1, component.getHeight() - 1);
            if (component.isDragBorder()) {
                g.translate(-1, -1);
            }
        }
        finally {
            g.translate(-point.x, -point.y);
        }
    }

    private static int getDesignTimeInsets(RadComponent component) {
        while (component != null) {
            Integer designTimeInsets = (Integer)component.getDelegee().getClientProperty(GridLayoutManager.DESIGN_TIME_INSETS);
            if (designTimeInsets != null) {
                return designTimeInsets;
            }
            component = component.getParent();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintGridOutline(GuiEditor editor, @NotNull RadComponent component, Graphics g) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/designSurface/Painter", "paintGridOutline"));
        }
        if (!editor.isShowGrid()) {
            return;
        }
        if (!(component instanceof RadContainer)) {
            return;
        }
        RadContainer container = (RadContainer)component;
        if (!container.getLayoutManager().isGrid()) {
            return;
        }
        for (Container parent = component.getDelegee().getParent(); parent != null; parent = parent.getParent()) {
            if (parent != editor.getDragLayer()) continue;
            return;
        }
        Point point = SwingUtilities.convertPoint(component.getDelegee(), 0, 0, editor.getRootContainer().getDelegee());
        g.translate(point.x, point.y);
        try {
            if (container.getWidth() > 0 && container.getHeight() > 0) {
                Image gridImage = CachedGridImage.getGridImage(container);
                g.drawImage(gridImage, 0, 0, null);
            }
        }
        finally {
            g.translate(-point.x, -point.y);
        }
    }

    public static void paintSelectionDecoration(@NotNull RadComponent component, Graphics g, boolean focused) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/designSurface/Painter", "paintSelectionDecoration"));
        }
        if (component.isSelected()) {
            Point[] points;
            if (focused) {
                g.setColor(PlatformColors.BLUE);
            } else {
                g.setColor(Color.GRAY);
            }
            for (Point point : points = Painter.getPoints(component.getWidth(), component.getHeight())) {
                g.fillRect(point.x - 2, point.y - 2, 5, 5);
            }
        } else if (component.getWidth() < 5 || component.getHeight() < 5) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            Stroke oldStroke = g2d.getStroke();
            Color oldColor = g2d.getColor();
            g2d.setComposite(AlphaComposite.getInstance(10, 0.5f));
            g2d.setStroke(new BasicStroke(0.7f));
            g2d.setColor(Color.black);
            g2d.drawRect(0, 0, Math.max(component.getWidth(), 5), Math.max(component.getHeight(), 5));
            g2d.setComposite(oldComposite);
            g2d.setStroke(oldStroke);
            g2d.setColor(oldColor);
        }
    }

    public static int getResizeMask(@NotNull RadComponent component, int x, int y) {
        int height;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/designSurface/Painter", "getResizeMask"));
        }
        if (component.getParent() == null || !component.isSelected()) {
            return 0;
        }
        int width = component.getWidth();
        Point[] points = Painter.getPoints(width, height = component.getHeight());
        if (Painter.isInside(x, y, points[4])) {
            return 10;
        }
        if (Painter.isInside(x, y, points[0])) {
            return 5;
        }
        if (Painter.isInside(x, y, points[1])) {
            return 4;
        }
        if (Painter.isInside(x, y, points[2])) {
            return 6;
        }
        if (Painter.isInside(x, y, points[7])) {
            return 1;
        }
        if (Painter.isInside(x, y, points[3])) {
            return 2;
        }
        if (Painter.isInside(x, y, points[6])) {
            return 9;
        }
        if (Painter.isInside(x, y, points[5])) {
            return 8;
        }
        return 0;
    }

    private static boolean isInside(int x, int y, Point r) {
        return x >= r.x - 2 && x <= r.x + 2 && y >= r.y - 2 && y <= r.y + 2;
    }

    @JdkConstants.CursorType
    public static int getResizeCursor(int resizeMask) {
        if (resizeMask == 5) {
            return 6;
        }
        if (resizeMask == 4) {
            return 8;
        }
        if (resizeMask == 6) {
            return 7;
        }
        if (resizeMask == 1) {
            return 10;
        }
        if (resizeMask == 2) {
            return 11;
        }
        if (resizeMask == 9) {
            return 4;
        }
        if (resizeMask == 8) {
            return 9;
        }
        if (resizeMask == 10) {
            return 5;
        }
        throw new IllegalArgumentException("unknown resizeMask: " + resizeMask);
    }

    public static Point[] getPoints(int width, int height) {
        Point[] points = new Point[]{new Point(2, 2), new Point(width / 2, 2), new Point(width - 2 - 1, 2), new Point(width - 2 - 1, height / 2), new Point(width - 2 - 1, height - 2 - 1), new Point(width / 2, height - 2 - 1), new Point(2, height - 2 - 1), new Point(2, height / 2)};
        return points;
    }

    public static void paintButtonGroupLines(RadRootContainer rootContainer, RadButtonGroup group, Graphics g) {
        List<RadComponent> components = rootContainer.getGroupContents(group);
        if (components.size() < 2) {
            return;
        }
        Rectangle[] allBounds = new Rectangle[components.size()];
        int lastTop = -1;
        int minLeft = Integer.MAX_VALUE;
        for (int i = 0; i < components.size(); ++i) {
            Rectangle rc;
            allBounds[i] = rc = SwingUtilities.convertRectangle(components.get(i).getParent().getDelegee(), components.get(i).getBounds(), rootContainer.getDelegee());
            minLeft = Math.min(minLeft, rc.x);
            if (i == 0) {
                lastTop = rc.y;
                continue;
            }
            if (lastTop == rc.y) continue;
            lastTop = Integer.MIN_VALUE;
        }
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(new Color(104, 107, 130));
        if (lastTop != Integer.MIN_VALUE) {
            int left = Integer.MAX_VALUE;
            int right = Integer.MIN_VALUE;
            for (Rectangle rc : allBounds) {
                int midX = (int)rc.getCenterX();
                left = Math.min(left, midX);
                right = Math.max(right, midX);
                g2d.drawLine(midX, lastTop - 8, midX, lastTop);
            }
            g2d.drawLine(left, lastTop - 8, right, lastTop - 8);
        } else {
            int top = Integer.MAX_VALUE;
            int bottom = Integer.MIN_VALUE;
            for (Rectangle rc : allBounds) {
                int midY = (int)rc.getCenterY();
                top = Math.min(top, midY);
                bottom = Math.max(bottom, midY);
                g2d.drawLine(minLeft - 8, midY, rc.x, midY);
            }
            g2d.drawLine(minLeft - 8, top, minLeft - 8, bottom);
        }
        g2d.setStroke(oldStroke);
    }

    public static void paintComponentTag(RadComponent component, Graphics g) {
        if (component instanceof RadContainer) {
            return;
        }
        for (IProperty prop : component.getModifiedProperties()) {
            Object value;
            Object desc;
            if (!(prop.getName().equals("text") ? !((desc = prop.getPropertyValue((IComponent)component)) instanceof StringDescriptor) || ((StringDescriptor)desc).getValue() == null || ((StringDescriptor)desc).getValue().length() > 0 : prop.getName().equals("model") && (value = prop.getPropertyValue((IComponent)component)) instanceof String[] && ((String[])value).length > 0)) continue;
            return;
        }
        Rectangle bounds = component.getDelegee().getBounds();
        if (bounds.width > 100 && bounds.height > 40) {
            String className;
            int pos;
            StringBuilder tagBuilder = new StringBuilder();
            if (component.getBinding() != null) {
                tagBuilder.append(component.getBinding()).append(':');
            }
            if ((pos = (className = component.getComponentClassName()).lastIndexOf(46)) >= 0) {
                tagBuilder.append(className.substring(pos + 1));
            } else {
                tagBuilder.append(className);
            }
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(tagBuilder.toString(), g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(PlatformColors.BLUE);
            g2d.fillRect(0, 0, (int)stringBounds.getWidth(), (int)stringBounds.getHeight());
            g2d.setColor((Color)JBColor.WHITE);
            UISettings.setupAntialiasing((Graphics)g);
            g.drawString(tagBuilder.toString(), 0, g.getFontMetrics().getAscent());
        }
    }
}

