/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.JpsCompilerExcludesImpl;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.model.java.impl.compiler.ResourcePatterns;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsJavaCompilerConfigurationImpl
extends JpsCompositeElementBase<JpsJavaCompilerConfigurationImpl>
implements JpsJavaCompilerConfiguration {
    public static final JpsElementChildRole<JpsJavaCompilerConfiguration> ROLE = JpsElementChildRoleBase.create((String)"compiler configuration");
    private boolean myAddNotNullAssertions = true;
    private List<String> myNotNullAnnotations = Collections.singletonList(NotNull.class.getName());
    private boolean myClearOutputDirectoryOnRebuild = true;
    private final JpsCompilerExcludes myCompilerExcludes = new JpsCompilerExcludesImpl();
    private final JpsCompilerExcludes myValidationExcludes = new JpsCompilerExcludesImpl();
    private final List<String> myResourcePatterns = new ArrayList<String>();
    private final List<ProcessorConfigProfile> myAnnotationProcessingProfiles = new ArrayList<ProcessorConfigProfile>();
    private final ProcessorConfigProfileImpl myDefaultAnnotationProcessingProfile = new ProcessorConfigProfileImpl("Default");
    private String myProjectByteCodeTargetLevel;
    private final Map<String, String> myModulesByteCodeTargetLevels = new HashMap<String, String>();
    private final Map<String, JpsJavaCompilerOptions> myCompilerOptions = new HashMap<String, JpsJavaCompilerOptions>();
    private String myJavaCompilerId = "Javac";
    private Map<JpsModule, ProcessorConfigProfile> myAnnotationProcessingProfileMap;
    private ResourcePatterns myCompiledPatterns;

    public JpsJavaCompilerConfigurationImpl() {
    }

    private JpsJavaCompilerConfigurationImpl(JpsJavaCompilerConfigurationImpl original) {
        super((JpsCompositeElementBase)original);
    }

    @NotNull
    public JpsJavaCompilerConfigurationImpl createCopy() {
        JpsJavaCompilerConfigurationImpl jpsJavaCompilerConfigurationImpl = new JpsJavaCompilerConfigurationImpl(this);
        if (jpsJavaCompilerConfigurationImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "createCopy"));
        }
        return jpsJavaCompilerConfigurationImpl;
    }

    public boolean isAddNotNullAssertions() {
        return this.myAddNotNullAssertions;
    }

    public List<String> getNotNullAnnotations() {
        return this.myNotNullAnnotations;
    }

    public boolean isClearOutputDirectoryOnRebuild() {
        return this.myClearOutputDirectoryOnRebuild;
    }

    public void setAddNotNullAssertions(boolean addNotNullAssertions) {
        this.myAddNotNullAssertions = addNotNullAssertions;
    }

    public void setNotNullAnnotations(List<String> notNullAnnotations) {
        this.myNotNullAnnotations = Collections.unmodifiableList(notNullAnnotations);
    }

    public void setClearOutputDirectoryOnRebuild(boolean clearOutputDirectoryOnRebuild) {
        this.myClearOutputDirectoryOnRebuild = clearOutputDirectoryOnRebuild;
    }

    @NotNull
    public JpsCompilerExcludes getCompilerExcludes() {
        JpsCompilerExcludes jpsCompilerExcludes = this.myCompilerExcludes;
        if (jpsCompilerExcludes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getCompilerExcludes"));
        }
        return jpsCompilerExcludes;
    }

    @NotNull
    public JpsCompilerExcludes getValidationExcludes() {
        JpsCompilerExcludes jpsCompilerExcludes = this.myValidationExcludes;
        if (jpsCompilerExcludes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getValidationExcludes"));
        }
        return jpsCompilerExcludes;
    }

    @NotNull
    public ProcessorConfigProfile getDefaultAnnotationProcessingProfile() {
        ProcessorConfigProfileImpl processorConfigProfileImpl = this.myDefaultAnnotationProcessingProfile;
        if (processorConfigProfileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getDefaultAnnotationProcessingProfile"));
        }
        return processorConfigProfileImpl;
    }

    @NotNull
    public Collection<ProcessorConfigProfile> getAnnotationProcessingProfiles() {
        List<ProcessorConfigProfile> list = this.myAnnotationProcessingProfiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getAnnotationProcessingProfiles"));
        }
        return list;
    }

    public void addResourcePattern(String pattern) {
        this.myResourcePatterns.add(pattern);
    }

    public List<String> getResourcePatterns() {
        return this.myResourcePatterns;
    }

    public boolean isResourceFile(@NotNull File file, @NotNull File srcRoot) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "isResourceFile"));
        }
        if (srcRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcRoot", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "isResourceFile"));
        }
        ResourcePatterns patterns = this.myCompiledPatterns;
        if (patterns == null) {
            this.myCompiledPatterns = patterns = new ResourcePatterns(this);
        }
        return patterns.isResourceFile(file, srcRoot);
    }

    @Nullable
    public String getByteCodeTargetLevel(String moduleName) {
        String level = this.myModulesByteCodeTargetLevels.get(moduleName);
        if (level != null) {
            return level.isEmpty() ? null : level;
        }
        return this.myProjectByteCodeTargetLevel;
    }

    public void setModuleByteCodeTargetLevel(String moduleName, String level) {
        this.myModulesByteCodeTargetLevels.put(moduleName, level);
    }

    @NotNull
    public String getJavaCompilerId() {
        String string = this.myJavaCompilerId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getJavaCompilerId"));
        }
        return string;
    }

    public void setJavaCompilerId(@NotNull String compiler) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "setJavaCompilerId"));
        }
        this.myJavaCompilerId = compiler;
    }

    @NotNull
    public JpsJavaCompilerOptions getCompilerOptions(@NotNull String compilerId) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getCompilerOptions"));
        }
        JpsJavaCompilerOptions options = this.myCompilerOptions.get(compilerId);
        if (options == null) {
            options = new JpsJavaCompilerOptions();
            this.myCompilerOptions.put(compilerId, options);
        }
        JpsJavaCompilerOptions jpsJavaCompilerOptions = options;
        if (jpsJavaCompilerOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getCompilerOptions"));
        }
        return jpsJavaCompilerOptions;
    }

    public void setCompilerOptions(@NotNull String compilerId, @NotNull JpsJavaCompilerOptions options) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "setCompilerOptions"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "setCompilerOptions"));
        }
        this.myCompilerOptions.put(compilerId, options);
    }

    @NotNull
    public JpsJavaCompilerOptions getCurrentCompilerOptions() {
        JpsJavaCompilerOptions jpsJavaCompilerOptions = this.getCompilerOptions(this.getJavaCompilerId());
        if (jpsJavaCompilerOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getCurrentCompilerOptions"));
        }
        return jpsJavaCompilerOptions;
    }

    public void setProjectByteCodeTargetLevel(String level) {
        this.myProjectByteCodeTargetLevel = level;
    }

    public ProcessorConfigProfile addAnnotationProcessingProfile() {
        ProcessorConfigProfileImpl profile = new ProcessorConfigProfileImpl("");
        this.myAnnotationProcessingProfiles.add(profile);
        return profile;
    }

    @NotNull
    public ProcessorConfigProfile getAnnotationProcessingProfile(JpsModule module) {
        ProcessorConfigProfile profile;
        Map<JpsModule, ProcessorConfigProfile> map = this.myAnnotationProcessingProfileMap;
        if (map == null) {
            map = new HashMap<JpsModule, ProcessorConfigProfile>();
            HashMap<String, JpsModule> namesMap = new HashMap<String, JpsModule>();
            for (JpsModule m : module.getProject().getModules()) {
                namesMap.put(m.getName(), m);
            }
            if (!namesMap.isEmpty()) {
                for (ProcessorConfigProfile profile2 : this.getAnnotationProcessingProfiles()) {
                    for (String name : profile2.getModuleNames()) {
                        JpsModule mod = (JpsModule)namesMap.get(name);
                        if (mod == null) continue;
                        map.put(mod, profile2);
                    }
                }
            }
            this.myAnnotationProcessingProfileMap = map;
        }
        ProcessorConfigProfile processorConfigProfile = (profile = map.get(module)) != null ? profile : this.getDefaultAnnotationProcessingProfile();
        if (processorConfigProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/compiler/JpsJavaCompilerConfigurationImpl", "getAnnotationProcessingProfile"));
        }
        return processorConfigProfile;
    }
}

