/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class MavenServerUtil {
    private static final Properties mySystemPropertiesCache;

    public static Properties collectSystemProperties() {
        return mySystemPropertiesCache;
    }

    @NotNull
    public static File findMavenBasedir(@NotNull File workingDir) {
        File file;
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "org/jetbrains/idea/maven/server/MavenServerUtil", "findMavenBasedir"));
        }
        File baseDir = workingDir;
        File dir = workingDir;
        while ((dir = dir.getParentFile()) != null) {
            if (!new File(dir, ".mvn").exists()) continue;
            baseDir = dir;
            break;
        }
        try {
            file = baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            File file2 = baseDir.getAbsoluteFile();
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerUtil", "findMavenBasedir"));
            }
            return file2;
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerUtil", "findMavenBasedir"));
        }
        return file;
    }

    private static boolean isMagicalProperty(String key) {
        return key.startsWith("=");
    }

    static {
        Properties res = new Properties();
        res.putAll((Map<?, ?>)((Properties)System.getProperties().clone()));
        Iterator<Object> itr = res.keySet().iterator();
        while (itr.hasNext()) {
            String propertyName = itr.next().toString();
            if (!propertyName.startsWith("idea.")) continue;
            itr.remove();
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (MavenServerUtil.isMagicalProperty(key)) continue;
            if (SystemInfo.isWindows) {
                key = key.toUpperCase();
            }
            res.setProperty("env." + key, entry.getValue());
        }
        mySystemPropertiesCache = res;
    }
}

