/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.output.EclipseJDOMUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.EclipseClasspathStorageProvider;
import org.jetbrains.idea.eclipse.conversion.DotProjectFileHelper;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathWriter;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;

final class ClasspathSaveSession
implements StateStorage.ExternalizationSession,
StateStorage.SaveSession,
SafeWriteRequestor {
    private final Map<String, Element> modifiedContent;
    private final Set<String> deletedContent;
    private final Module module;

    ClasspathSaveSession(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/ClasspathSaveSession", "<init>"));
        }
        this.modifiedContent = new THashMap();
        this.deletedContent = new THashSet();
        this.module = module;
    }

    private void update(@NotNull Element content, @NotNull String name) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/idea/eclipse/config/ClasspathSaveSession", "update"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/ClasspathSaveSession", "update"));
        }
        this.modifiedContent.put(name, content);
        this.deletedContent.remove(name);
    }

    void delete(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/eclipse/config/ClasspathSaveSession", "delete"));
        }
        this.modifiedContent.remove(name);
        this.deletedContent.add(name);
    }

    public void setState(Object component, @NotNull String componentName, @NotNull Object state) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "org/jetbrains/idea/eclipse/config/ClasspathSaveSession", "setState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/idea/eclipse/config/ClasspathSaveSession", "setState"));
        }
        try {
            Element oldClassPath;
            CachedXmlDocumentSet fileSet = EclipseClasspathStorageProvider.getFileCache(this.module);
            try {
                oldClassPath = fileSet.load(".classpath", true);
            }
            catch (Exception e) {
                EclipseClasspathWriter.LOG.warn((Throwable)e);
                oldClassPath = null;
            }
            ModuleRootManagerImpl moduleRootManager = (ModuleRootManagerImpl)component;
            if (oldClassPath != null || moduleRootManager.getSourceRoots().length > 0 || moduleRootManager.getOrderEntries().length > 2) {
                Element newClassPathElement = new EclipseClasspathWriter().writeClasspath(oldClassPath, (ModuleRootModel)moduleRootManager);
                if (oldClassPath == null || !JDOMUtil.areElementsEqual((Element)newClassPathElement, (Element)oldClassPath)) {
                    this.update(newClassPathElement, ".classpath");
                }
            }
            if (fileSet.getFile(".project", true) == null) {
                DotProjectFileHelper.saveDotProjectFile(this.module, fileSet.getParent(".project"));
            }
            Element ideaSpecific = new Element("component");
            String emlFilename = moduleRootManager.getModule().getName() + ".eml";
            if (IdeaSpecificSettings.writeIdeaSpecificClasspath(ideaSpecific, (ModuleRootModel)moduleRootManager)) {
                this.update(ideaSpecific, emlFilename);
            } else {
                this.delete(emlFilename);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public StateStorage.SaveSession createSaveSession() {
        return this.modifiedContent.isEmpty() && this.deletedContent.isEmpty() ? null : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        CachedXmlDocumentSet fileSet = EclipseClasspathStorageProvider.getFileCache(this.module);
        AccessToken token = WriteAction.start();
        try {
            for (String key : this.modifiedContent.keySet()) {
                Element content = this.modifiedContent.get(key);
                String path = fileSet.getParent(key) + '/' + key;
                try (OutputStreamWriter writer = new OutputStreamWriter(StorageUtil.getOrCreateVirtualFile((Object)this, (Path)Paths.get(path, new String[0])).getOutputStream((Object)this), CharsetToolkit.UTF8_CHARSET);){
                    EclipseJDOMUtil.output(content, writer, this.module.getProject());
                }
            }
            if (this.deletedContent.isEmpty()) {
                return;
            }
            for (String deleted : this.deletedContent) {
                VirtualFile file = fileSet.getFile(deleted, false);
                if (file == null) continue;
                try {
                    file.delete((Object)this);
                }
                catch (IOException iOException) {}
            }
            this.deletedContent.clear();
        }
        finally {
            token.finish();
        }
    }
}

