/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.google.common.collect.Lists;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.HyperlinkFilter;
import com.jediterm.terminal.model.TerminalLine;
import java.util.List;

public class TextProcessing {
    private final List<HyperlinkFilter> myHyperlinkFilter;
    private TextStyle myHyperlinkColor;

    public TextProcessing(TextStyle hyperlinkColor) {
        this.myHyperlinkColor = hyperlinkColor;
        this.myHyperlinkFilter = Lists.newArrayList();
    }

    public void processHyperlinks(TerminalLine line) {
        for (HyperlinkFilter filter : this.myHyperlinkFilter) {
            HyperlinkFilter.Result result = filter.apply(line.getText());
            if (result == null) continue;
            for (HyperlinkFilter.ResultItem item : result.getResultItems()) {
                HyperlinkStyle style = new HyperlinkStyle(this.myHyperlinkColor.getForeground(), this.myHyperlinkColor.getBackground(), item::navigate);
                line.writeString(item.getStartOffset(), new CharBuffer(line.getText().substring(item.getStartOffset(), item.getEndOffset())), style);
            }
        }
    }

    public void addHyperlinkFilter(HyperlinkFilter filter) {
        this.myHyperlinkFilter.add(filter);
    }
}

