/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.commit;

import com.intellij.dvcs.AmendComponent;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgActionUtil;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgCommitTypeCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.command.mq.HgQNewCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.HgCurrentBinaryContentRevision;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCheckinEnvironment
implements CheckinEnvironment {
    private final Project myProject;
    private boolean myNextCommitIsPushed;
    private boolean myNextCommitAmend;
    private boolean myShouldCommitSubrepos;
    private boolean myMqNewPatch;
    private boolean myCloseBranch;
    @Nullable
    private Collection<HgRepository> myRepos;

    public HgCheckinEnvironment(Project project) {
        this.myProject = project;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        this.reset();
        return new HgCommitAdditionalComponent(this.myProject, panel);
    }

    private void reset() {
        this.myNextCommitIsPushed = false;
        this.myShouldCommitSubrepos = false;
        this.myCloseBranch = false;
        this.myMqNewPatch = false;
        this.myRepos = null;
    }

    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        return null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return HgVcsMessages.message("hg4idea.commit", new Object[0]);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment", "commit"));
        }
        LinkedList<VcsException> exceptions = new LinkedList<VcsException>();
        Map<HgRepository, Set<HgFile>> repositoriesMap = this.getFilesByRepository(changes);
        this.addRepositoriesWithoutChanges(repositoriesMap);
        for (Map.Entry<HgRepository, Set<HgFile>> entry : repositoriesMap.entrySet()) {
            HgCommitTypeCommand command;
            HgRepository repo = entry.getKey();
            Set<HgFile> selectedFiles = entry.getValue();
            HgCommitTypeCommand hgCommitTypeCommand = this.myMqNewPatch ? new HgQNewCommand(this.myProject, repo, preparedComment, this.myNextCommitAmend) : (command = new HgCommitCommand(this.myProject, repo, preparedComment, this.myNextCommitAmend, this.myCloseBranch, this.myShouldCommitSubrepos && !selectedFiles.isEmpty()));
            if (this.isMergeCommit(repo.getRoot())) {
                boolean partial;
                Set<HgFile> changedFilesNotInCommit = this.getChangedFilesNotInCommit(repo.getRoot(), selectedFiles);
                boolean bl = partial = !changedFilesNotInCommit.isEmpty();
                if (partial) {
                    StringBuilder filesNotIncludedString = new StringBuilder();
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        filesNotIncludedString.append("<li>");
                        filesNotIncludedString.append(hgFile.getRelativePath());
                        filesNotIncludedString.append("</li>");
                    }
                    if (!this.mayCommitEverything(filesNotIncludedString.toString())) {
                        return exceptions;
                    }
                    VcsDirtyScopeManager dirtyManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
                    for (HgFile hgFile : changedFilesNotInCommit) {
                        dirtyManager.fileDirty(hgFile.toFilePath());
                    }
                }
            } else {
                command.setFiles(selectedFiles);
            }
            try {
                command.executeInCurrentThread();
            }
            catch (HgCommandException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        if (this.myNextCommitIsPushed && exceptions.isEmpty()) {
            ArrayList preselectedRepositories = ContainerUtil.newArrayList(repositoriesMap.keySet());
            GuiUtils.invokeLaterIfNeeded(() -> new VcsPushDialog(this.myProject, preselectedRepositories, (Repository)HgUtil.getCurrentRepository(this.myProject)).show(), (ModalityState)ModalityState.defaultModalityState());
        }
        return exceptions;
    }

    private boolean isMergeCommit(VirtualFile repo) {
        return new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo).size() > 1;
    }

    private Set<HgFile> getChangedFilesNotInCommit(VirtualFile repo, Set<HgFile> selectedFiles) {
        List<HgRevisionNumber> parents = new HgWorkingCopyRevisionsCommand(this.myProject).parents(repo);
        HgStatusCommand statusCommand = new HgStatusCommand.Builder(true).unknown(false).ignored(false).baseRevision(parents.get(0)).build(this.myProject);
        Set<HgChange> allChangedFilesInRepo = statusCommand.executeInCurrentThread(repo);
        HashSet<HgFile> filesNotIncluded = new HashSet<HgFile>();
        for (HgChange change : allChangedFilesInRepo) {
            HgFile beforeFile = change.beforeFile();
            HgFile afterFile = change.afterFile();
            if (!selectedFiles.contains(beforeFile)) {
                filesNotIncluded.add(beforeFile);
                continue;
            }
            if (selectedFiles.contains(afterFile)) continue;
            filesNotIncluded.add(afterFile);
        }
        return filesNotIncluded;
    }

    private boolean mayCommitEverything(final String filesNotIncludedString) {
        final int[] choice = new int[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                choice[0] = Messages.showOkCancelDialog((Project)HgCheckinEnvironment.this.myProject, (String)HgVcsMessages.message("hg4idea.commit.partial.merge.message", filesNotIncludedString), (String)HgVcsMessages.message("hg4idea.commit.partial.merge.title", new Object[0]), null);
            }
        };
        ApplicationManager.getApplication().invokeAndWait(runnable);
        return choice[0] == 0;
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        final ArrayList<HgFile> filesWithRoots = new ArrayList<HgFile>();
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath);
            if (vcsRoot == null) continue;
            filesWithRoots.add(new HgFile(vcsRoot, filePath));
        }
        new Task.Backgroundable(this.myProject, "Removing Files..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$2", "run"));
                }
                new HgRemoveCommand(this.myProject).executeInCurrentThread(filesWithRoots);
            }
        }.queue();
        return null;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        new HgAddCommand(this.myProject).addWithProgress(files);
        return null;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return false;
    }

    @NotNull
    private Map<HgRepository, Set<HgFile>> getFilesByRepository(List<Change> changes) {
        HashMap<HgRepository, Set<HgFile>> result = new HashMap<HgRepository, Set<HgFile>>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision != null) {
                this.addFile(result, afterRevision);
            }
            if (beforeRevision == null) continue;
            this.addFile(result, beforeRevision);
        }
        HashMap<HgRepository, Set<HgFile>> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment", "getFilesByRepository"));
        }
        return hashMap;
    }

    private void addFile(Map<HgRepository, Set<HgFile>> result, ContentRevision contentRevision) {
        FilePath filePath = contentRevision.getFile();
        HgRepository repo = HgUtil.getRepositoryForFile(this.myProject, contentRevision instanceof HgCurrentBinaryContentRevision ? ((HgCurrentBinaryContentRevision)contentRevision).getRepositoryRoot() : ChangesUtil.findValidParentAccurately((FilePath)filePath));
        if (repo == null) {
            return;
        }
        Set<HgFile> hgFiles = result.get(repo);
        if (hgFiles == null) {
            hgFiles = new HashSet<HgFile>();
            result.put(repo, hgFiles);
        }
        hgFiles.add(new HgFile(repo.getRoot(), filePath));
    }

    public void setNextCommitIsPushed() {
        this.myNextCommitIsPushed = true;
    }

    public void setMqNew() {
        this.myMqNewPatch = true;
    }

    public void setCloseBranch(boolean closeBranch) {
        this.myCloseBranch = closeBranch;
    }

    public void setRepos(@NotNull Collection<HgRepository> repos) {
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment", "setRepos"));
        }
        this.myRepos = repos;
    }

    private void addRepositoriesWithoutChanges(@NotNull Map<HgRepository, Set<HgFile>> repositoryMap) {
        if (repositoryMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryMap", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment", "addRepositoriesWithoutChanges"));
        }
        if (this.myRepos == null) {
            return;
        }
        for (HgRepository repository : this.myRepos) {
            if (repositoryMap.keySet().contains(repository)) continue;
            repositoryMap.put(repository, Collections.emptySet());
        }
    }

    public class HgCommitAdditionalComponent
    implements RefreshableOnComponent {
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final AmendComponent myAmend;
        @NotNull
        private final JCheckBox myCommitSubrepos;

        HgCommitAdditionalComponent(@NotNull Project project, CheckinProjectPanel panel) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent", "<init>"));
            }
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent", "<init>"));
            }
            HgVcs vcs = (HgVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)HgVcs.getInstance(HgCheckinEnvironment.this.myProject))));
            this.myAmend = new MyAmendComponent(project, HgUtil.getRepositoryManager(project), panel, "Amend Commit (QRefresh)");
            this.myAmend.getComponent().setEnabled(vcs.getVersion().isAmendSupported());
            this.myCommitSubrepos = new JCheckBox("Commit subrepositories", false);
            this.myCommitSubrepos.setToolTipText(XmlStringUtil.wrapInHtml((CharSequence)"Commit all subrepos for selected repositories.<br> <code>hg ci <i><b>files</b></i> -S <i><b>subrepos</b></i></code>"));
            this.myCommitSubrepos.setMnemonic('s');
            List<HgRepository> repos = HgActionUtil.collectRepositoriesFromFiles(HgUtil.getRepositoryManager(HgCheckinEnvironment.this.myProject), panel.getRoots());
            this.myCommitSubrepos.setVisible(ContainerUtil.exists(repos, HgRepository::hasSubrepos));
            this.myCommitSubrepos.addActionListener(new MySelectionListener(this.myAmend.getCheckBox()));
            this.myAmend.getCheckBox().addActionListener(new MySelectionListener(this.myCommitSubrepos));
            GridBag gb = new GridBag().setDefaultInsets((Insets)JBUI.insets((int)2)).setDefaultAnchor(17).setDefaultWeightX(1.0).setDefaultFill(2);
            this.myPanel = new JPanel(new GridBagLayout());
            this.myPanel.add(this.myAmend.getComponent(), gb.nextLine().next());
            this.myPanel.add((Component)this.myCommitSubrepos, gb.nextLine().next());
        }

        public void refresh() {
            this.myAmend.refresh();
            this.restoreState();
        }

        public void saveState() {
            HgCheckinEnvironment.this.myNextCommitAmend = this.isAmend();
            HgCheckinEnvironment.this.myShouldCommitSubrepos = this.myCommitSubrepos.isSelected();
        }

        public void restoreState() {
            HgCheckinEnvironment.this.myNextCommitAmend = false;
            HgCheckinEnvironment.this.myShouldCommitSubrepos = false;
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isAmend() {
            return this.myAmend.isAmend();
        }

        private class MySelectionListener
        implements ActionListener {
            private final JCheckBox myUnselectedComponent;

            public MySelectionListener(JCheckBox unselectedComponent) {
                this.myUnselectedComponent = unselectedComponent;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                if (source.isSelected()) {
                    this.myUnselectedComponent.setSelected(false);
                    this.myUnselectedComponent.setEnabled(false);
                } else {
                    this.myUnselectedComponent.setEnabled(true);
                }
            }
        }

        private class MyAmendComponent
        extends AmendComponent {
            public MyAmendComponent(@NotNull Project project, @NotNull HgRepositoryManager repoManager, @NotNull CheckinProjectPanel panel, String title) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent$MyAmendComponent", "<init>"));
                }
                if (repoManager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoManager", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent$MyAmendComponent", "<init>"));
                }
                if (panel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent$MyAmendComponent", "<init>"));
                }
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent$MyAmendComponent", "<init>"));
                }
                super(project, (RepositoryManager)repoManager, panel, title);
            }

            @NotNull
            protected Set<VirtualFile> getVcsRoots(@NotNull Collection<FilePath> filePaths) {
                if (filePaths == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent$MyAmendComponent", "getVcsRoots"));
                }
                Set<VirtualFile> set = HgUtil.hgRoots(HgCheckinEnvironment.this.myProject, filePaths);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent$MyAmendComponent", "getVcsRoots"));
                }
                return set;
            }

            @Nullable
            protected String getLastCommitMessage(@NotNull VirtualFile repo) throws VcsException {
                if (repo == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/provider/commit/HgCheckinEnvironment$HgCommitAdditionalComponent$MyAmendComponent", "getLastCommitMessage"));
                }
                HgCommandExecutor commandExecutor = new HgCommandExecutor(HgCheckinEnvironment.this.myProject);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-r");
                args.add(".");
                args.add("--template");
                args.add("{desc}");
                HgCommandResult result = commandExecutor.executeInCurrentThread(repo, "log", args);
                return result == null ? "" : result.getRawOutput();
            }
        }
    }
}

