/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.provider.HgCurrentBinaryContentRevision;

class HgCurrentContentRevision
extends CurrentContentRevision {
    private final VcsRevisionNumber revisionNumber;

    public HgCurrentContentRevision(HgFile hgFile, VcsRevisionNumber revisionNumber, VirtualFile virtualFile) {
        super(hgFile.toFilePath());
        this.revisionNumber = revisionNumber;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.revisionNumber;
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/provider/HgCurrentContentRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    public static ContentRevision create(@NotNull HgFile hgFile, @NotNull HgRevisionNumber revision) {
        if (hgFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/provider/HgCurrentContentRevision", "create"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/zmlx/hg4idea/provider/HgCurrentContentRevision", "create"));
        }
        VirtualFile virtualFile = VcsUtil.getVirtualFile((File)hgFile.getFile());
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.getFileType().isBinary()) {
            return new HgCurrentContentRevision(hgFile, revision, virtualFile);
        }
        return new HgCurrentBinaryContentRevision(hgFile, revision);
    }
}

