/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleStructureViewModel
implements PropertiesGroupingStructureViewModel,
StructureViewModel.ExpandInfoProvider {
    private final ResourceBundle myResourceBundle;
    private final GroupByWordPrefixes myByWordPrefixesGrouper;
    private final ResourceBundleFileStructureViewElement myRoot;

    public ResourceBundleStructureViewModel(ResourceBundle root) {
        this.myResourceBundle = root;
        String separator = PropertiesSeparatorManager.getInstance(root.getProject()).getSeparator(this.myResourceBundle);
        this.myByWordPrefixesGrouper = new GroupByWordPrefixes(separator);
        this.myRoot = new ResourceBundleFileStructureViewElement(this.myResourceBundle);
    }

    @Override
    public void setSeparator(String separator) {
        this.myByWordPrefixesGrouper.setSeparator(separator);
        PropertiesSeparatorManager.getInstance(this.myResourceBundle.getProject()).setSeparator(this.myResourceBundle, separator);
    }

    public void setShowOnlyIncomplete(boolean showOnlyIncomplete) {
        this.myRoot.setShowOnlyIncomplete(showOnlyIncomplete);
    }

    public boolean isShowOnlyIncomplete() {
        return this.myRoot.isShowOnlyIncomplete();
    }

    @Override
    public String getSeparator() {
        return this.myByWordPrefixesGrouper.getSeparator();
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        ResourceBundleFileStructureViewElement resourceBundleFileStructureViewElement = this.myRoot;
        if (resourceBundleFileStructureViewElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getRoot"));
        }
        return resourceBundleFileStructureViewElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = new Grouper[]{this.myByWordPrefixesGrouper};
        if (grouperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getGroupers"));
        }
        return grouperArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getSorters"));
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getFilters"));
        }
        return Filter.EMPTY_ARRAY;
    }

    public Object getCurrentEditorElement() {
        return null;
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "addEditorPositionListener"));
        }
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "removeEditorPositionListener"));
        }
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "addModelListener"));
        }
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "removeModelListener"));
        }
    }

    public void dispose() {
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return element instanceof ResourceBundlePropertyStructureViewElement;
    }

    public boolean isAutoExpand(@NotNull StructureViewTreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "isAutoExpand"));
        }
        return this.getRoot() == element;
    }

    public boolean isSmartExpand() {
        return false;
    }
}

