/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.editor.GotoPropertyParentDeclarationHandler;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PropertiesInheritorsSearcher
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance(PropertiesInheritorsSearcher.class);

    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/properties/editor/PropertiesInheritorsSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/properties/editor/PropertiesInheritorsSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElement();
        Property prop = (Property)ReadAction.compute(() -> GotoPropertyParentDeclarationHandler.findProperty(element));
        if (prop == null || !(queryParameters.getScope() instanceof GlobalSearchScope)) {
            return;
        }
        ReadAction.run(() -> {
            if (queryParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/properties/editor/PropertiesInheritorsSearcher", "lambda$processQuery$6"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/properties/editor/PropertiesInheritorsSearcher", "lambda$processQuery$6"));
            }
            String key = prop.getKey();
            if (!prop.isValid() || key == null) {
                return;
            }
            PropertiesFile currentFile = PropertiesImplUtil.getPropertiesFile(prop.getContainingFile());
            LOG.assertTrue(currentFile != null);
            GlobalSearchScope scope = (GlobalSearchScope)queryParameters.getScope();
            currentFile.getResourceBundle().getPropertiesFiles().stream().filter(f -> f.equals(currentFile)).filter(f -> scope.contains(f.getVirtualFile())).filter(f -> PropertiesUtil.getParent(f, Collections.singleton(currentFile)) == currentFile).map(f -> f.findPropertyByKey(key)).filter(Objects::nonNull).map(IProperty::getPsiElement).anyMatch(psiElement -> {
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/properties/editor/PropertiesInheritorsSearcher", "lambda$null$5"));
                }
                ProgressManager.checkCanceled();
                return !consumer.process(psiElement);
            });
        });
    }
}

